/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.app.Activity;
import android.app.ActivityManager;
import com.robotium.solo.ActivityUtils;
import com.robotium.solo.Waiter;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Asserter {
    private final ActivityUtils activityUtils;
    private final Waiter waiter;

    public Asserter(ActivityUtils activityUtils, Waiter waiter) {
        this.activityUtils = activityUtils;
        this.waiter = waiter;
    }

    public void assertCurrentActivity(String message, String name) {
        boolean foundActivity = this.waiter.waitForActivity(name);
        if (!foundActivity) {
            Assert.assertEquals((String)message, (String)name, (String)this.activityUtils.getCurrentActivity().getClass().getSimpleName());
        }
    }

    public void assertCurrentActivity(String message, Class<? extends Activity> expectedClass) {
        boolean foundActivity;
        if (expectedClass == null) {
            Assert.fail((String)"The specified Activity is null!");
        }
        if (!(foundActivity = this.waiter.waitForActivity(expectedClass))) {
            Assert.assertEquals((String)message, (String)expectedClass.getName(), (String)this.activityUtils.getCurrentActivity().getClass().getName());
        }
    }

    public void assertCurrentActivity(String message, String name, boolean isNewInstance) {
        this.assertCurrentActivity(message, name);
        this.assertCurrentActivity(message, this.activityUtils.getCurrentActivity().getClass(), isNewInstance);
    }

    public void assertCurrentActivity(String message, Class<? extends Activity> expectedClass, boolean isNewInstance) {
        boolean found = false;
        this.assertCurrentActivity(message, expectedClass);
        Activity activity = this.activityUtils.getCurrentActivity(false);
        for (int i = 0; i < this.activityUtils.getAllOpenedActivities().size() - 1; ++i) {
            String instanceString = this.activityUtils.getAllOpenedActivities().get(i).toString();
            if (!instanceString.equals(activity.toString())) continue;
            found = true;
        }
        Assert.assertNotSame((String)message, (Object)isNewInstance, (Object)found);
    }

    public void assertMemoryNotLow() {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ((ActivityManager)this.activityUtils.getCurrentActivity().getSystemService("activity")).getMemoryInfo(mi);
        Assert.assertFalse((String)("Low memory available: " + mi.availMem + " bytes!"), (boolean)mi.lowMemory);
    }
}

