/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Context;
import android.os.SystemClock;
import android.util.Log;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.AbsListView;
import android.widget.TextView;
import com.robotium.solo.ActivityUtils;
import com.robotium.solo.By;
import com.robotium.solo.DialogUtils;
import com.robotium.solo.RobotiumUtils;
import com.robotium.solo.Sender;
import com.robotium.solo.Sleeper;
import com.robotium.solo.Timeout;
import com.robotium.solo.ViewFetcher;
import com.robotium.solo.Waiter;
import com.robotium.solo.WebElement;
import com.robotium.solo.WebUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Clicker {
    private final String LOG_TAG = "Robotium";
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Instrumentation inst;
    private final Sender sender;
    private final Sleeper sleeper;
    private final Waiter waiter;
    private final WebUtils webUtils;
    private final DialogUtils dialogUtils;
    private final int MINI_WAIT = 200;
    private final int WAIT_TIME = 1500;

    public Clicker(ActivityUtils activityUtils, ViewFetcher viewFetcher, Sender sender, Instrumentation inst, Sleeper sleeper, Waiter waiter, WebUtils webUtils, DialogUtils dialogUtils) {
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.sender = sender;
        this.inst = inst;
        this.sleeper = sleeper;
        this.waiter = waiter;
        this.webUtils = webUtils;
        this.dialogUtils = dialogUtils;
    }

    public void clickOnScreen(float x, float y, View view) {
        boolean successfull = false;
        int retry = 0;
        Object ex = null;
        while (!successfull && retry < 10) {
            long downTime = SystemClock.uptimeMillis();
            long eventTime = SystemClock.uptimeMillis();
            MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)x, (float)y, (int)0);
            MotionEvent event2 = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)x, (float)y, (int)0);
            try {
                this.inst.sendPointerSync(event);
                this.inst.sendPointerSync(event2);
                successfull = true;
            }
            catch (SecurityException e) {
                ex = e;
                this.dialogUtils.hideSoftKeyboard(null, false, true);
                this.sleeper.sleep(200);
                ++retry;
                View identicalView = this.viewFetcher.getIdenticalView(view);
                if (identicalView == null) continue;
                float[] xyToClick = this.getClickCoordinates(identicalView);
                x = xyToClick[0];
                y = xyToClick[1];
            }
        }
        if (!successfull) {
            Assert.fail((String)("Click at (" + x + ", " + y + ") can not be completed! (" + (ex != null ? ex.getClass().getName() + ": " + ((Throwable)ex).getMessage() : "null") + ")"));
        }
    }

    public void clickLongOnScreen(float x, float y, int time, View view) {
        boolean successfull = false;
        int retry = 0;
        SecurityException ex = null;
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)x, (float)y, (int)0);
        while (!successfull && retry < 10) {
            try {
                this.inst.sendPointerSync(event);
                successfull = true;
                this.sleeper.sleep(200);
            }
            catch (SecurityException e) {
                ex = e;
                this.dialogUtils.hideSoftKeyboard(null, false, true);
                this.sleeper.sleep(200);
                ++retry;
                View identicalView = this.viewFetcher.getIdenticalView(view);
                if (identicalView == null) continue;
                float[] xyToClick = this.getClickCoordinates(identicalView);
                x = xyToClick[0];
                y = xyToClick[1];
            }
        }
        if (!successfull) {
            Assert.fail((String)("Long click at (" + x + ", " + y + ") can not be completed! (" + (ex != null ? ex.getClass().getName() + ": " + ex.getMessage() : "null") + ")"));
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)2, (float)(x + 1.0f), (float)(y + 1.0f), (int)0);
        this.inst.sendPointerSync(event);
        if (time > 0) {
            this.sleeper.sleep(time);
        } else {
            this.sleeper.sleep((int)((float)ViewConfiguration.getLongPressTimeout() * 2.5f));
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)x, (float)y, (int)0);
        this.inst.sendPointerSync(event);
        this.sleeper.sleep();
    }

    public void clickOnScreen(View view) {
        this.clickOnScreen(view, false, 0);
    }

    public void clickOnScreen(View view, boolean longClick, int time) {
        if (view == null) {
            Assert.fail((String)"View is null and can therefore not be clicked!");
        }
        float[] xyToClick = this.getClickCoordinates(view);
        float x = xyToClick[0];
        float y = xyToClick[1];
        if (x == 0.0f || y == 0.0f) {
            this.sleeper.sleepMini();
            try {
                view = this.viewFetcher.getIdenticalView(view);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (view != null) {
                xyToClick = this.getClickCoordinates(view);
                x = xyToClick[0];
                y = xyToClick[1];
            }
        }
        if (longClick) {
            this.clickLongOnScreen(x, y, time, view);
        } else {
            this.clickOnScreen(x, y, view);
        }
    }

    private float[] getClickCoordinates(View view) {
        this.sleeper.sleep(200);
        int[] xyLocation = new int[2];
        float[] xyToClick = new float[2];
        view.getLocationOnScreen(xyLocation);
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        float x = (float)xyLocation[0] + (float)viewWidth / 2.0f;
        float y = (float)xyLocation[1] + (float)viewHeight / 2.0f;
        xyToClick[0] = x;
        xyToClick[1] = y;
        return xyToClick;
    }

    public void clickLongOnTextAndPress(String text, int index) {
        this.clickOnText(text, true, 0, true, 0);
        this.dialogUtils.waitForDialogToOpen(Timeout.getSmallTimeout(), true);
        try {
            this.inst.sendKeyDownUpSync(20);
        }
        catch (SecurityException e) {
            Assert.fail((String)"Can not press the context menu!");
        }
        for (int i = 0; i < index; ++i) {
            this.sleeper.sleepMini();
            this.inst.sendKeyDownUpSync(20);
        }
        this.inst.sendKeyDownUpSync(66);
    }

    private void openMenu() {
        this.sleeper.sleepMini();
        if (!this.dialogUtils.waitForDialogToOpen(200L, false)) {
            try {
                this.sender.sendKeyCode(82);
                this.dialogUtils.waitForDialogToOpen(1500L, true);
            }
            catch (SecurityException e) {
                Assert.fail((String)"Can not open the menu!");
            }
        }
    }

    public void clickOnMenuItem(String text) {
        this.openMenu();
        this.clickOnText(text, false, 1, true, 0);
    }

    public void clickOnMenuItem(String text, boolean subMenu) {
        boolean textShown;
        this.sleeper.sleepMini();
        TextView textMore = null;
        int[] xy = new int[2];
        int x = 0;
        int y = 0;
        if (!this.dialogUtils.waitForDialogToOpen(200L, false)) {
            try {
                this.sender.sendKeyCode(82);
                this.dialogUtils.waitForDialogToOpen(1500L, true);
            }
            catch (SecurityException e) {
                Assert.fail((String)"Can not open the menu!");
            }
        }
        boolean bl = textShown = this.waiter.waitForText(text, 1, 1500L, true) != null;
        if (subMenu && this.viewFetcher.getCurrentViews(TextView.class, true).size() > 5 && !textShown) {
            for (TextView textView : this.viewFetcher.getCurrentViews(TextView.class, true)) {
                x = xy[0];
                y = xy[1];
                textView.getLocationOnScreen(xy);
                if (xy[0] <= x && xy[1] <= y) continue;
                textMore = textView;
            }
        }
        if (textMore != null) {
            this.clickOnScreen((View)textMore);
        }
        this.clickOnText(text, false, 1, true, 0);
    }

    public void clickOnActionBarItem(int resourceId) {
        this.sleeper.sleep();
        this.inst.invokeMenuActionSync(this.activityUtils.getCurrentActivity(), resourceId, 0);
    }

    public void clickOnActionBarHomeButton() {
        Activity activity = this.activityUtils.getCurrentActivity();
        MenuItem homeMenuItem = null;
        try {
            Class<?> cls = Class.forName("com.android.internal.view.menu.ActionMenuItem");
            Class[] partypes = new Class[]{Context.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CharSequence.class};
            Constructor<?> ct = cls.getConstructor(partypes);
            Object[] argList = new Object[]{activity, 0, 16908332, 0, 0, ""};
            homeMenuItem = (MenuItem)ct.newInstance(argList);
        }
        catch (Exception ex) {
            Log.d((String)"Robotium", (String)"Can not find methods to invoke Home button!");
        }
        if (homeMenuItem != null) {
            try {
                activity.getWindow().getCallback().onMenuItemSelected(0, homeMenuItem);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clickOnWebElement(By by, int match, boolean scroll, boolean useJavaScriptToClick) {
        WebElement webElement = null;
        if (useJavaScriptToClick) {
            webElement = this.waiter.waitForWebElement(by, match, Timeout.getSmallTimeout(), false);
            if (webElement == null) {
                Assert.fail((String)("WebElement with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' is not found!"));
            }
            this.webUtils.executeJavaScript(by, true);
            return;
        }
        WebElement webElementToClick = this.waiter.waitForWebElement(by, match, Timeout.getSmallTimeout(), scroll);
        if (webElementToClick == null) {
            if (match > 1) {
                Assert.fail((String)(match + " WebElements with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' are not found!"));
            } else {
                Assert.fail((String)("WebElement with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' is not found!"));
            }
        }
        this.clickOnScreen(webElementToClick.getLocationX(), webElementToClick.getLocationY(), null);
    }

    public void clickOnText(String regex, boolean longClick, int match, boolean scroll, int time) {
        TextView textToClick = this.waiter.waitForText(regex, match, Timeout.getSmallTimeout(), scroll, true, false);
        if (textToClick != null) {
            this.clickOnScreen((View)textToClick, longClick, time);
        } else if (match > 1) {
            Assert.fail((String)(match + " matches of text string: '" + regex + "' are not found!"));
        } else {
            ArrayList<TextView> allTextViews = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getCurrentViews(TextView.class, true));
            allTextViews.addAll(this.webUtils.getTextViewsFromWebView());
            for (TextView textView : allTextViews) {
                Log.d((String)"Robotium", (String)("'" + regex + "' not found. Have found: '" + textView.getText() + "'"));
            }
            allTextViews = null;
            Assert.fail((String)("Text string: '" + regex + "' is not found!"));
        }
    }

    public <T extends TextView> void clickOn(Class<T> viewClass, String nameRegex) {
        T viewToClick = this.waiter.waitForText(viewClass, nameRegex, 0, Timeout.getSmallTimeout(), true, true, false);
        if (viewToClick != null) {
            this.clickOnScreen((View)viewToClick);
        } else {
            ArrayList<TextView> allTextViews = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getCurrentViews(viewClass, true));
            for (TextView view : allTextViews) {
                Log.d((String)"Robotium", (String)("'" + nameRegex + "' not found. Have found: '" + view.getText() + "'"));
            }
            Assert.fail((String)(viewClass.getSimpleName() + " with text: '" + nameRegex + "' is not found!"));
        }
    }

    public <T extends View> void clickOn(Class<T> viewClass, int index) {
        this.clickOnScreen((View)this.waiter.waitForAndGetView(index, viewClass));
    }

    public ArrayList<TextView> clickInList(int line) {
        return this.clickInList(line, 0, false, 0);
    }

    public ArrayList<TextView> clickInList(int line, int index, boolean longClick, int time) {
        long endTime = SystemClock.uptimeMillis() + (long)Timeout.getSmallTimeout();
        int lineIndex = line - 1;
        if (lineIndex < 0) {
            lineIndex = 0;
        }
        ArrayList<Object> views = new ArrayList();
        AbsListView absListView = this.waiter.waitForAndGetView(index, AbsListView.class);
        if (absListView == null) {
            Assert.fail((String)"ListView is null!");
        }
        while (lineIndex > absListView.getChildCount()) {
            boolean timedOut;
            boolean bl = timedOut = SystemClock.uptimeMillis() > endTime;
            if (timedOut) {
                int numberOfLines = absListView.getChildCount();
                Assert.fail((String)("Can not click on line number " + line + " as there are only " + numberOfLines + " lines available"));
            }
            this.sleeper.sleep();
        }
        View view = this.getViewOnListLine(absListView, index, lineIndex);
        if (view != null) {
            views = this.viewFetcher.getViews(view, true);
            views = RobotiumUtils.removeInvisibleViews(views);
            this.clickOnScreen(view, longClick, time);
        }
        return RobotiumUtils.filterViews(TextView.class, views);
    }

    private View getViewOnListLine(AbsListView absListView, int index, int lineIndex) {
        long endTime = SystemClock.uptimeMillis() + (long)Timeout.getSmallTimeout();
        View view = absListView.getChildAt(lineIndex);
        while (view == null) {
            boolean timedOut;
            boolean bl = timedOut = SystemClock.uptimeMillis() > endTime;
            if (timedOut) {
                Assert.fail((String)"View is null and can therefore not be clicked!");
            }
            this.sleeper.sleep();
            absListView = (AbsListView)this.viewFetcher.getIdenticalView((View)absListView);
            if (absListView == null) {
                absListView = this.waiter.waitForAndGetView(index, AbsListView.class);
            }
            view = absListView.getChildAt(lineIndex);
        }
        return view;
    }
}

