/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.view.View;
import android.widget.DatePicker;
import android.widget.ProgressBar;
import android.widget.SlidingDrawer;
import android.widget.TimePicker;
import com.robotium.solo.ActivityUtils;
import com.robotium.solo.Clicker;
import com.robotium.solo.Condition;
import com.robotium.solo.Getter;
import com.robotium.solo.Timeout;
import com.robotium.solo.Waiter;

class Setter {
    private final int CLOSED = 0;
    private final int OPENED = 1;
    private final ActivityUtils activityUtils;
    private final Getter getter;
    private final Clicker clicker;
    private final Waiter waiter;

    public Setter(ActivityUtils activityUtils, Getter getter, Clicker clicker, Waiter waiter) {
        this.activityUtils = activityUtils;
        this.getter = getter;
        this.clicker = clicker;
        this.waiter = waiter;
    }

    public void setDatePicker(final DatePicker datePicker, final int year, final int monthOfYear, final int dayOfMonth) {
        if (datePicker != null) {
            this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

                public void run() {
                    try {
                        datePicker.updateDate(year, monthOfYear, dayOfMonth);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void setTimePicker(final TimePicker timePicker, final int hour, final int minute) {
        if (timePicker != null) {
            this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

                public void run() {
                    try {
                        timePicker.setCurrentHour(Integer.valueOf(hour));
                        timePicker.setCurrentMinute(Integer.valueOf(minute));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void setProgressBar(final ProgressBar progressBar, final int progress) {
        if (progressBar != null) {
            this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

                public void run() {
                    try {
                        progressBar.setProgress(progress);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void setSlidingDrawer(final SlidingDrawer slidingDrawer, final int status) {
        if (slidingDrawer != null) {
            this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

                public void run() {
                    try {
                        switch (status) {
                            case 0: {
                                slidingDrawer.close();
                                break;
                            }
                            case 1: {
                                slidingDrawer.open();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void setNavigationDrawer(int status) {
        View homeView = this.getter.getView("home", 0);
        final View leftDrawer = this.getter.getView("left_drawer", 0);
        try {
            switch (status) {
                case 0: {
                    if (leftDrawer == null || homeView == null || !leftDrawer.isShown()) break;
                    this.clicker.clickOnScreen(homeView);
                    break;
                }
                case 1: {
                    if (leftDrawer == null || homeView == null || leftDrawer.isShown()) break;
                    this.clicker.clickOnScreen(homeView);
                    Condition condition = new Condition(){

                        public boolean isSatisfied() {
                            return leftDrawer.isShown();
                        }
                    };
                    this.waiter.waitForCondition(condition, Timeout.getSmallTimeout());
                }
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }
}

