/*
 * Decompiled with CFR 0.152.
 */
package com.dmurph.tracking.system;

import com.dmurph.tracking.AnalyticsConfigData;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;

public class AWTSystemPopulator {
    public static final void populateConfigData(AnalyticsConfigData data) {
        data.setEncoding(System.getProperty("file.encoding"));
        String region = System.getProperty("user.region");
        if (region == null) {
            region = System.getProperty("user.country");
        }
        data.setUserLanguage(String.valueOf(System.getProperty("user.language")) + "-" + region);
        int screenHeight = 0;
        int screenWidth = 0;
        GraphicsEnvironment ge = null;
        GraphicsDevice[] gs = null;
        try {
            ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            gs = ge.getScreenDevices();
            int i = 0;
            while (i < gs.length) {
                DisplayMode dm = gs[i].getDisplayMode();
                screenWidth += dm.getWidth();
                screenHeight += dm.getHeight();
                ++i;
            }
            if (screenHeight != 0 && screenWidth != 0) {
                data.setScreenResolution(String.valueOf(screenWidth) + "x" + screenHeight);
            }
            if (gs[0] != null) {
                String colorDepth = String.valueOf(gs[0].getDisplayMode().getBitDepth());
                int i2 = 1;
                while (i2 < gs.length) {
                    colorDepth = String.valueOf(colorDepth) + ", " + gs[i2].getDisplayMode().getBitDepth();
                    ++i2;
                }
                data.setColorDepth(colorDepth);
            }
        }
        catch (HeadlessException e) {
            data.setScreenResolution("NA");
            data.setColorDepth("NA");
        }
    }
}

