/*
 * Decompiled with CFR 0.152.
 */
package com.apple.safari;

import com.apple.safari.ConsoleWindow;
import java.io.PrintStream;
import java.util.Map;

public class DebugUtilities {
    public static void dumpThreadStacks(PrintStream stream) {
        Map<Thread, StackTraceElement[]> stackTraceMap = Thread.getAllStackTraces();
        StringBuffer stringBuffer = new StringBuffer();
        for (Thread t : stackTraceMap.keySet()) {
            String s = String.format("\"%s\" prio=%d tid=%x\n", t.getName(), t.getPriority(), t.getId());
            stringBuffer.append(s);
            StackTraceElement[] stackTraceElementArray = stackTraceMap.get(t);
            int n = 0;
            int n2 = stackTraceElementArray.length;
            while (n < n2) {
                StackTraceElement e = stackTraceElementArray[n];
                stringBuffer.append("    " + e + "\n");
                ++n;
            }
        }
        stream.println(stringBuffer.toString());
    }

    public static void dumpThreads(PrintStream stream) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Dump thread list ...\n");
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ConsoleWindow.dumpThreadGroup(threadGroup, stringBuffer);
        stringBuffer.append("Done.\n");
        System.out.println(stringBuffer.toString());
    }
}

