/*
 * Decompiled with CFR 0.152.
 */
package com.apple.safari;

import com.apple.safari.AppContextSetterThread;
import com.apple.safari.AppletClassLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;

public class AppletClassLoaderCache {
    private static HashMap loaders = new HashMap();
    private static final int MaximumReleaseLoaders = 2;
    private static LinkedList releasedLoaders = new LinkedList();
    private static Timer releasedLoadersReaper = null;
    private static final int ReleasedLoadersTimeout = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppletClassLoader getClassLoader(URL codebase, String archives) {
        String[] archivesArray = archives != null ? archives.split(",") : new String[]{};
        String key = codebase.toString();
        int i = 0;
        while (i < archivesArray.length) {
            archivesArray[i] = archivesArray[i].trim();
            key = String.valueOf(key) + "," + archivesArray[i];
            ++i;
        }
        HashMap hashMap = loaders;
        synchronized (hashMap) {
            AppletClassLoader loader = (AppletClassLoader)loaders.get(key);
            if (loader != null) {
                loader.ref();
                return loader;
            }
            LinkedList linkedList = releasedLoaders;
            synchronized (linkedList) {
                ListIterator it = releasedLoaders.listIterator();
                while (it.hasNext()) {
                    loader = (AppletClassLoader)it.next();
                    if (!loader.getKeyString().equals(key)) continue;
                    loaders.put(key, loader);
                    loader.ref();
                    it.remove();
                    if (releasedLoaders.isEmpty()) {
                        releasedLoadersReaper.cancel();
                        releasedLoadersReaper = null;
                    }
                    return loader;
                }
            }
            try {
                URL[] urls = new URL[archivesArray.length + 1];
                int i2 = 0;
                while (i2 < archivesArray.length) {
                    urls[i2] = new URL(codebase, archivesArray[i2]);
                    ++i2;
                }
                urls[urls.length - 1] = codebase;
                ThreadGroup threadGroup = new ThreadGroup(String.valueOf(key) + "-thread-group");
                loader = new AppletClassLoader(urls, threadGroup, key);
                loaders.put(key, loader);
                AppContextSetterThread thread = new AppContextSetterThread(threadGroup);
                thread.start();
                thread.waitOnObject();
                loader.setAppContext(thread.getAppContext());
                loader.ref();
                return loader;
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseClassLoader(AppletClassLoader loader) {
        HashMap hashMap = loaders;
        synchronized (hashMap) {
            if (loader.deref() > 0) {
                return;
            }
            LinkedList linkedList = releasedLoaders;
            synchronized (linkedList) {
                if (releasedLoadersReaper != null) {
                    releasedLoadersReaper.cancel();
                }
                releasedLoadersReaper = new Timer(true);
                releasedLoadersReaper.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        LinkedList linkedList = releasedLoaders;
                        synchronized (linkedList) {
                            ListIterator it = releasedLoaders.listIterator();
                            while (it.hasNext()) {
                                AppletClassLoader loader = (AppletClassLoader)it.next();
                                loader.dispose();
                                it.remove();
                            }
                        }
                    }
                }, 60000L);
                releasedLoaders.add(loader);
                if (releasedLoaders.size() > 2) {
                    AppletClassLoader releasedLoader = (AppletClassLoader)releasedLoaders.removeFirst();
                    releasedLoader.dispose();
                }
            }
            loaders.remove(loader.getKeyString());
        }
    }
}

