/*
 * Decompiled with CFR 0.152.
 */
package com.apple.safari;

import com.apple.safari.DebugUtilities;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class ConsoleWindow
extends Frame
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private TextArea textArea;

    public ConsoleWindow() {
        super("Debug Window");
        this.setSize(400, 400);
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        this.textArea.addKeyListener(this);
        this.add(this.textArea);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String str) {
        TextArea textArea = this.textArea;
        synchronized (textArea) {
            this.textArea.append(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        TextArea textArea = this.textArea;
        synchronized (textArea) {
            this.textArea.setText("");
        }
    }

    static void dumpThread(Thread thread, StringBuffer stringBuffer) {
        stringBuffer.append("   " + thread.getName() + "," + thread.getPriority());
        if (thread.isAlive()) {
            stringBuffer.append(",alive");
        }
        if (thread.isDaemon()) {
            stringBuffer.append(",daemon");
        }
        stringBuffer.append("\n");
    }

    static void dumpThreadGroup(ThreadGroup threadGroup, StringBuffer stringBuffer) {
        stringBuffer.append("Group " + threadGroup.getName() + ",ac=" + threadGroup.activeCount());
        stringBuffer.append(",agc=" + threadGroup.activeGroupCount() + ",pri=" + threadGroup.getMaxPriority() + "\n");
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int activeThreads = threadGroup.enumerate(threads, false);
        int i = 0;
        while (i < activeThreads) {
            ConsoleWindow.dumpThread(threads[i], stringBuffer);
            ++i;
        }
        ThreadGroup[] threadGroups = new ThreadGroup[threadGroup.activeGroupCount()];
        int activeGroups = threadGroup.enumerate(threadGroups, false);
        int i2 = 0;
        while (i2 < activeGroups) {
            ConsoleWindow.dumpThreadGroup(threadGroups[i2], stringBuffer);
            ++i2;
        }
    }

    void garbageCollect() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        this.append("Garbage collect ... completed.\n");
        this.printMemoryUsage();
    }

    void printMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        int percentage = 100 - (int)((double)freeMemory * 100.0 / (double)totalMemory);
        String s = "Memory: " + totalMemory / 1024L + "K Free: " + freeMemory / 1024L + "K (" + percentage + "%) ... completed.\n";
        this.append(s);
    }

    void callFinalizers() {
        System.out.print("Finalize objects on finalization queue ... ");
        System.runFinalization();
        System.out.println("completed.");
        this.printMemoryUsage();
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 67: {
                this.clear();
                break;
            }
            case 84: {
                DebugUtilities.dumpThreads(System.out);
                break;
            }
            case 71: {
                this.garbageCollect();
                break;
            }
            case 70: {
                this.callFinalizers();
                break;
            }
            case 77: {
                this.printMemoryUsage();
                break;
            }
            case 86: {
                DebugUtilities.dumpThreadStacks(System.out);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

