/*
 * Decompiled with CFR 0.152.
 */
package com.apple.safari;

import com.apple.safari.AppletClassLoader;
import com.apple.safari.AppletClassLoaderCache;
import com.apple.safari.AppletContextImpl;
import com.apple.safari.AppletHost;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import sun.awt.windows.WEmbeddedFrame;

public class AppletContainer
extends Panel
implements AppletStub,
Runnable {
    private static final long serialVersionUID = 1L;
    private WEmbeddedFrame embeddedFrame;
    private HashMap paramMap;
    private URL documentBase;
    private URL codeBase;
    private String className;
    private Thread mainThread;
    private AppletClassLoader classLoader;
    private LinkedList eventQueue;
    private Applet applet;
    private int appletState;
    private Thread loadThread;
    protected Class appletClass;
    private boolean isAppletActive;
    private Image loadingImage;
    private Image errorImage;
    private AppletContextImpl appletContext;
    private AppletHost host;
    private boolean hasApplet;
    private Object hasAppletLock = new Object();
    public static final int APPLET_EMPTY = 0;
    public static final int APPLET_LOAD = 1;
    public static final int APPLET_INIT = 2;
    public static final int APPLET_START = 3;
    public static final int APPLET_STOP = 4;
    public static final int APPLET_DESTROY = 5;
    public static final int APPLET_ERROR = 6;

    public AppletContainer(long parentWnd, long pluginInstance, String documentURLString, String[] paramNames, String[] paramValues) {
        this.createEmbeddedFrame(parentWnd);
        this.host = new AppletHost(pluginInstance);
        this.setLayout(new BorderLayout());
        this.embeddedFrame.add((Component)this, (Object)"Center");
        this.setVisible(true);
        this.repaint();
        this.addParameters(documentURLString, paramNames, paramValues);
        this.eventQueue = new LinkedList();
        try {
            this.classLoader = AppletClassLoaderCache.getClassLoader(this.codeBase, (String)this.paramMap.get("archive"));
            this.mainThread = new Thread(this.classLoader.getThreadGroup(), this, String.valueOf(this.className) + "-thread");
            this.mainThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addEvent(1);
    }

    private void createEmbeddedFrame(final long parentWnd) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    Constructor frameConstructor = null;
                    try {
                        frameConstructor = WEmbeddedFrame.class.getConstructor(Long.TYPE);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (frameConstructor == null) {
                        try {
                            frameConstructor = WEmbeddedFrame.class.getConstructor(Integer.TYPE);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    try {
                        AppletContainer.this.embeddedFrame = (WEmbeddedFrame)frameConstructor.newInstance(new Long(parentWnd));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    synchronized void loadImages() {
        if (this.loadingImage != null) {
            return;
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        this.loadingImage = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/CoffeeCup.png"));
        mediaTracker.addImage(this.loadingImage, 0);
        this.errorImage = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/CoffeeCupError.png"));
        mediaTracker.addImage(this.errorImage, 1);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(int eventCode) {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.eventQueue.add(new Integer(eventCode));
            this.eventQueue.notifyAll();
        }
    }

    private void addParameters(String documentURLString, String[] paramNames, String[] paramValues) {
        this.paramMap = new HashMap();
        int i = 0;
        while (i < paramNames.length) {
            this.paramMap.put(paramNames[i].toLowerCase(), paramValues[i]);
            ++i;
        }
        try {
            this.documentBase = new URL(documentURLString);
            if (this.paramMap.containsKey("codebase")) {
                String c = (String)this.paramMap.get("codebase");
                if (!c.endsWith("/")) {
                    c = String.valueOf(c) + "/";
                }
                this.codeBase = new URL(this.documentBase, c);
            } else {
                this.codeBase = new URL(this.documentBase, ".");
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.className = this.getClassName();
    }

    private String getClassName() {
        String name = null;
        String classid = (String)this.paramMap.get("classid");
        if (classid != null && classid.startsWith("java:") && (classid = classid.substring(5)).length() > 0) {
            name = classid;
        }
        if (name == null) {
            name = (String)this.paramMap.get("code");
        }
        if (name != null && name.endsWith("class")) {
            name = name.substring(0, name.length() - 6);
        }
        return name;
    }

    public void appletResize(int x, int y) {
    }

    public AppletContext getAppletContext() {
        return this.appletContext;
    }

    public URL getCodeBase() {
        return this.codeBase;
    }

    public URL getDocumentBase() {
        return this.documentBase;
    }

    public String getParameter(String paramName) {
        String lowercaseParam = paramName.toLowerCase();
        if (lowercaseParam.equals("width")) {
            return Integer.toString(this.getWidth());
        }
        if (lowercaseParam.equals("height")) {
            return Integer.toString(this.getHeight());
        }
        return (String)this.paramMap.get(lowercaseParam);
    }

    public boolean isActive() {
        return this.isAppletActive;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.loadImages();
        Image image = null;
        if (this.appletState == 0 || this.appletState == 1) {
            image = this.loadingImage;
        } else if (this.appletState == 6) {
            image = this.errorImage;
        }
        if (image != null) {
            int x = (this.getWidth() - image.getWidth(null)) / 2;
            int y = (this.getHeight() - image.getHeight(null)) / 2;
            g.drawImage(image, x, y, null);
        }
    }

    private synchronized void setLoadThread(Thread thread) {
        this.loadThread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        final AppletContainer c = this;
        block44: while (this.appletState != 5) {
            int event;
            block51: {
                LinkedList linkedList = this.eventQueue;
                synchronized (linkedList) {
                    while (true) {
                        while (true) {
                            if (!this.eventQueue.isEmpty()) {
                                event = (Integer)this.eventQueue.removeFirst();
                                break block51;
                            }
                            try {
                                this.eventQueue.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            switch (event) {
                case 1: {
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            try {
                                AppletContainer.this.appletClass = AppletContainer.this.classLoader.loadClass(AppletContainer.this.className);
                                if (AppletContainer.this.appletClass != null && Applet.class.isAssignableFrom(AppletContainer.this.appletClass)) {
                                    AppletContainer.this.applet = (Applet)AppletContainer.this.appletClass.newInstance();
                                }
                            }
                            catch (Exception e) {
                                System.out.println("Failed to load");
                                e.printStackTrace();
                                AppletContainer.this.addEvent(6);
                            }
                        }
                    }, String.valueOf(this.className) + "-loader");
                    t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        public void uncaughtException(Thread t, Throwable e) {
                            System.out.println("Failed to load");
                            e.printStackTrace();
                            AppletContainer.this.addEvent(6);
                        }
                    });
                    this.setLoadThread(t);
                    this.loadThread.start();
                    try {
                        this.loadThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.loadThread == null) {
                        this.addEvent(5);
                        break;
                    }
                    this.setLoadThread(null);
                    if (this.applet == null) continue block44;
                    this.applet.setStub(this);
                    this.appletContext = new AppletContextImpl(this.applet, this.host);
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            public void run() {
                                AppletContainer.this.applet.setVisible(false);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    this.addEvent(2);
                    break;
                }
                case 2: {
                    Object object;
                    try {
                        if (this.applet == null) continue block44;
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                public void run() {
                                    AppletContainer.this.add(AppletContainer.this.applet);
                                    AppletContainer.this.applet.setSize(AppletContainer.this.embeddedFrame.getSize());
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        this.applet.init();
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                public void run() {
                                    AppletContainer.this.applet.setVisible(true);
                                    AppletContainer.this.validate();
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        this.appletState = 2;
                        object = this.hasAppletLock;
                        synchronized (object) {
                            this.hasApplet = true;
                            this.hasAppletLock.notify();
                        }
                        this.addEvent(3);
                    }
                    catch (Exception e) {
                        System.out.println("Failed to init");
                        e.printStackTrace();
                        this.addEvent(6);
                    }
                    break;
                }
                case 3: {
                    this.isAppletActive = true;
                    try {
                        if (this.applet == null) continue block44;
                        this.applet.start();
                        this.appletState = 3;
                    }
                    catch (Exception e) {
                        System.out.println("Failed to start");
                        e.printStackTrace();
                        this.addEvent(6);
                    }
                    break;
                }
                case 4: {
                    this.isAppletActive = false;
                    try {
                        if (this.applet != null) {
                            this.applet.stop();
                            this.appletState = 4;
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Failed to stop");
                        e.printStackTrace();
                    }
                    this.addEvent(5);
                    break;
                }
                case 5: {
                    try {
                        if (this.applet != null) {
                            this.applet.destroy();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Failed to destroy");
                        e.printStackTrace();
                    }
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            public void run() {
                                AppletContainer.this.embeddedFrame.remove((Component)c);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    this.appletState = 5;
                    break;
                }
                case 6: {
                    this.appletState = 6;
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            public void run() {
                                c.repaint();
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    Object object = this.hasAppletLock;
                    synchronized (object) {
                        this.hasApplet = true;
                        this.hasAppletLock.notify();
                        break;
                    }
                }
            }
        }
    }

    private void interruptLoadThread() {
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.setLoadThread(null);
        }
    }

    public void setEmbeddedFrameSize(int width, int height) {
        final Dimension size = new Dimension(width, height);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AppletContainer.this.embeddedFrame.setSize(size);
                AppletContainer.this.embeddedFrame.validate();
            }
        });
    }

    public void activateEmbeddedFrame() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!AppletContainer.this.embeddedFrame.isActive()) {
                    AppletContainer.this.embeddedFrame.synthesizeWindowActivation(true);
                }
            }
        });
    }

    public void destroyApplet() {
        Thread destroyerThread = new Thread(new Runnable(){

            public void run() {
                if (AppletContainer.this.appletContext != null) {
                    AppletContainer.this.appletContext.dispose();
                }
                if (AppletContainer.this.loadThread != null) {
                    AppletContainer.this.interruptLoadThread();
                } else {
                    AppletContainer.this.addEvent(4);
                }
                try {
                    AppletContainer.this.mainThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AppletClassLoaderCache.releaseClassLoader(AppletContainer.this.classLoader);
            }
        });
        destroyerThread.start();
        try {
            destroyerThread.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean hasApplet() {
        return this.hasApplet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Applet getApplet() {
        Object object = this.hasAppletLock;
        synchronized (object) {
            while (!this.hasApplet) {
                try {
                    this.hasAppletLock.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            return this.applet;
        }
    }
}

