// Provides access to and manages the behavior of the FindBanner.
// @param flowView (JSBookmarksViewFindBanner) The Find Banner being controlled.
FindBannerController = function(findBanner)
{
    this._findBanner = findBanner;
    
    this.searchField = document.getElementById("search");
    this.searchField.setAttribute("placeholder", this._findBanner.searchPlaceholderText);
    this.searchField.addEventListener("search", this.onSearch.bind(this), false);
}

FindBannerController.prototype.onSearch = function()
{
    this._findBanner.onSearch(this.searchField.value);
}
