// Provides access to and manages the behavior of the FlowView.
// @param flowView (JSBookmarksViewFlowView) The Flow View being controlled. If
//      flowView is null or undefined, no events will be propogated back to the
//      native code.
FlowViewController = function(flowView)
{
    this._flowView = flowView;
}

FlowViewController.prototype.showSelected = function(bookmark)
{
    if (this._flowView)
        this._flowView.showSelected(bookmark);
}

FlowViewController.prototype.showFolderContents = function(bookmark)
{
    if (this._flowView)
        this._flowView.showFolderContents(bookmark);
}

FlowViewController.prototype.hideFolderContents = function(bookmark)
{
    if (this._flowView)
        this._flowView.hideFolderContents(bookmark);
}

