/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.tools.zip.ExtraFieldUtils;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipShort;

public class ZipEntry
extends java.util.zip.ZipEntry
implements Cloneable {
    private static final int PLATFORM_UNIX = 3;
    private static final int PLATFORM_FAT = 0;
    private int internalAttributes = 0;
    private int platform = 0;
    private long externalAttributes = 0L;
    private Vector extraFields = null;
    private String name = null;

    public ZipEntry(String string) {
        super(string);
    }

    public ZipEntry(java.util.zip.ZipEntry zipEntry) throws ZipException {
        super(zipEntry);
        byte[] byArray = zipEntry.getExtra();
        if (byArray != null) {
            this.setExtraFields(ExtraFieldUtils.parse(byArray));
        } else {
            this.setExtra();
        }
    }

    public ZipEntry(ZipEntry zipEntry) throws ZipException {
        this((java.util.zip.ZipEntry)zipEntry);
        this.setInternalAttributes(zipEntry.getInternalAttributes());
        this.setExternalAttributes(zipEntry.getExternalAttributes());
        this.setExtraFields(zipEntry.getExtraFields());
    }

    protected ZipEntry() {
        super("");
    }

    public Object clone() {
        ZipEntry zipEntry = (ZipEntry)super.clone();
        zipEntry.extraFields = this.extraFields != null ? (Vector)this.extraFields.clone() : null;
        zipEntry.setInternalAttributes(this.getInternalAttributes());
        zipEntry.setExternalAttributes(this.getExternalAttributes());
        zipEntry.setExtraFields(this.getExtraFields());
        return zipEntry;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int n) {
        this.internalAttributes = n;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long l) {
        this.externalAttributes = l;
    }

    public void setUnixMode(int n) {
        this.setExternalAttributes(n << 16 | ((n & 0x80) == 0 ? 1 : 0) | (this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int n) {
        this.platform = n;
    }

    public void setExtraFields(ZipExtraField[] zipExtraFieldArray) {
        this.extraFields = new Vector();
        for (int i = 0; i < zipExtraFieldArray.length; ++i) {
            this.extraFields.addElement(zipExtraFieldArray[i]);
        }
        this.setExtra();
    }

    public ZipExtraField[] getExtraFields() {
        if (this.extraFields == null) {
            return new ZipExtraField[0];
        }
        Object[] objectArray = new ZipExtraField[this.extraFields.size()];
        this.extraFields.copyInto(objectArray);
        return objectArray;
    }

    public void addExtraField(ZipExtraField zipExtraField) {
        if (this.extraFields == null) {
            this.extraFields = new Vector();
        }
        ZipShort zipShort = zipExtraField.getHeaderId();
        boolean bl = false;
        int n = this.extraFields.size();
        for (int i = 0; !bl && i < n; ++i) {
            if (!((ZipExtraField)this.extraFields.elementAt(i)).getHeaderId().equals(zipShort)) continue;
            this.extraFields.setElementAt(zipExtraField, i);
            bl = true;
        }
        if (!bl) {
            this.extraFields.addElement(zipExtraField);
        }
        this.setExtra();
    }

    public void removeExtraField(ZipShort zipShort) {
        if (this.extraFields == null) {
            this.extraFields = new Vector();
        }
        boolean bl = false;
        int n = this.extraFields.size();
        for (int i = 0; !bl && i < n; ++i) {
            if (!((ZipExtraField)this.extraFields.elementAt(i)).getHeaderId().equals(zipShort)) continue;
            this.extraFields.removeElementAt(i);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    public void setExtra(byte[] byArray) throws RuntimeException {
        try {
            this.setExtraFields(ExtraFieldUtils.parse(byArray));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields()));
    }

    public byte[] getLocalFileDataExtra() {
        byte[] byArray = this.getExtra();
        return byArray != null ? byArray : new byte[]{};
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields());
    }

    public void setComprSize(long l) {
        this.setCompressedSize(l);
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String string) {
        this.name = string;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }
}

