/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipException;
import org.apache.tools.zip.ZipOutputStream;

public class ZipFileInfo {
    private String encoding = null;
    private String comment = null;
    private RandomAccessFile archive;
    private static final int MIN_EOCD_SIZE = 22;

    public String getComment() {
        return this.comment;
    }

    public ZipFileInfo(File file) throws IOException {
        this(file, null);
    }

    public ZipFileInfo(String string) throws IOException {
        this(new File(string), null);
    }

    public ZipFileInfo(String string, String string2) throws IOException {
        this(new File(string), string2);
    }

    public ZipFileInfo(File file, String string) throws IOException {
        this.encoding = string;
        this.archive = new RandomAccessFile(file, "r");
        try {
            this.populateFromCentralDirectory();
        }
        catch (IOException iOException) {
            try {
                this.archive.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        this.archive.close();
    }

    private void populateFromCentralDirectory() throws IOException {
        this.positionAtCentralDirectory();
    }

    private void positionAtCentralDirectory() throws IOException {
        int n;
        byte[] byArray;
        boolean bl = false;
        long l = this.archive.length() - 22L;
        if (l >= 0L) {
            this.archive.seek(l);
            byArray = ZipOutputStream.EOCD_SIG;
            n = this.archive.read();
            while (n != -1) {
                if (n == byArray[0] && (n = this.archive.read()) == byArray[1] && (n = this.archive.read()) == byArray[2] && (n = this.archive.read()) == byArray[3]) {
                    bl = true;
                    break;
                }
                this.archive.seek(--l);
                n = this.archive.read();
            }
        }
        if (!bl) {
            throw new ZipException("archive is not a ZIP archive");
        }
        this.archive.seek(l + 22L - 2L);
        byArray = new byte[2];
        this.archive.readFully(byArray);
        n = byArray[1] << 8 & 0xFF00;
        byte[] byArray2 = new byte[n += byArray[0] & 0xFF];
        this.archive.readFully(byArray2);
        this.comment = this.getString(byArray2);
    }

    protected String getString(byte[] byArray) throws ZipException {
        if (this.encoding == null) {
            return new String(byArray);
        }
        try {
            return new String(byArray, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ZipException(unsupportedEncodingException.getMessage());
        }
    }
}

