/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipLong;
import org.apache.tools.zip.ZipShort;

public class ZipOutputStream
extends FilterOutputStream {
    public static final int DEFLATED = 8;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int STORED = 0;
    private ZipEntry entry;
    private String comment = "";
    private int level = -1;
    private boolean hasCompressionLevelChanged = false;
    private int method = 8;
    private Vector entries = new Vector();
    private List entryNames = new ArrayList();
    private CRC32 crc = new CRC32();
    private long written = 0L;
    private long dataStart = 0L;
    private long localDataStart = 0L;
    private long cdOffset = 0L;
    private long cdLength = 0L;
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private Hashtable offsets = new Hashtable();
    private String encoding = null;
    protected Deflater def = new Deflater(this.level, true);
    protected byte[] buf = new byte[512];
    private RandomAccessFile raf = null;
    protected static final byte[] LFH_SIG = ZipLong.getBytes(67324752L);
    protected static final byte[] DD_SIG = ZipLong.getBytes(134695760L);
    protected static final byte[] CFH_SIG = ZipLong.getBytes(33639248L);
    protected static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    private static final byte[] DOS_TIME_MIN = ZipLong.getBytes(8448L);

    public List getEntries() {
        return this.entryNames;
    }

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public ZipOutputStream(File file) throws IOException {
        super(null);
        try {
            this.raf = new RandomAccessFile(file, "rw");
            this.raf.setLength(0L);
        }
        catch (IOException iOException) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.raf = null;
            }
            this.out = new FileOutputStream(file);
        }
    }

    public boolean isSeekable() {
        return this.raf != null;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void finish() throws IOException {
        this.closeEntry();
        this.cdOffset = this.written;
        int n = this.entries.size();
        for (int i = 0; i < n; ++i) {
            this.writeCentralFileHeader((ZipEntry)this.entries.elementAt(i));
        }
        this.cdLength = this.written - this.cdOffset;
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.removeAllElements();
    }

    public void closeEntry() throws IOException {
        long l;
        if (this.entry == null) {
            return;
        }
        long l2 = this.crc.getValue();
        this.crc.reset();
        if (this.entry.getMethod() == 8) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            this.entry.setSize(ZipOutputStream.adjustToLong(this.def.getTotalIn()));
            this.entry.setCompressedSize(ZipOutputStream.adjustToLong(this.def.getTotalOut()));
            this.entry.setCrc(l2);
            this.def.reset();
            this.written += this.entry.getCompressedSize();
        } else if (this.raf == null) {
            if (this.entry.getCrc() != l2) {
                throw new ZipException("bad CRC checksum for entry " + this.entry.getName() + ": " + Long.toHexString(this.entry.getCrc()) + " instead of " + Long.toHexString(l2));
            }
            if (this.entry.getSize() != this.written - this.dataStart) {
                throw new ZipException("bad size for entry " + this.entry.getName() + ": " + this.entry.getSize() + " instead of " + (this.written - this.dataStart));
            }
        } else {
            l = this.written - this.dataStart;
            this.entry.setSize(l);
            this.entry.setCompressedSize(l);
            this.entry.setCrc(l2);
        }
        if (this.raf != null) {
            l = this.raf.getFilePointer();
            this.raf.seek(this.localDataStart);
            this.writeOut(ZipLong.getBytes(this.entry.getCrc()));
            this.writeOut(ZipLong.getBytes(this.entry.getCompressedSize()));
            this.writeOut(ZipLong.getBytes(this.entry.getSize()));
            this.raf.seek(l);
        }
        this.writeDataDescriptor(this.entry);
        this.entry = null;
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.closeEntry();
        this.entry = zipEntry;
        this.entries.addElement(this.entry);
        this.entryNames.add(this.entry.getName());
        if (this.entry.getMethod() == -1) {
            this.entry.setMethod(this.method);
        }
        if (this.entry.getTime() == -1L) {
            this.entry.setTime(System.currentTimeMillis());
        }
        if (this.entry.getMethod() == 0 && this.raf == null) {
            if (this.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (this.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            this.entry.setCompressedSize(this.entry.getSize());
        }
        if (this.entry.getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader(this.entry);
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setLevel(int n) {
        if (n < -1 || n > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + n);
        }
        this.hasCompressionLevelChanged = this.level != n;
        this.level = n;
    }

    public void setMethod(int n) {
        this.method = n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.entry.getMethod() == 8) {
            if (n2 > 0 && !this.def.finished()) {
                this.def.setInput(byArray, n, n2);
                while (!this.def.needsInput()) {
                    this.deflate();
                }
            }
        } else {
            this.writeOut(byArray, n, n2);
            this.written += (long)n2;
        }
        this.crc.update(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    public void close() throws IOException {
        this.finish();
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() throws IOException {
        int n = this.def.deflate(this.buf, 0, this.buf.length);
        if (n > 0) {
            this.writeOut(this.buf, 0, n);
        }
    }

    protected void writeLocalFileHeader(ZipEntry zipEntry) throws IOException {
        this.offsets.put(zipEntry, ZipLong.getBytes(this.written));
        this.writeOut(LFH_SIG);
        this.written += 4L;
        int n = zipEntry.getMethod();
        if (n == 8 && this.raf == null) {
            this.writeOut(ZipShort.getBytes(20));
            this.writeOut(ZipShort.getBytes(8));
        } else {
            this.writeOut(ZipShort.getBytes(10));
            this.writeOut(ZERO);
        }
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(n));
        this.written += 2L;
        this.writeOut(ZipOutputStream.toDosTime(zipEntry.getTime()));
        this.written += 4L;
        this.localDataStart = this.written;
        if (n == 8 || this.raf != null) {
            this.writeOut(LZERO);
            this.writeOut(LZERO);
            this.writeOut(LZERO);
        } else {
            this.writeOut(ZipLong.getBytes(zipEntry.getCrc()));
            this.writeOut(ZipLong.getBytes(zipEntry.getSize()));
            this.writeOut(ZipLong.getBytes(zipEntry.getSize()));
        }
        this.written += 12L;
        byte[] byArray = this.getBytes(zipEntry.getName());
        this.writeOut(ZipShort.getBytes(byArray.length));
        this.written += 2L;
        byte[] byArray2 = zipEntry.getLocalFileDataExtra();
        this.writeOut(ZipShort.getBytes(byArray2.length));
        this.written += 2L;
        this.writeOut(byArray);
        this.written += (long)byArray.length;
        this.writeOut(byArray2);
        this.written += (long)byArray2.length;
        this.dataStart = this.written;
    }

    protected void writeDataDescriptor(ZipEntry zipEntry) throws IOException {
        if (zipEntry.getMethod() != 8 || this.raf != null) {
            return;
        }
        this.writeOut(DD_SIG);
        this.writeOut(ZipLong.getBytes(this.entry.getCrc()));
        this.writeOut(ZipLong.getBytes(this.entry.getCompressedSize()));
        this.writeOut(ZipLong.getBytes(this.entry.getSize()));
        this.written += 16L;
    }

    protected void writeCentralFileHeader(ZipEntry zipEntry) throws IOException {
        this.writeOut(CFH_SIG);
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(zipEntry.getPlatform() << 8 | 0x14));
        this.written += 2L;
        if (zipEntry.getMethod() == 8 && this.raf == null) {
            this.writeOut(ZipShort.getBytes(20));
            this.writeOut(ZipShort.getBytes(8));
        } else {
            this.writeOut(ZipShort.getBytes(10));
            this.writeOut(ZERO);
        }
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(zipEntry.getMethod()));
        this.written += 2L;
        this.writeOut(ZipOutputStream.toDosTime(zipEntry.getTime()));
        this.written += 4L;
        this.writeOut(ZipLong.getBytes(zipEntry.getCrc()));
        this.writeOut(ZipLong.getBytes(zipEntry.getCompressedSize()));
        this.writeOut(ZipLong.getBytes(zipEntry.getSize()));
        this.written += 12L;
        byte[] byArray = this.getBytes(zipEntry.getName());
        this.writeOut(ZipShort.getBytes(byArray.length));
        this.written += 2L;
        byte[] byArray2 = zipEntry.getCentralDirectoryExtra();
        this.writeOut(ZipShort.getBytes(byArray2.length));
        this.written += 2L;
        String string = zipEntry.getComment();
        if (string == null) {
            string = "";
        }
        byte[] byArray3 = this.getBytes(string);
        this.writeOut(ZipShort.getBytes(byArray3.length));
        this.written += 2L;
        this.writeOut(ZERO);
        this.written += 2L;
        this.writeOut(ZipShort.getBytes(zipEntry.getInternalAttributes()));
        this.written += 2L;
        this.writeOut(ZipLong.getBytes(zipEntry.getExternalAttributes()));
        this.written += 4L;
        this.writeOut((byte[])this.offsets.get(zipEntry));
        this.written += 4L;
        this.writeOut(byArray);
        this.written += (long)byArray.length;
        this.writeOut(byArray2);
        this.written += (long)byArray2.length;
        this.writeOut(byArray3);
        this.written += (long)byArray3.length;
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.writeOut(EOCD_SIG);
        this.writeOut(ZERO);
        this.writeOut(ZERO);
        byte[] byArray = ZipShort.getBytes(this.entries.size());
        this.writeOut(byArray);
        this.writeOut(byArray);
        this.writeOut(ZipLong.getBytes(this.cdLength));
        this.writeOut(ZipLong.getBytes(this.cdOffset));
        byte[] byArray2 = this.getBytes(this.comment);
        this.writeOut(ZipShort.getBytes(byArray2.length));
        this.writeOut(byArray2);
    }

    protected static ZipLong toDosTime(Date date) {
        return new ZipLong(ZipOutputStream.toDosTime(date.getTime()));
    }

    protected static byte[] toDosTime(long l) {
        Date date = new Date(l);
        int n = date.getYear() + 1900;
        if (n < 1980) {
            return DOS_TIME_MIN;
        }
        int n2 = date.getMonth() + 1;
        long l2 = n - 1980 << 25 | n2 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
        return ZipLong.getBytes(l2);
    }

    protected byte[] getBytes(String string) throws ZipException {
        if (this.encoding == null) {
            return string.getBytes();
        }
        try {
            return string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ZipException(unsupportedEncodingException.getMessage());
        }
    }

    protected final void writeOut(byte[] byArray) throws IOException {
        this.writeOut(byArray, 0, byArray.length);
    }

    protected final void writeOut(byte[] byArray, int n, int n2) throws IOException {
        if (this.raf != null) {
            this.raf.write(byArray, n, n2);
        } else {
            this.out.write(byArray, n, n2);
        }
    }

    protected static long adjustToLong(int n) {
        if (n < 0) {
            return 0x100000000L + (long)n;
        }
        return n;
    }
}

