/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.dialog;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.eclipse.jface.dialogs.BaseDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.sf.feeling.sanguo.patch.Patch;
import org.sf.feeling.sanguo.patch.dialog.UnitModifyDialog;
import org.sf.feeling.sanguo.patch.model.Unit;
import org.sf.feeling.sanguo.patch.util.BakUtil;
import org.sf.feeling.sanguo.patch.util.ChangeCode;
import org.sf.feeling.sanguo.patch.util.CustomUnit;
import org.sf.feeling.sanguo.patch.util.UnitUtil;
import org.sf.feeling.sanguo.patch.widget.FormWidgetFactory;
import org.sf.feeling.sanguo.patch.widget.ImageCanvas;
import org.sf.feeling.sanguo.patch.widget.WidgetUtil;
import org.sf.feeling.swt.win32.extension.graphics.GraphicsUtil;
import org.sf.feeling.swt.win32.extension.graphics.TgaLoader;
import org.sf.feeling.swt.win32.extension.util.SortMap;
import org.sf.feeling.swt.win32.extension.widgets.ShellWrapper;

public class CustomGeneralUnitDialog
extends BaseDialog {
    ModifyListener nameListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            CustomGeneralUnitDialog.this.checkEnableStatus();
        }
    };
    private Text nameText;
    private CCombo soldierImageCombo;
    private ImageCanvas imageCanvas;
    private SortMap generalUnitMap;
    private SortMap factionMap;
    private Text idText;
    private Button soldierButton;
    private Button soldierImageButton;
    private Text generalDesc;
    private CCombo factionCombo;
    private Unit soldier = null;
    private ImageData soldierImage = null;
    private ScrolledForm container;
    private Composite patchClient;
    private Object result;

    public CustomGeneralUnitDialog(String string) {
        super(string);
    }

    protected Control createDialogArea(Composite composite) {
        int n;
        this.container = WidgetUtil.getToolkit().createScrolledForm(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 20;
        gridLayout.marginHeight = 15;
        this.container.getBody().setLayout(gridLayout);
        this.container.setLayoutData(new GridData(1808));
        this.patchClient = WidgetUtil.getToolkit().createComposite(this.container.getBody());
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.patchClient.setLayout(gridLayout);
        this.patchClient.setLayoutData(new GridData(1808));
        WidgetUtil.getToolkit().createLabel(this.patchClient, "1.\u5c06\u519b\u536b\u961f\u540d\u79f0\uff08\u4e2d\u6587\uff09\uff1a");
        this.nameText = WidgetUtil.getToolkit().createText(this.patchClient, "");
        GridData gridData = new GridData(768);
        gridData.widthHint = 180;
        gridData.horizontalSpan = 2;
        this.nameText.setLayoutData(gridData);
        this.nameText.addModifyListener(this.nameListener);
        this.nameText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (CustomGeneralUnitDialog.this.idText.getText().trim().length() == 0) {
                    HanyuPinyinOutputFormat hanyuPinyinOutputFormat = new HanyuPinyinOutputFormat();
                    hanyuPinyinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
                    hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
                    try {
                        CustomGeneralUnitDialog.this.idText.setText(PinyinHelper.toHanyuPinyinString((String)CustomGeneralUnitDialog.this.nameText.getText().trim(), (HanyuPinyinOutputFormat)hanyuPinyinOutputFormat, (String)""));
                    }
                    catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
                        badHanyuPinyinOutputFormatCombination.printStackTrace();
                    }
                }
            }
        });
        this.imageCanvas = WidgetUtil.getToolkit().createImageCanvas(this.patchClient, 0);
        gridData = new GridData(1040);
        gridData.verticalSpan = 7;
        gridData.widthHint = 160;
        this.imageCanvas.setLayoutData(gridData);
        WidgetUtil.getToolkit().createLabel(this.patchClient, "2.\u5c06\u519b\u536b\u961f\u540d\u79f0\uff08\u62fc\u97f3\uff09\uff1a");
        this.idText = WidgetUtil.getToolkit().createText(this.patchClient, "");
        gridData = new GridData(768);
        gridData.widthHint = 180;
        gridData.horizontalSpan = 2;
        this.idText.setLayoutData(gridData);
        this.idText.addModifyListener(this.nameListener);
        WidgetUtil.getToolkit().createLabel(this.patchClient, "3.\u9009\u62e9\u536b\u961f\u52bf\u529b\uff1a");
        this.factionCombo = WidgetUtil.getToolkit().createCCombo(this.patchClient, 8);
        gridData = new GridData(768);
        gridData.widthHint = 180;
        gridData.horizontalSpan = 2;
        this.factionCombo.setLayoutData(gridData);
        this.factionCombo.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CustomGeneralUnitDialog.this.checkEnableStatus();
            }
        });
        WidgetUtil.getToolkit().createLabel(this.patchClient, "4.\u521b\u5efa\u5c06\u519b\u536b\u961f\uff1a");
        this.soldierButton = WidgetUtil.getToolkit().createButton(this.patchClient, "\u8bbe\u7f6e", 8);
        gridData = new GridData(768);
        gridData.widthHint = 180;
        gridData.horizontalSpan = 2;
        this.soldierButton.setLayoutData(gridData);
        this.soldierButton.setEnabled(false);
        this.soldierButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UnitModifyDialog unitModifyDialog = new UnitModifyDialog("\u8bbe\u7f6e\u65b0\u6b66\u5c06\u536b\u961f");
                if (CustomGeneralUnitDialog.this.soldier != null) {
                    unitModifyDialog.setSoldier(CustomGeneralUnitDialog.this.soldier);
                }
                if (unitModifyDialog.open() == 0) {
                    CustomGeneralUnitDialog.this.soldier = (Unit)unitModifyDialog.getResult();
                    CustomGeneralUnitDialog.this.checkEnableStatus();
                }
            }
        });
        WidgetUtil.getToolkit().createLabel(this.patchClient, "5.\u8bbe\u7f6e\u5c06\u519b\u536b\u961f\u56fe\u7247(\u53ef\u9009)\uff1a");
        this.soldierImageCombo = WidgetUtil.getToolkit().createCCombo(this.patchClient, 8);
        this.soldierImageCombo.setText("\u5bbd\uff1a160\u50cf\u7d20\uff0c\u9ad8\uff1a210\u50cf\u7d20");
        this.soldierImageCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (CustomGeneralUnitDialog.this.soldierImageCombo.getText().length() == 0) {
                    CustomGeneralUnitDialog.this.soldierImageCombo.setText("\u5bbd\uff1a160\u50cf\u7d20\uff0c\u9ad8\uff1a210\u50cf\u7d20");
                }
            }
        });
        gridData = new GridData(768);
        gridData.widthHint = 160;
        this.soldierImageCombo.setLayoutData(gridData);
        this.soldierImageCombo.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string;
                if (CustomGeneralUnitDialog.this.soldierImageCombo.getSelectionIndex() != -1 && (string = (String)CustomGeneralUnitDialog.this.generalUnitMap.getKeyList().get(CustomGeneralUnitDialog.this.soldierImageCombo.getSelectionIndex())) != null) {
                    String string2 = UnitUtil.getUnitDictionary(string);
                    String[] stringArray = UnitUtil.getFactionsFromSoldierType(string);
                    for (int i = 0; i < stringArray.length; ++i) {
                        File file = new File(Patch.GAME_ROOT + "\\alexander\\data\\ui\\unit_info\\" + stringArray[i] + "\\" + string2 + "_info.tga");
                        if (!file.exists() || file.length() <= 0L) continue;
                        try {
                            ImageData imageData = TgaLoader.loadImage((InputStream)new BufferedInputStream(new FileInputStream(file)));
                            CustomGeneralUnitDialog.this.imageCanvas.setImageData(imageData);
                            CustomGeneralUnitDialog.this.soldierImage = imageData;
                            break;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                CustomGeneralUnitDialog.this.checkEnableStatus();
            }
        });
        this.soldierImageButton = WidgetUtil.getToolkit().createButton(this.patchClient, 8, true);
        this.soldierImageButton.setText("\u81ea\u5b9a\u4e49");
        this.soldierImageButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 0);
                fileDialog.setFilterExtensions(new String[]{"*.jpg;*.jpeg;*.png;*.bmp;*.gif;*.tga"});
                fileDialog.setFilterNames(new String[]{"\u56fe\u7247"});
                String string = fileDialog.open();
                if (string != null && new File(string).exists()) {
                    CustomGeneralUnitDialog.this.soldierImage = null;
                    CustomGeneralUnitDialog.this.soldierImageCombo.clearSelection();
                    CustomGeneralUnitDialog.this.soldierImageCombo.setText(string);
                    File file = new File(CustomGeneralUnitDialog.this.soldierImageCombo.getText().trim());
                    if (file.exists() && file.isFile()) {
                        try {
                            ImageData imageData = null;
                            if (file.getName().toLowerCase().endsWith(".tga")) {
                                imageData = TgaLoader.loadImage((InputStream)new FileInputStream(file), (boolean)true, (boolean)true);
                            } else {
                                ImageLoader imageLoader = new ImageLoader();
                                imageData = imageLoader.load(file.getAbsolutePath())[0];
                            }
                            CustomGeneralUnitDialog.this.soldierImage = GraphicsUtil.resizeImage((ImageData)imageData, (int)160, (int)210, (boolean)true);
                            CustomGeneralUnitDialog.this.imageCanvas.setImageData(CustomGeneralUnitDialog.this.soldierImage);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                CustomGeneralUnitDialog.this.checkEnableStatus();
            }
        });
        Label label = WidgetUtil.getToolkit().createLabel(this.patchClient, "6.\u8bbe\u7f6e\u536b\u961f\u63cf\u8ff0(\u53ef\u9009)\uff1a");
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        gridData.grabExcessVerticalSpace = false;
        label.setLayoutData(gridData);
        this.generalDesc = WidgetUtil.getToolkit().createText(this.patchClient, "", 8389186);
        gridData = new GridData(1808);
        gridData.heightHint = 100;
        gridData.widthHint = 300;
        gridData.horizontalSpan = 3;
        this.generalDesc.setLayoutData(gridData);
        this.generalUnitMap = UnitUtil.getAvailableGeneralUnits();
        for (n = 0; n < this.generalUnitMap.getKeyList().size(); ++n) {
            String string = ChangeCode.toLong((String)this.generalUnitMap.get(n));
            this.soldierImageCombo.add(string);
        }
        this.factionMap = UnitUtil.getFactionMap();
        for (n = 0; n < this.factionMap.getKeyList().size(); ++n) {
            this.factionCombo.add((String)this.factionMap.get(n));
        }
        this.checkEnableStatus();
        this.container.setContent(this.patchClient);
        this.container.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                CustomGeneralUnitDialog.this.computeSize();
            }
        });
        this.computeSize();
        return this.container;
    }

    protected void computeSize() {
        this.container.setMinSize(this.patchClient.computeSize(-1, -1));
        this.patchClient.layout();
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        FormWidgetFactory.getInstance().paintFormStyle(composite);
        FormWidgetFactory.getInstance().adapt(composite);
        return control;
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        this.checkEnableStatus();
        return control;
    }

    protected void okPressed() {
        BakUtil.bakData("\u521b\u5efa\u5c06\u519b\u536b\u961f\uff1a" + this.nameText.getText());
        CustomUnit customUnit = new CustomUnit();
        customUnit.setDisplayName(this.nameText.getText().trim());
        customUnit.setName(this.idText.getText().trim());
        customUnit.setFaction((String)this.factionMap.getKeyList().get(this.factionCombo.getSelectionIndex()));
        if (this.soldierImage != null) {
            customUnit.setSoldierImage(this.soldierImage);
        } else {
            String string = this.soldier.getDictionary();
            String[] stringArray = UnitUtil.getFactionsFromSoldierType(this.soldier.getType());
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(Patch.GAME_ROOT + "\\alexander\\data\\ui\\unit_info\\" + stringArray[i] + "\\" + string + "_info.tga");
                if (!file.exists() || file.length() <= 0L) continue;
                try {
                    ImageData imageData = TgaLoader.loadImage((InputStream)new BufferedInputStream(new FileInputStream(file)));
                    customUnit.setSoldierImage(imageData);
                    break;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        customUnit.setSoldier(this.soldier);
        customUnit.setDescription(this.generalDesc.getText().trim());
        customUnit.createCustomUtil();
        this.result = this.nameText.getText();
        super.okPressed();
    }

    public Object getResult() {
        return this.result;
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
            this.getShell().setImages(((Shell)this.getShell().getParent()).getImages());
            ShellWrapper shellWrapper = new ShellWrapper(this.getShell());
            shellWrapper.installTheme();
        }
        if (this.initDialog()) {
            return super.open();
        }
        return 1;
    }

    private void checkEnableStatus() {
        String string = "Custom " + this.idText.getText().trim();
        if (this.nameText.getText().trim().length() > 0 && this.idText.getText().trim().length() > 0 && UnitUtil.getUnitDictionary(string) == null) {
            this.soldierButton.setEnabled(true);
            this.soldierImageCombo.setEnabled(true);
            this.soldierButton.setEnabled(true);
            this.soldierImageButton.setEnabled(true);
            this.generalDesc.setEnabled(true);
            this.factionCombo.setEnabled(true);
            if (this.soldier != null && this.factionCombo.getSelectionIndex() > -1) {
                if (this.getOkButton() != null) {
                    this.getOkButton().setEnabled(true);
                }
            } else if (this.getOkButton() != null) {
                this.getOkButton().setEnabled(false);
            }
        } else {
            this.soldierButton.setEnabled(false);
            this.soldierImageCombo.setEnabled(false);
            this.soldierButton.setEnabled(false);
            this.soldierImageButton.setEnabled(false);
            this.generalDesc.setEnabled(false);
            this.factionCombo.setEnabled(false);
            if (this.getOkButton() != null) {
                this.getOkButton().setEnabled(false);
            }
        }
    }
}

