/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.page;

import java.util.HashMap;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.sf.feeling.sanguo.patch.page.ICategoryPage;
import org.sf.feeling.sanguo.patch.page.TabPage;
import org.sf.feeling.sanguo.patch.provider.ICategoryProvider;
import org.sf.feeling.sanguo.patch.widget.FormWidgetFactory;
import org.sf.feeling.sanguo.patch.widget.Tab;
import org.sf.feeling.sanguo.patch.widget.TabbedPropertyList;
import org.sf.feeling.sanguo.patch.widget.TabbedPropertyTitle;
import org.sf.feeling.sanguo.patch.widget.WidgetUtil;

public class BasePage {
    private TabbedPropertyList categoryList;
    private Composite container;
    private ScrolledComposite sComposite;
    private Composite infoPane;
    private ICategoryProvider categoryProvider;
    private TabPage currentPage;
    private TabbedPropertyTitle title;
    HashMap pageMap;
    private ToolBar bar;
    private Label infoLabel;
    private CLabel fileLabel;
    private ProgressBar progress;

    public void buildUI(Composite composite) {
        this.container = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.numColumns = 2;
        this.container.setLayout(gridLayout);
        this.categoryList = new TabbedPropertyList(this.container);
        GridData gridData = new GridData(1040);
        gridData.verticalSpan = 3;
        this.categoryList.setLayoutData(gridData);
        this.categoryList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BasePage.this.processListSelected();
            }
        });
        this.setCategoryProvider(this.categoryProvider);
        this.title = new TabbedPropertyTitle(this.container, FormWidgetFactory.getInstance());
        this.title.setLayoutData(new GridData(768));
        this.sComposite = new ScrolledComposite(this.container, 768);
        this.sComposite.setLayoutData(new GridData(1808));
        this.sComposite.setExpandHorizontal(true);
        this.sComposite.setExpandVertical(true);
        this.sComposite.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                BasePage.this.computeSize();
            }
        });
        this.infoPane = new Composite(this.sComposite, 0);
        this.sComposite.setContent(this.infoPane);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.infoPane.setLayout(gridLayout);
        this.bar = new ToolBar(this.container, 0x800100);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 0;
        this.bar.setLayout(gridLayout);
        ToolItem toolItem = new ToolItem(this.bar, 0);
        this.infoLabel = WidgetUtil.getToolkit().createLabel((Composite)this.bar, "", 16384);
        this.infoLabel.setText("");
        toolItem.setControl(this.infoLabel);
        ToolItem toolItem2 = new ToolItem(this.bar, 0);
        this.fileLabel = WidgetUtil.getToolkit().createCLabel((Composite)this.bar, "");
        toolItem2.setControl(this.fileLabel);
        this.fileLabel.setLayoutData(new GridData(768));
        ToolItem toolItem3 = new ToolItem(this.bar, 0);
        this.progress = new ProgressBar(this.bar, 2);
        toolItem3.setControl(this.progress);
        gridData = new GridData();
        gridData.widthHint = 30;
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 12;
        this.progress.setLayoutData(gridData);
        FormWidgetFactory.getInstance().paintFormStyle(this.bar);
        FormWidgetFactory.getInstance().adapt(this.bar);
        gridData = new GridData(768);
        gridData.heightHint = this.bar.computeSize((int)-1, (int)-1).y;
        this.bar.setLayoutData(gridData);
        this.hideInfo();
    }

    public void showInfo(String string, String string2) {
        GridData gridData = (GridData)this.bar.getLayoutData();
        if (gridData.heightHint == 0) {
            gridData.heightHint = this.bar.computeSize((int)-1, (int)-1).y;
            this.bar.setLayoutData(gridData);
            this.container.layout();
        }
        if (string != null) {
            String string3 = this.infoLabel.getText();
            this.infoLabel.setText(string);
            if (!string.equals(string3)) {
                this.bar.layout();
            }
        }
        if (string2 != null) {
            this.fileLabel.setText(string2);
            if (string2.trim().length() > 0) {
                this.progress.setVisible(true);
            } else {
                this.progress.setVisible(false);
            }
        } else {
            this.progress.setVisible(false);
        }
    }

    public void hideInfo() {
        this.showInfo("", "");
        GridData gridData = (GridData)this.bar.getLayoutData();
        gridData.heightHint = 0;
        this.bar.setLayoutData(gridData);
        this.container.layout();
    }

    private void computeSize() {
        this.infoPane.layout();
    }

    public int getSelectionIndex() {
        return this.categoryList.getSelectionIndex();
    }

    private void processListSelected() {
        if (this.categoryProvider == null) {
            return;
        }
        int n = this.categoryList.getSelectionIndex();
        if (n == -1) {
            return;
        }
        TabPage tabPage = this.getCategoryPane(this.categoryList.getSelectionIndex());
        this.title.setTitle(tabPage.getDisplayName(), null);
        this.showPage(tabPage);
    }

    public void setSelection(int n) {
        this.categoryList.setSelection(n);
        TabPage tabPage = this.getCategoryPane(this.categoryList.getSelectionIndex());
        this.title.setTitle(tabPage.getDisplayName(), null);
        this.showPage(tabPage);
    }

    private void showPage(TabPage tabPage) {
        if (tabPage != this.currentPage) {
            if (this.currentPage != null) {
                ((GridData)this.currentPage.getControl().getLayoutData()).exclude = true;
                this.currentPage.getControl().setVisible(false);
                this.currentPage.deActivate();
            }
            ((GridData)tabPage.getControl().getLayoutData()).exclude = false;
            tabPage.getControl().setVisible(true);
            this.currentPage = tabPage;
            this.computeSize();
            this.currentPage.activate();
            tabPage.refresh();
        }
    }

    public void setCategoryProvider(ICategoryProvider iCategoryProvider) {
        this.categoryProvider = iCategoryProvider;
        if (iCategoryProvider == null) {
            return;
        }
        if (this.categoryList == null) {
            return;
        }
        ICategoryPage[] iCategoryPageArray = iCategoryProvider.getCategories();
        if (iCategoryPageArray.length != 0) {
            Tab[] tabArray = new Tab[iCategoryPageArray.length];
            for (int i = 0; i < iCategoryPageArray.length; ++i) {
                tabArray[i] = new Tab();
                tabArray[i].setText(iCategoryPageArray[i].getDisplayLabel());
            }
            this.categoryList.setElements(tabArray);
            if (this.categoryList.getTabList().length > 0) {
                this.categoryList.setSelection(0);
            }
        }
    }

    public void refresh() {
        this.processListSelected();
    }

    private TabPage getCategoryPane(int n) {
        String string;
        TabPage tabPage;
        if (this.pageMap == null) {
            this.pageMap = new HashMap(this.categoryProvider.getCategories().length);
        }
        if ((tabPage = (TabPage)this.pageMap.get(string = Integer.toString(n))) == null) {
            tabPage = this.categoryProvider.getCategories()[n].createPage();
            tabPage.buildUI(this.infoPane);
            this.computeSize();
        }
        tabPage.getControl().setLayoutData(new GridData(1808));
        this.pageMap.put(string, tabPage);
        return tabPage;
    }
}

