/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.page;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.sf.feeling.sanguo.patch.model.Unit;
import org.sf.feeling.sanguo.patch.page.RestoreListener;
import org.sf.feeling.sanguo.patch.page.SimpleTabPage;
import org.sf.feeling.sanguo.patch.util.BakUtil;
import org.sf.feeling.sanguo.patch.util.ChangeCode;
import org.sf.feeling.sanguo.patch.util.MapUtil;
import org.sf.feeling.sanguo.patch.util.UnitParser;
import org.sf.feeling.sanguo.patch.util.UnitUtil;
import org.sf.feeling.sanguo.patch.widget.WidgetUtil;
import org.sf.feeling.swt.win32.extension.util.SortMap;

public class UnitPatchPage
extends SimpleTabPage {
    private SortMap soldierUnitMap;
    private SortMap factionMap;
    private CCombo factionCombo;
    private CCombo soldierCombo;

    public void buildUI(Composite composite) {
        super.buildUI(composite);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.leftMargin = 10;
        tableWrapLayout.rightMargin = 10;
        tableWrapLayout.topMargin = 15;
        tableWrapLayout.verticalSpacing = 20;
        this.container.getBody().setLayout(tableWrapLayout);
        this.createTitle();
        this.createPatchArea();
        FormText formText = WidgetUtil.createFormText(this.container.getBody(), "\u6ce8\u610f\uff1a\u53ea\u6709\u6b65\u5175\u5175\u8425\u7b49\u7ea7\u6700\u9ad8\u4e3a5\u7ea7\uff0c\u5176\u4ed6\u5175\u79cd\u5175\u8425\u7b49\u7ea7\u6700\u9ad8\u4e3a4\u7ea7\u3002");
        TableWrapData tableWrapData = new TableWrapData(128);
        tableWrapData.maxWidth = 600;
        formText.setLayoutData(tableWrapData);
    }

    private void createPatchArea() {
        Section section = WidgetUtil.getToolkit().createSection(this.container.getBody(), 64);
        TableWrapData tableWrapData = new TableWrapData(128);
        section.setLayoutData(tableWrapData);
        section.setText("\u529f\u80fd\u5217\u8868\uff1a");
        WidgetUtil.getToolkit().createCompositeSeparator(section);
        Composite composite = WidgetUtil.getToolkit().createComposite(section);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        composite.setLayout(gridLayout);
        final Button button = WidgetUtil.getToolkit().createButton(composite, "\u52bf\u529b\u5175\u79cd\u6dfb\u52a0", 32);
        this.factionCombo = WidgetUtil.getToolkit().createCCombo(composite, 8);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        this.factionCombo.setLayoutData(gridData);
        this.factionCombo.setEnabled(false);
        this.soldierCombo = WidgetUtil.getToolkit().createCCombo(composite, 8);
        this.soldierUnitMap = UnitUtil.getAllSoldierUnits();
        if (this.soldierUnitMap != null) {
            for (int i = 0; i < this.soldierUnitMap.getKeyList().size(); ++i) {
                this.soldierCombo.add(ChangeCode.toLong((String)this.soldierUnitMap.get(i)));
            }
        }
        gridData = new GridData();
        gridData.widthHint = 150;
        this.soldierCombo.setLayoutData(gridData);
        this.soldierCombo.setEnabled(false);
        final CCombo cCombo = WidgetUtil.getToolkit().createCCombo(composite, 8);
        cCombo.setItems(new String[]{"\u6240\u6709\u5175\u8425", "2\u7ea7\u4ee5\u4e0a\u5175\u8425", "3\u7ea7\u4ee5\u4e0a\u5175\u8425", "4\u7ea7\u4ee5\u4e0a\u5175\u8425", "5\u7ea7\u5175\u8425"});
        gridData = new GridData();
        gridData.widthHint = 100;
        this.soldierCombo.setLayoutData(gridData);
        this.soldierCombo.setEnabled(false);
        final Button button2 = WidgetUtil.getToolkit().createButton(composite, "\u5e94\u7528", 8);
        button2.setEnabled(false);
        Button button3 = WidgetUtil.getToolkit().createButton(composite, "\u8fd8\u539f", 8);
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (UnitPatchPage.this.factionCombo.getSelectionIndex() != -1 && UnitPatchPage.this.soldierCombo.getSelectionIndex() != -1) {
                    button2.setEnabled(false);
                    StringBuffer stringBuffer = new StringBuffer("\u52bf\u529b\u5175\u79cd\u6dfb\u52a0\uff1a");
                    stringBuffer.append(UnitPatchPage.this.factionCombo.getText());
                    stringBuffer.append("<--");
                    stringBuffer.append(UnitPatchPage.this.soldierCombo.getText());
                    if (cCombo.getSelectionIndex() > -1) {
                        stringBuffer.append("\uff0c");
                        stringBuffer.append(cCombo.getText());
                    }
                    BakUtil.bakData(stringBuffer.toString());
                    String string = (String)UnitPatchPage.this.factionMap.getKeyList().get(UnitPatchPage.this.factionCombo.getSelectionIndex());
                    String string2 = (String)UnitPatchPage.this.soldierUnitMap.getKeyList().get(UnitPatchPage.this.soldierCombo.getSelectionIndex());
                    Unit unit = UnitParser.getUnit(string2);
                    try {
                        if (!unit.getFactions().contains(string.toLowerCase())) {
                            String string3;
                            UnitUtil.modifyUnitFile(string, unit.getType());
                            UnitUtil.modifyBattleFile(string, unit.getSoldier()[0]);
                            List list = unit.getOfficers();
                            if (list != null && list.size() > 0) {
                                for (int i = 0; i < list.size(); ++i) {
                                    UnitUtil.modifyBattleFile(string, (String)list.get(i));
                                }
                            }
                            if ((string3 = unit.getMount()) != null) {
                                UnitUtil.modifyBattleFile(string, (String)UnitUtil.getMountTypeToModelMap().get((Object)string3));
                            }
                            String[] stringArray = null;
                            if ("missile".equals(unit.getUnitClass()) || "siege".equals(unit.getCategory())) {
                                stringArray = new String[]{"practice_field", "archery_range", "catapult_range", "siege_engineer"};
                            } else if ("infantry".equals(unit.getCategory()) || "handler".equals(unit.getCategory())) {
                                stringArray = new String[]{"muster_field", "militia_barracks", "city_barracks", "army_barracks", "royal_barracks"};
                            } else if ("cavalry".equals(unit.getCategory())) {
                                stringArray = new String[]{"stables", "cavalry_barracks", "hippodrome", "circus_maximus"};
                            } else if ("ship".equals(unit.getCategory())) {
                                stringArray = new String[]{"port", "shipwright", "dockyard"};
                            } else if ("non_combatant".equals(unit.getCategory())) {
                                stringArray = new String[]{"governors_house", "governors_villa", "governors_palace", "proconsuls_palace", "imperial_palace"};
                            }
                            if (stringArray != null) {
                                if (cCombo.getSelectionIndex() > 0) {
                                    ArrayList<String> arrayList = new ArrayList<String>();
                                    for (int i = cCombo.getSelectionIndex(); i < stringArray.length; ++i) {
                                        arrayList.add(stringArray[i]);
                                    }
                                    if (arrayList.size() > 0) {
                                        UnitUtil.addUnitToBuildings(string2, string, arrayList.toArray(new String[0]));
                                    }
                                } else {
                                    UnitUtil.addUnitToBuildings(string2, string, stringArray);
                                }
                            }
                            UnitUtil.saveBigBingPai(string, (String)unit.getFactions().get(0), unit.getDictionary());
                            UnitUtil.saveSmallBingPai(string, (String)unit.getFactions().get(0), unit.getDictionary());
                            MapUtil.initMap();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    button2.setEnabled(true);
                }
            }
        });
        button3.addSelectionListener(new RestoreListener());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                button2.setEnabled(button.getSelection());
                UnitPatchPage.this.factionCombo.setEnabled(button.getSelection());
                UnitPatchPage.this.soldierCombo.setEnabled(button.getSelection());
            }
        });
        section.setClient(composite);
    }

    private void createTitle() {
        WidgetUtil.createFormText(this.container.getBody(), "\u672c\u9875\u9762\u7528\u4e8e\u6dfb\u52a0\u5175\u79cd\u5230\u6307\u5b9a\u52bf\u529b\uff0c\u914d\u7f6e\u5b8c\u6bd5\u540e\u91cd\u542f\u6e38\u620f\u5373\u53ef\u751f\u6548\u3002");
    }

    public String getDisplayName() {
        return "\u52bf\u529b\u5175\u79cd\u6dfb\u52a0";
    }

    public void refresh() {
        super.refresh();
        this.refreshPage();
    }

    private void refreshPage() {
        this.factionMap = UnitUtil.getFactionMap();
        String string = this.factionCombo.getText();
        this.factionCombo.removeAll();
        for (int i = 0; i < this.factionMap.getKeyList().size(); ++i) {
            this.factionCombo.add((String)this.factionMap.get(i));
        }
        if (this.factionMap.containsValue((Object)string)) {
            this.factionCombo.setText(string);
        }
        this.soldierUnitMap = UnitUtil.getAllSoldierUnits();
        String string2 = this.soldierCombo.getText();
        if (this.soldierUnitMap != null) {
            this.soldierCombo.removeAll();
            for (int i = 0; i < this.soldierUnitMap.getKeyList().size(); ++i) {
                this.soldierCombo.add(ChangeCode.toLong((String)this.soldierUnitMap.get(i)));
            }
        }
        if (this.soldierUnitMap.containsValue((Object)ChangeCode.toShort(string2))) {
            this.soldierCombo.setText(string2);
        }
    }
}

