/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.ZipInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.sanguo.patch.Patch;
import org.sf.feeling.sanguo.patch.model.General;
import org.sf.feeling.sanguo.patch.util.FileConstants;
import org.sf.feeling.sanguo.patch.util.FileUtil;
import org.sf.feeling.sanguo.patch.util.MapUtil;
import org.sf.feeling.sanguo.patch.util.UnitUtil;
import org.sf.feeling.swt.win32.extension.io.FileSystem;
import org.sf.feeling.swt.win32.extension.util.SortMap;

public class BakUtil {
    public static final int IO_FINISH = 0;
    public static String bakFolderPath = Patch.GAME_ROOT + "\\patch\\bak";
    public static String bakIncreaseFolderPath = Patch.GAME_ROOT + "\\patch\\bak\\resources";
    public static String patchFolderPath = Patch.GAME_ROOT + "\\patch";
    public static String defalutBakFilePath = Patch.GAME_ROOT + "\\patch\\bak\\default.zip";
    public static File defalutBakFile = new File(defalutBakFilePath);
    public static String defalutResourceBakFilePath = Patch.GAME_ROOT + "\\patch\\bak\\resources\\default.zip";
    public static File defalutResourceBakFile = new File(defalutResourceBakFilePath);
    private static File[] bakDataFiles = new File[]{FileConstants.enumVnVsFile, FileConstants.unitFile, FileConstants.battleFile, FileConstants.buildingsFile, FileConstants.baowuFile, FileConstants.exportUnitFile, FileConstants.nameFile, FileConstants.descNamesFile, FileConstants.vnVsFile, FileConstants.stratFile, FileConstants.unitEnumsFile, FileConstants.characterFile, FileConstants.characterTraitFile, FileConstants.scriptFile, FileConstants.disasterFile, FileConstants.projectTileFile, FileConstants.desc_MountFile, FileConstants.modelStratFile, FileConstants.descrBannersFile, FileConstants.descrFactionsFile, FileConstants.descrWallsFile, FileConstants.campaignDescriptionFile, FileConstants.expandedBiFile, FileConstants.factionPropertiesFile};
    private static FileFilter tgaFilter = new FileFilter(){

        public boolean accept(File file) {
            if (file.isDirectory() || file.getName().toLowerCase().endsWith(".tga")) {
                for (int i = 0; i < file.getName().length(); ++i) {
                    char c = file.getName().charAt(i);
                    if (c < '\u00ff') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static FileFilter ddsFilter = new FileFilter(){

        public boolean accept(File file) {
            if (file.isDirectory() || file.getName().toLowerCase().endsWith(".dds")) {
                for (int i = 0; i < file.getName().length(); ++i) {
                    char c = file.getName().charAt(i);
                    if (c < '\u00ff') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static FileFilter generalBannerFilter = new FileFilter(){

        public boolean accept(File file) {
            return (file.isDirectory() || file.getName().toLowerCase().endsWith(".dds")) && file.getName().toLowerCase().indexOf("zhangqiguantongyong") > -1;
        }
    };
    private static FileFilter cityBannerFilter = new FileFilter(){

        public boolean accept(File file) {
            return (file.isDirectory() || file.getName().toLowerCase().endsWith(".dds")) && file.getName().toLowerCase().indexOf("#banner_symbol_") > -1;
        }
    };
    private static FileFilter mapFilter = new FileFilter(){

        public boolean accept(File file) {
            String string;
            return (file.isDirectory() || file.getName().toLowerCase().endsWith(".tga")) && MapUtil.factionMap.containsKey((Object)(string = file.getName().toUpperCase().replaceAll("(?i)map_", "").replaceAll("(?i)\\.tga", "").trim()));
        }
    };

    public static void bakData(String string) {
        if (BakUtil.checkBakFolder()) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Etc/GMT-8"), Locale.CHINA);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            simpleDateFormat.setCalendar(calendar);
            String string2 = simpleDateFormat.format(calendar.getTime());
            File file = new File(bakFolderPath + "\\" + string2 + ".zip");
            File file2 = new File(bakIncreaseFolderPath + "\\" + string2 + ".zip");
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(file);
                zipOutputStream.setEncoding("GBK");
                zipOutputStream.setComment(string);
                BakUtil.zipDataFiles(zipOutputStream, false);
                zipOutputStream.close();
                zipOutputStream = new ZipOutputStream(file2);
                zipOutputStream.setEncoding("GBK");
                zipOutputStream.setComment(string);
                BakUtil.zipIncreaseFiles(zipOutputStream, false);
                zipOutputStream.close();
                BakUtil.setCurrentVersion(string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                file.delete();
            }
            Patch.getInstance().hideInfo();
        }
    }

    public static File bakBugData() {
        if (BakUtil.checkBakFolder()) {
            File file = new File(bakFolderPath + "\\bug.zip");
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(file);
                zipOutputStream.setEncoding("GBK");
                BakUtil.zipDataFiles(zipOutputStream, false);
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                file.delete();
            }
            return file;
        }
        return null;
    }

    public static void bakDataAndResources(String string, File[] fileArray) {
        if (BakUtil.checkBakFolder()) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Etc/GMT-8"), Locale.CHINA);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            simpleDateFormat.setCalendar(calendar);
            String string2 = simpleDateFormat.format(calendar.getTime());
            File file = new File(bakFolderPath + "\\" + string2 + ".zip");
            File file2 = new File(bakIncreaseFolderPath + "\\" + string2 + ".zip");
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(file);
                zipOutputStream.setEncoding("GBK");
                zipOutputStream.setComment(string);
                BakUtil.zipDataFiles(zipOutputStream, false);
                zipOutputStream.close();
                zipOutputStream = new ZipOutputStream(file2);
                zipOutputStream.setEncoding("GBK");
                zipOutputStream.setComment(string);
                for (int i = 0; i < fileArray.length; ++i) {
                    BakUtil.zipResourceFile(zipOutputStream, fileArray[i].getAbsolutePath(), false);
                }
                BakUtil.zipIncreaseFiles(zipOutputStream, false);
                zipOutputStream.close();
                BakUtil.setCurrentVersion(string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                file.delete();
            }
            Patch.getInstance().hideInfo();
        }
    }

    private static void zipResourceFile(ZipOutputStream zipOutputStream, String string, boolean bl) throws IOException {
        BakUtil.zipResourceFile(zipOutputStream, string, tgaFilter, bl);
    }

    private static void zipResourceFile(java.util.zip.ZipOutputStream zipOutputStream, String string, boolean bl) throws IOException {
        BakUtil.zipResourceFile(zipOutputStream, string, tgaFilter, bl);
    }

    private static void setCurrentVersion(String string) {
        Properties properties = new Properties();
        properties.setProperty("currentVersion", string);
        try {
            properties.store(new FileOutputStream(new File(patchFolderPath + "\\bak.properties")), null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void zipIncreaseFiles(ZipOutputStream zipOutputStream, boolean bl) {
        String string = BakUtil.getBakCurrentVersion();
        if (string != null) {
            File file = new File(bakIncreaseFolderPath + "\\" + string + ".zip");
            if (!file.exists()) {
                return;
            }
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                ZipFile zipFile = new ZipFile(file, "GBK");
                Enumeration enumeration = zipFile.getEntries();
                ZipEntry zipEntry = null;
                while (enumeration.hasMoreElements()) {
                    zipEntry = (ZipEntry)enumeration.nextElement();
                    if (!zipEntry.getName().startsWith("resources/")) continue;
                    arrayList.add(zipEntry.getName());
                }
                zipFile.close();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    String string3 = Patch.GAME_ROOT + "\\" + string2.replaceAll("resources/", "").replaceAll("/", "\\\\");
                    File file2 = new File(string3);
                    if (!file2.exists() || zipOutputStream.getEntries().contains(string2)) continue;
                    BakUtil.recursiveZip(zipOutputStream, file2, string2, tgaFilter, bl);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String getBakCurrentVersion() {
        try {
            File file = new File(patchFolderPath + "\\bak.properties");
            if (!file.exists()) {
                return null;
            }
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            return properties.getProperty("currentVersion");
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    public static void bakToDefaultData(final Listener listener) {
        if (BakUtil.checkBakToDefault()) {
            Patch.getInstance().showInfo("\u5f00\u59cb\u51c6\u5907\u5907\u4efd", "");
            new Thread(){

                public void run() {
                    try {
                        if (BakUtil.checkBakFolder()) {
                            Object object;
                            Object object2;
                            Object object3;
                            ZipOutputStream zipOutputStream = new ZipOutputStream(defalutBakFile);
                            zipOutputStream.setComment("\u6e38\u620f\u6570\u636e\u5168\u5c40\u5907\u4efd\u521d\u59cb\u6863");
                            zipOutputStream.setEncoding("GBK");
                            BakUtil.zipDataFiles(zipOutputStream, true);
                            zipOutputStream.close();
                            java.util.zip.ZipOutputStream zipOutputStream2 = new java.util.zip.ZipOutputStream(new BufferedOutputStream(new FileOutputStream(defalutResourceBakFile)));
                            zipOutputStream2.setLevel(1);
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.factionMapsPath, mapFilter, true);
                            for (int i = 0; i < FileConstants.cultures.length; ++i) {
                                object3 = FileConstants.uiPath + "\\" + FileConstants.cultures[i] + "\\interface\\sharedpage_01.tga";
                                object2 = FileConstants.uiPath + "\\" + FileConstants.cultures[i] + "\\interface\\stratpage_02.tga";
                                BakUtil.zipResourceFile(zipOutputStream2, (String)object3, true);
                                BakUtil.zipResourceFile(zipOutputStream2, (String)object2, true);
                            }
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.customPortraitPath, true);
                            ArrayList arrayList = new ArrayList();
                            arrayList.addAll(MapUtil.generalUnitMap.getKeyList());
                            arrayList.addAll(MapUtil.soldierUnitMap.getKeyList());
                            object3 = new ArrayList();
                            object2 = new ArrayList();
                            for (int i = 0; i < arrayList.size(); ++i) {
                                object = (String)MapUtil.unitTypeToDictionaryMap.get(arrayList.get(i));
                                object3.add("#" + ((String)object).toLowerCase() + ".tga");
                                object2.add(((String)object).toLowerCase() + "_info.tga");
                            }
                            FileFilter fileFilter = new FileFilter((List)object3){
                                private final /* synthetic */ List val$unitNames;
                                {
                                    this.val$unitNames = list;
                                }

                                public boolean accept(File file) {
                                    if (file.isDirectory()) {
                                        return true;
                                    }
                                    return this.val$unitNames.contains(file.getName().toLowerCase());
                                }
                            };
                            object = new FileFilter((List)object2){
                                private final /* synthetic */ List val$unitInfoNames;
                                {
                                    this.val$unitInfoNames = list;
                                }

                                public boolean accept(File file) {
                                    if (file.isDirectory()) {
                                        return true;
                                    }
                                    return this.val$unitInfoNames.contains(file.getName().toLowerCase());
                                }
                            };
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.uiUnitsPath, fileFilter, true);
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.uiUnitInfoPath, (FileFilter)object, true);
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.uiAncillariesPath, true);
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.captainBannerPath, true);
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.stratBannerPath, ddsFilter, true);
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.battleBannerPath, ddsFilter, true);
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.cityBannerPath, cityBannerFilter, true);
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.menuSymbolsPath, true);
                            BakUtil.zipResourceFile(zipOutputStream2, FileConstants.generalBannerPath, generalBannerFilter, true);
                            zipOutputStream2.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (Patch.getInstance().getShell().isDisposed()) {
                                return;
                            }
                            Patch.getInstance().hideInfo();
                            Event event = new Event();
                            event.type = 0;
                            listener.handleEvent(event);
                        }
                    });
                }
            }.start();
        } else {
            if (Patch.getInstance().getShell().isDisposed()) {
                return;
            }
            Patch.getInstance().hideInfo();
            Event event = new Event();
            event.type = 0;
            listener.handleEvent(event);
        }
    }

    private static boolean checkBakFolder() {
        File file = new File(bakFolderPath);
        if (!file.exists()) {
            file.mkdirs();
        } else if (file.isFile()) {
            file.delete();
            file.mkdirs();
        }
        File file2 = new File(bakIncreaseFolderPath);
        if (!file2.exists()) {
            file2.mkdirs();
        } else if (file2.isFile()) {
            file2.delete();
            file2.mkdirs();
        }
        return file.exists() && file.isDirectory();
    }

    public static void recursiveZip(Object object, File file, final String string, FileFilter fileFilter, boolean bl) throws FileNotFoundException, IOException {
        Object[] objectArray;
        if (file.isDirectory() && (objectArray = file.listFiles(fileFilter)) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                BakUtil.recursiveZip(object, objectArray[i], string + "/" + objectArray[i].getName(), fileFilter, bl);
            }
        }
        if (file.isFile()) {
            int n;
            BufferedInputStream bufferedInputStream;
            ZipEntry zipEntry;
            if (bl) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Patch.getInstance().showInfo("\u6b63\u5728\u5907\u4efd\u6587\u4ef6\uff1a", string.substring(string.indexOf("/") + 1));
                    }
                });
            }
            objectArray = new byte[512];
            if (object instanceof ZipOutputStream) {
                ZipOutputStream zipOutputStream = (ZipOutputStream)object;
                zipEntry = new ZipEntry(string);
                zipEntry.setSize(file.length());
                zipOutputStream.putNextEntry(zipEntry);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                n = 0;
                while ((n = bufferedInputStream.read((byte[])objectArray)) != -1) {
                    zipOutputStream.write((byte[])objectArray, 0, n);
                }
                bufferedInputStream.close();
            }
            if (object instanceof java.util.zip.ZipOutputStream) {
                java.util.zip.ZipOutputStream zipOutputStream = (java.util.zip.ZipOutputStream)object;
                zipEntry = new ZipEntry(string);
                zipEntry.setSize(file.length());
                zipOutputStream.putNextEntry(zipEntry);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                n = 0;
                while ((n = bufferedInputStream.read((byte[])objectArray)) != -1) {
                    zipOutputStream.write((byte[])objectArray, 0, n);
                }
                bufferedInputStream.close();
            }
        }
    }

    private static void zipDataFiles(ZipOutputStream zipOutputStream, boolean bl) throws FileNotFoundException, IOException {
        for (int i = 0; i < bakDataFiles.length; ++i) {
            BakUtil.zipDataFile(zipOutputStream, bakDataFiles[i].getAbsolutePath(), bl);
        }
    }

    public static File[] getGeneralsImageFiles(String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        SortMap sortMap = UnitUtil.getGeneralMap();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Iterator iterator = sortMap.getKeyList().iterator();
            Object var5_5 = null;
            while (iterator.hasNext()) {
                object = iterator.next();
                Object object2 = sortMap.get(object);
                if (stringArray[i] != null && stringArray[i].equals(object2)) {
                    var5_5 = object;
                }
                if (var5_5 == null) continue;
                break;
            }
            object = ((General)MapUtil.generalModelMap.get((Object)stringArray[i])).getPortrait();
            arrayList.add(new File(FileConstants.customPortraitFile, (String)object));
        }
        return arrayList.toArray(new File[0]);
    }

    public static void restoreBakFile(File file) {
        BakUtil.restoreBakFile(file, null);
    }

    public static void restoreBakFile(final File file, final Listener listener) {
        new Thread(){

            public void run() {
                if (file.exists()) {
                    if (file.getAbsolutePath().equals(defalutBakFilePath)) {
                        try {
                            BakUtil.restoreFile(defalutBakFile, true);
                            File file2 = new File(patchFolderPath + "\\bak.properties");
                            if (file2.exists()) {
                                file2.delete();
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else {
                        String string = file.getName().substring(0, file.getName().indexOf("."));
                        String string2 = BakUtil.getBakCurrentVersion();
                        try {
                            if (string2 != null) {
                                long l = Long.parseLong(string);
                                long l2 = Long.parseLong(string2);
                                File[] fileArray = BakUtil.computeIncreaseFiles(l, l2);
                                for (int i = 0; i < fileArray.length; ++i) {
                                    File file3 = fileArray[i];
                                    BakUtil.restoreIncraseFile(file3, true);
                                }
                            }
                            BakUtil.restoreFile(file, true);
                            BakUtil.setCurrentVersion(string);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    MapUtil.initMap();
                }
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        if (Patch.getInstance().getShell().isDisposed()) {
                            return;
                        }
                        Patch.getInstance().hideInfo();
                        if (listener != null) {
                            Event event = new Event();
                            event.type = 0;
                            listener.handleEvent(event);
                        }
                    }
                });
            }
        }.start();
    }

    private static void restoreFile(File file, boolean bl) throws IOException {
        File file2 = new File(bakIncreaseFolderPath + "\\" + file.getName());
        if (file.exists()) {
            BakUtil.restoreDataFile(file, bl);
        }
        if (file2.exists()) {
            BakUtil.restoreIncraseFile(file2, bl);
        }
    }

    private static void restoreResourceFile(ZipInputStream zipInputStream, final java.util.zip.ZipEntry zipEntry, boolean bl) {
        String string;
        File file;
        if (bl) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Patch.getInstance().showInfo("\u6b63\u5728\u8fd8\u539f\u6587\u4ef6\uff1a", zipEntry.getName().substring(zipEntry.getName().indexOf("/") + 1));
                }
            });
        }
        if ((file = new File(string = Patch.GAME_ROOT + "\\" + zipEntry.getName().replaceAll("resources/", "").replaceAll("/", "\\\\"))).exists()) {
            FileUtil.writeToBinarayFile(file, zipInputStream, false);
        }
    }

    private static void restoreDataFile(ZipInputStream zipInputStream, final java.util.zip.ZipEntry zipEntry, boolean bl) {
        String string;
        File file;
        if (bl) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Patch.getInstance().showInfo("\u6b63\u5728\u8fd8\u539f\u6587\u4ef6\uff1a", zipEntry.getName().substring(zipEntry.getName().indexOf("/") + 1));
                }
            });
        }
        if ((file = new File(string = Patch.GAME_ROOT + "\\" + zipEntry.getName().replaceAll("datas/", "").replaceAll("/", "\\\\"))).exists()) {
            FileUtil.writeToBinarayFile(file, zipInputStream, false);
        }
    }

    private static void restoreIncraseFile(File file, boolean bl) throws IOException {
        java.util.zip.ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().startsWith("resources/")) continue;
            BakUtil.restoreResourceFile(zipInputStream, zipEntry, bl);
        }
        zipInputStream.close();
    }

    private static void restoreDataFile(File file, boolean bl) throws IOException {
        java.util.zip.ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().startsWith("datas/")) continue;
            BakUtil.restoreDataFile(zipInputStream, zipEntry, bl);
        }
        zipInputStream.close();
    }

    private static File[] computeIncreaseFiles(long l, long l2) {
        long l3;
        String string;
        int n;
        if (l == l2) {
            return new File[0];
        }
        File file = new File(bakIncreaseFolderPath);
        if (!file.exists()) {
            return new File[0];
        }
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            return new File[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string2 = stringArray[i].substring(0, stringArray[i].indexOf("."));
                Long.parseLong(string2);
                arrayList.add(string2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (l > l2) {
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                l3 = Long.parseLong(string);
                if (l3 < l2 || l3 >= l) continue;
                arrayList2.add(string);
            }
            Collections.sort(arrayList2, new Comparator(){

                public int compare(Object object, Object object2) {
                    long l = Long.parseLong((String)object) - Long.parseLong((String)object2);
                    if (l > 0L) {
                        return 1;
                    }
                    if (l == 0L) {
                        return 0;
                    }
                    return -1;
                }
            });
        } else {
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                l3 = Long.parseLong(string);
                if (l3 > l2 || l3 <= l) continue;
                arrayList2.add(string);
            }
            Collections.sort(arrayList2, new Comparator(){

                public int compare(Object object, Object object2) {
                    long l = Long.parseLong((String)object2) - Long.parseLong((String)object);
                    if (l > 0L) {
                        return 1;
                    }
                    if (l == 0L) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
        ArrayList<File> arrayList3 = new ArrayList<File>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string3 = (String)arrayList2.get(i);
            File file2 = new File(bakIncreaseFolderPath + "\\" + string3 + ".zip");
            if (!file2.exists()) continue;
            arrayList3.add(file2);
        }
        return arrayList3.toArray(new File[0]);
    }

    public static void restoreDefaultBakFile(Listener listener) {
        BakUtil.restoreBakFile(defalutBakFile, listener);
    }

    public static File getCurrentVersionBakFile() {
        return new File(bakFolderPath + "\\" + BakUtil.getBakCurrentVersion() + ".zip");
    }

    public static void restoreCurrectVersionBakFile() {
        File file = new File(bakFolderPath + "\\" + BakUtil.getBakCurrentVersion() + ".zip");
        try {
            if (file.exists()) {
                BakUtil.restoreFile(file, false);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        MapUtil.initMap();
    }

    public static void checkDefaultBak() {
        if (Patch.getInstance().getShell().isDisposed()) {
            return;
        }
        if (!defalutBakFile.exists()) {
            if (MessageDialog.openConfirm((Shell)Patch.getInstance().getShell(), (String)"\u63d0\u793a", (String)"\u4fee\u6539\u5668\u68c0\u6d4b\u5230\u60a8\u5c1a\u672a\u8bbe\u7f6e\u6e38\u620f\u6570\u636e\u5907\u4efd\u539f\u59cb\u6863\uff0c\u60a8\u662f\u5426\u613f\u610f\u73b0\u5728\u5f00\u59cb\u8bbe\u7f6e\uff1f")) {
                Patch.getInstance().select(Patch.getInstance().getPageCount() - 5);
            }
        } else if (!defalutResourceBakFile.exists()) {
            if (MessageDialog.openConfirm((Shell)Patch.getInstance().getShell(), (String)"\u63d0\u793a", (String)"\u4fee\u6539\u5668\u68c0\u6d4b\u5230\u60a8\u7684\u6e38\u620f\u6570\u636e\u5907\u4efd\u539f\u59cb\u6863\u4e0e\u5f53\u524d\u7248\u672c\u4e0d\u517c\u5bb9\uff0c\u9700\u8981\u91cd\u65b0\u8bbe\u7f6e\u3002\u60a8\u662f\u5426\u613f\u610f\u73b0\u5728\u5f00\u59cb\u8bbe\u7f6e\uff1f")) {
                BakUtil.deleteDictionary(new File(bakFolderPath));
                File file = new File(patchFolderPath + "\\bak.properties");
                if (file.exists()) {
                    file.delete();
                }
                Patch.getInstance().select(Patch.getInstance().getPageCount() - 5);
            }
        } else {
            new Thread(){

                public void run() {
                    try {
                        final ArrayList<File> arrayList = new ArrayList<File>();
                        arrayList.addAll(Arrays.asList(bakDataFiles));
                        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(defalutBakFile));
                        java.util.zip.ZipEntry zipEntry = null;
                        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                            for (int i = 0; i < bakDataFiles.length; ++i) {
                                BakUtil.checkZipFile(zipEntry, bakDataFiles[i], arrayList);
                            }
                        }
                        zipInputStream.close();
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                if (arrayList.size() > 0) {
                                    BakUtil.syncDefaultBakFile(arrayList);
                                }
                            }
                        });
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }.start();
        }
    }

    protected static void checkZipFile(java.util.zip.ZipEntry zipEntry, File file, List list) {
        if (file.getAbsolutePath().substring(Patch.GAME_ROOT.getAbsolutePath().length()).replaceAll("\\\\", "/").equalsIgnoreCase(zipEntry.getName().replaceAll("datas", ""))) {
            list.remove(file);
        }
    }

    public static boolean checkBakToDefault() {
        if (defalutBakFile.exists()) {
            return MessageDialog.openConfirm((Shell)Patch.getInstance().getShell(), (String)"\u63d0\u793a", (String)"\u4fee\u6539\u5668\u68c0\u67e5\u5230\u60a8\u5df2\u7ecf\u8bbe\u7f6e\u8fc7\u6e38\u620f\u6570\u636e\u5907\u4efd\u539f\u59cb\u6863\uff01\u60a8\u662f\u5426\u8981\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bbe\u7f6e\u5f53\u524d\u6e38\u620f\u6570\u636e\u4f5c\u4e3a\u5907\u4efd\u539f\u59cb\u6863\uff1f");
        }
        return true;
    }

    private static void syncDefaultBakFile(final List list) {
        MessageDialog.openWarning((Shell)Patch.getInstance().getShell(), (String)"\u63d0\u793a", (String)"\u4fee\u6539\u5668\u68c0\u67e5\u5230\u60a8\u8bbe\u7f6e\u7684\u6e38\u620f\u6570\u636e\u5907\u4efd\u539f\u59cb\u6863\u5df2\u7ecf\u8fc7\u671f\uff0c\u73b0\u5728\u5f00\u59cb\u540c\u6b65\u60a8\u7684\u5907\u4efd\u539f\u59cb\u6863\uff01");
        new Thread(){

            public void run() {
                try {
                    File file = new File(FileSystem.getTempPath() + "\\" + System.currentTimeMillis());
                    file.mkdirs();
                    if (file.exists() && file.isDirectory()) {
                        Object object;
                        Object object2;
                        java.util.zip.ZipEntry zipEntry;
                        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(defalutBakFile)));
                        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                            File file2 = new File(file + "\\" + zipEntry.getName());
                            if (zipEntry.isDirectory()) {
                                file2.mkdirs();
                                continue;
                            }
                            if (!file2.getParentFile().exists()) {
                                file2.getParentFile().mkdirs();
                            }
                            FileUtil.writeToBinarayFile(file2, zipInputStream, false);
                        }
                        zipInputStream.close();
                        for (int i = 0; i < list.size(); ++i) {
                            object2 = (File)list.get(i);
                            object = new File(file + "\\datas" + ((File)object2).getAbsolutePath().substring(Patch.GAME_ROOT.getAbsolutePath().length()));
                            if (!((File)object).getParentFile().exists()) {
                                ((File)object).getParentFile().mkdirs();
                            }
                            FileUtil.writeToBinarayFile((File)object, new FileInputStream((File)object2), false);
                        }
                        File file3 = new File(defalutBakFilePath + ".tmp");
                        object2 = new ZipOutputStream(file3);
                        ((ZipOutputStream)object2).setComment("\u6e38\u620f\u6570\u636e\u5168\u5c40\u5907\u4efd\u521d\u59cb\u6863");
                        object = file.listFiles();
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            BakUtil.recursiveZip(object2, (File)object[i], ((File)object[i]).getAbsolutePath().substring(file.getAbsolutePath().length() + 1).replaceAll("\\\\", "/"), null, true);
                        }
                        ((ZipOutputStream)object2).close();
                        defalutBakFile.delete();
                        file3.renameTo(defalutBakFile);
                        BakUtil.deleteDictionary(file);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Patch.getInstance().hideInfo();
                    }
                });
            }
        }.start();
    }

    private static void deleteDictionary(File file) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            if (fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (!file2.exists()) continue;
                    if (file2.isDirectory()) {
                        BakUtil.deleteDictionary(file2);
                        continue;
                    }
                    file2.delete();
                }
            }
            file.delete();
        }
    }

    private static void zipResourceFile(ZipOutputStream zipOutputStream, String string, FileFilter fileFilter, boolean bl) throws FileNotFoundException, IOException {
        BakUtil.recursiveZip(zipOutputStream, new File(string), "resources" + string.substring(Patch.GAME_ROOT.getAbsolutePath().length()).replaceAll("\\\\", "/"), fileFilter, bl);
    }

    private static void zipResourceFile(java.util.zip.ZipOutputStream zipOutputStream, String string, FileFilter fileFilter, boolean bl) throws FileNotFoundException, IOException {
        BakUtil.recursiveZip(zipOutputStream, new File(string), "resources" + string.substring(Patch.GAME_ROOT.getAbsolutePath().length()).replaceAll("\\\\", "/"), fileFilter, bl);
    }

    private static void zipDataFile(ZipOutputStream zipOutputStream, String string, boolean bl) throws FileNotFoundException, IOException {
        BakUtil.recursiveZip(zipOutputStream, new File(string), "datas" + string.substring(Patch.GAME_ROOT.getAbsolutePath().length()).replaceAll("\\\\", "/"), null, bl);
    }

    public static File[] getUnitImageFiles(String string, String string2) {
        File[] fileArray = new File[2];
        String string3 = (String)MapUtil.unitTypeToDictionaryMap.get((Object)string2);
        String string4 = Patch.GAME_ROOT + "\\alexander\\data\\ui\\unit_info\\" + string + "\\" + string3 + "_info.tga";
        String string5 = Patch.GAME_ROOT + "\\alexander\\data\\ui\\units\\" + string + "\\#" + string3 + ".tga";
        fileArray[0] = new File(string4);
        fileArray[1] = new File(string5);
        return fileArray;
    }
}

