/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.util;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.ImageData;
import org.sf.feeling.sanguo.patch.Patch;
import org.sf.feeling.sanguo.patch.model.Unit;
import org.sf.feeling.sanguo.patch.util.ChangeCode;
import org.sf.feeling.sanguo.patch.util.FileConstants;
import org.sf.feeling.sanguo.patch.util.UnitParser;
import org.sf.feeling.sanguo.patch.util.UnitUtil;
import org.sf.feeling.swt.win32.extension.graphics.TgaLoader;

public class CustomUnit {
    private int buildingLevel = -1;
    private String description = null;
    private String displayName;
    private boolean isGeneralUnit = true;
    private boolean isSpecialGeneralUnit = true;
    private String name;
    private Unit soldier;
    private ImageData soldierCardImage;
    private String soldierDictionary;
    private ImageData soldierImage;
    private String soldierType;
    private String unitFaction;

    public void createCustomUtil() {
        this.generalCustomSoldier();
    }

    private void generalCustomSoldier() {
        this.soldierType = "Custom " + this.name;
        this.soldierDictionary = this.soldierType.replaceAll("(\\s+)", "_");
        String string = this.soldier.getSoldier()[0];
        List list = this.soldier.getOfficers();
        try {
            UnitUtil.modifyBattleFile(this.unitFaction, string);
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    UnitUtil.modifyBattleFile(this.unitFaction, (String)list.get(i));
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string2 = this.soldier.getMount();
        if (string2 != null && (string2 = (String)UnitUtil.getMountTypeToModelMap().get((Object)string2)) != null) {
            try {
                UnitUtil.modifyBattleFile(this.unitFaction, string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.isGeneralUnit) {
            if (!this.soldier.getAttributes().contains("general_unit")) {
                this.soldier.getAttributes().add("general_unit");
            }
            if (!this.soldier.getAttributes().contains("no_custom")) {
                this.soldier.getAttributes().add("no_custom");
            }
        } else {
            this.soldier.getAttributes().remove("general_unit");
            this.soldier.getAttributes().remove("no_custom");
        }
        UnitParser.createSoldier(this.soldier, this.soldierType, this.soldierDictionary, this.unitFaction);
        this.setSoldierDescription(this.soldierDictionary, this.displayName, this.description);
        this.setSoldierImage();
        this.setSoldierBuilding();
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFaction() {
        return this.unitFaction;
    }

    public ImageData getSoldierCardImage() {
        return this.soldierCardImage;
    }

    public boolean isGeneralUnit() {
        return this.isGeneralUnit;
    }

    public boolean isSpecialGeneralUnit() {
        return this.isSpecialGeneralUnit;
    }

    public void setBuildingLevel(int n) {
        this.buildingLevel = n;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDisplayName(String string) {
        this.displayName = ChangeCode.Change(string, true);
    }

    public void setFaction(String string) {
        this.unitFaction = string;
    }

    public void setGeneralUnit(boolean bl) {
        this.isGeneralUnit = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSoldier(Unit unit) {
        this.soldier = unit;
    }

    private void setSoldierBuilding() {
        String[] stringArray = null;
        if ("missile".equals(this.soldier.getUnitClass()) || "siege".equals(this.soldier.getCategory())) {
            stringArray = new String[]{"practice_field", "archery_range", "catapult_range", "siege_engineer"};
        } else if ("infantry".equals(this.soldier.getCategory()) || "handler".equals(this.soldier.getCategory())) {
            stringArray = new String[]{"muster_field", "militia_barracks", "city_barracks", "army_barracks", "royal_barracks"};
        } else if ("cavalry".equals(this.soldier.getCategory())) {
            stringArray = new String[]{"stables", "cavalry_barracks", "hippodrome", "circus_maximus"};
        } else if ("ship".equals(this.soldier.getCategory())) {
            stringArray = new String[]{"port", "shipwright", "dockyard"};
        } else if ("non_combatant".equals(this.soldier.getCategory())) {
            stringArray = new String[]{"governors_house", "governors_villa", "governors_palace", "proconsuls_palace", "imperial_palace"};
        }
        if (stringArray != null) {
            try {
                if (this.buildingLevel > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = this.buildingLevel; i < stringArray.length; ++i) {
                        arrayList.add(stringArray[i]);
                    }
                    if (arrayList.size() > 0) {
                        UnitUtil.addUnitToBuildings(this.soldierType, this.unitFaction, arrayList.toArray(new String[0]));
                    }
                } else if (!this.isGeneralUnit && this.buildingLevel == -1 || this.buildingLevel == 0) {
                    UnitUtil.addUnitToBuildings(this.soldierType, this.unitFaction, stringArray);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setSoldierCardImage(ImageData imageData) {
        this.soldierCardImage = imageData;
    }

    private void setSoldierDescription(String string, String string2, String string3) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileConstants.exportUnitFile, true), "UTF-16LE")), false);
            printWriter.println();
            String string4 = this.isSpecialGeneralUnit ? string2 + "\u9ebe\u4e0b\u7684\u7cbe\u92b3\u89aa\u5175\u3002" : string2;
            String string5 = string2 + "\u9ebe\u4e0b\u7684\u7cbe\u92b3\u89aa\u5175\u3002\\n\\n";
            string5 = string5 + string2 + "\u7684\u90e8\u4e0b\u96a8" + string2 + "\u5f81\u6230\u56db\u65b9\u3002\\n";
            if (!this.isSpecialGeneralUnit) {
                string5 = string2 + "\u3002\\n";
            }
            if (string3 != null && string3.length() > 0) {
                string5 = ChangeCode.toShort(string3);
            }
            printWriter.println("{" + string + "}" + string2);
            printWriter.println("{" + string + "_descr}" + string5);
            printWriter.println("{" + string + "_descr_short}" + string4);
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileConstants.unitEnumsFile, true), "GBK")), false);
            printWriter.println();
            printWriter.println(string);
            printWriter.println(string + "_descr");
            printWriter.println(string + "_descr_short");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setSoldierImage() {
        String string = Patch.GAME_ROOT + "\\alexander\\data\\ui\\unit_info\\" + this.unitFaction + "\\" + this.soldierDictionary + "_info.tga";
        String string2 = Patch.GAME_ROOT + "\\alexander\\data\\ui\\units\\" + this.unitFaction + "\\#" + this.soldierDictionary + ".tga";
        if (this.soldierImage != null) {
            try {
                TgaLoader.saveImage((OutputStream)new FileOutputStream(string), (ImageData)this.soldierImage.scaledTo(160, 210));
                if (!this.isSpecialGeneralUnit) {
                    if (this.soldierCardImage != null) {
                        TgaLoader.saveImage((OutputStream)new FileOutputStream(string2), (ImageData)this.soldierCardImage.scaledTo(48, 64));
                    } else {
                        TgaLoader.saveImage((OutputStream)new FileOutputStream(string2), (ImageData)this.soldierImage.scaledTo(48, 64));
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setSoldierImage(ImageData imageData) {
        this.soldierImage = imageData;
    }

    public void setSpecialGeneralUnit(boolean bl) {
        this.isSpecialGeneralUnit = bl;
    }
}

