/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.sf.feeling.sanguo.patch.model.FactionDescription;
import org.sf.feeling.sanguo.patch.model.FactionTexture;
import org.sf.feeling.sanguo.patch.model.General;
import org.sf.feeling.sanguo.patch.util.ChangeCode;
import org.sf.feeling.sanguo.patch.util.FileConstants;
import org.sf.feeling.sanguo.patch.util.FileUtil;
import org.sf.feeling.sanguo.patch.util.PinyinComparator;
import org.sf.feeling.sanguo.patch.util.SoldierMapUtil;
import org.sf.feeling.sanguo.patch.util.UnitUtil;
import org.sf.feeling.swt.win32.extension.graphics.TgaLoader;
import org.sf.feeling.swt.win32.extension.util.SortMap;

public class MapUtil {
    public static final String HANDLER = "handler";
    public static final String SIEGE = "siege";
    public static final String INFANTRY = "infantry";
    public static final String CAVALRY = "cavalry";
    static SortMap unitMap;
    static SortMap generalNameMap;
    static SortMap availabelGeneralNameMap;
    static SortMap generalUnitMap;
    static SortMap availableGeneralUnitMap;
    static SortMap soldierUnitMap;
    static SortMap generalUnitTypeMap;
    static SortMap unitTypeToDictionaryMap;
    static SortMap unitDictionaryToTypeMap;
    static List soldierUnitList;
    static List guyongUnitList;
    static List generalUnitList;
    static SortMap generalOrderMap;
    static SortMap factionMap;
    static SortMap unitFactionMap;
    static SortMap factionGeneralMap;
    static SortMap factionLeaderMap;
    static SortMap factionHeirMap;
    static SortMap horseMap;
    static SortMap officerMap;
    static SortMap mountTypeToModelMap;
    static SortMap mountModelToTypeMap;
    static SortMap generalModelMap;
    static List nonRelativeGeneralList;
    static SortMap categoryMap;
    static SortMap factionTextureMap;
    static SortMap factionDescriptionMap;
    static HashSet unAvailableGeneralPoints;
    static SortMap factionProperty;
    static SortMap generalModelProperty;
    static List customGeneralModelList;

    public static void initMap() {
        factionProperty = FileUtil.loadProperties("faction");
        MapUtil.initUnitTypeToDictionaryMap();
        MapUtil.initMountTypeToModelMap();
        unitMap = MapUtil.initUnitMap();
        generalOrderMap = MapUtil.initGeneralOrderMap();
        generalNameMap = MapUtil.initGeneralNameMap();
        factionMap = MapUtil.initFactionMap();
        availabelGeneralNameMap = MapUtil.initAvailableGeneralNameMap();
        MapUtil.initGeneralUnitMaps();
        MapUtil.initAvailableOfficerAndHorses();
        SoldierMapUtil.initMap();
        MapUtil.initNonRelativeGeneralList();
        factionTextureMap = MapUtil.initFactionTextureMap();
        factionDescriptionMap = MapUtil.initFactionDescriptionMap();
        customGeneralModelList = MapUtil.getCustomGeneralModelList();
    }

    private static SortMap initFactionTextureMap() {
        SortMap sortMap = new SortMap();
        if (FileConstants.descrBannersFile.exists()) {
            try {
                String string = null;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.descrBannersFile), "GBK"));
                boolean bl = false;
                String string2 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String string3;
                    Pattern pattern = Pattern.compile("^\\s*(faction)(\\s+)", 2);
                    Matcher matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        bl = false;
                        string2 = string.replaceAll("(?i)faction", "").trim().toUpperCase();
                        if (factionProperty.containsValue((Object)string2.toUpperCase())) {
                            sortMap.put((Object)string2, (Object)new FactionTexture());
                            bl = true;
                            continue;
                        }
                    }
                    if (!bl) continue;
                    pattern = Pattern.compile("^\\s*(standard_texture)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.replaceAll("(?i)(standard_texture)", "").trim();
                        ((FactionTexture)sortMap.get((Object)string2)).setStandard_texture(string3);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(rebels_texture)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.replaceAll("(?i)rebels_texture", "").trim();
                        ((FactionTexture)sortMap.get((Object)string2)).setRebels_texture(string3);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(routing_texture)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.replaceAll("(?i)routing_texture", "").trim();
                        ((FactionTexture)sortMap.get((Object)string2)).setRouting_texture(string3);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(ally_texture)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (!matcher.find()) continue;
                    string3 = string.replaceAll("(?i)ally_texture", "").trim();
                    ((FactionTexture)sortMap.get((Object)string2)).setAlly_texture(string3);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sortMap;
    }

    private static SortMap initFactionDescriptionMap() {
        SortMap sortMap = new SortMap();
        if (FileConstants.descrFactionsFile.exists()) {
            try {
                String string = null;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.descrFactionsFile), "GBK"));
                boolean bl = false;
                String string2 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String string3;
                    Pattern pattern = Pattern.compile("^\\s*(faction)(\\s+)", 2);
                    Matcher matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        bl = false;
                        string2 = string.replaceAll("(?i)faction", "").trim().toUpperCase();
                        if (factionProperty.containsValue((Object)string2.toUpperCase())) {
                            sortMap.put((Object)string2, (Object)new FactionDescription());
                            bl = true;
                            continue;
                        }
                    }
                    if (!bl) continue;
                    pattern = Pattern.compile("^\\s*(culture)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.replaceAll("(?i)(culture)", "").trim();
                        ((FactionDescription)sortMap.get((Object)string2)).setCulture(string3);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(symbol)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.replaceFirst("(?i)symbol", "").trim();
                        ((FactionDescription)sortMap.get((Object)string2)).setSymbol(string3);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(primary_colour)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.replaceAll("(?i)primary_colour", "").trim();
                        ((FactionDescription)sortMap.get((Object)string2)).setPrimary_colour(string3);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(secondary_colour)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.replaceAll("(?i)secondary_colour", "").trim();
                        ((FactionDescription)sortMap.get((Object)string2)).setSecondary_colour(string3);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(loading_logo)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.replaceAll("(?i)loading_logo", "").trim();
                        ((FactionDescription)sortMap.get((Object)string2)).setLoading_logo(string3);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(standard_index)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.replaceAll("(?i)standard_index", "").trim();
                        ((FactionDescription)sortMap.get((Object)string2)).setStandard_index(string3);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(custom_battle_availability)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.replaceAll("(?i)custom_battle_availability", "").trim();
                        ((FactionDescription)sortMap.get((Object)string2)).setCustom_battle_availability(string3);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(prefers_naval_invasions)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (!matcher.find()) continue;
                    string3 = string.replaceAll("(?i)prefers_naval_invasions", "").trim();
                    ((FactionDescription)sortMap.get((Object)string2)).setPrefers_naval_invasions(string3);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sortMap;
    }

    private static void initNonRelativeGeneralList() {
        Object object;
        String string;
        nonRelativeGeneralList = new ArrayList();
        for (int i = 0; i < generalModelMap.getKeyList().size(); ++i) {
            string = (String)generalModelMap.getKeyList().get(i);
            object = (General)generalModelMap.get((Object)string);
            if (((General)object).isLeader() || ((General)object).isHeir() || availabelGeneralNameMap.get((Object)string) == null) continue;
            nonRelativeGeneralList.add(string);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.stratFile), "GBK"));
            string = null;
            while ((string = bufferedReader.readLine()) != null) {
                object = Pattern.compile("^\\s*(relative)(\\s+)([([a-zA-Z0-9_\\-]+)]+)(\\s*)", 2);
                Matcher matcher = ((Pattern)object).matcher(string);
                if (!matcher.find()) continue;
                String string2 = matcher.group().replaceAll("(?i)relative", "").trim();
                nonRelativeGeneralList.remove(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Collections.sort(nonRelativeGeneralList, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)availabelGeneralNameMap.get(object);
                String string2 = (String)availabelGeneralNameMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
    }

    private static SortMap initUnitMap() {
        SortMap sortMap = new SortMap();
        List list = unitTypeToDictionaryMap.getKeyList();
        if (FileConstants.exportUnitFile.exists()) {
            try {
                String string = null;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.exportUnitFile), "UTF-16LE"));
                while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    String string3;
                    Pattern pattern = Pattern.compile("^\\s*(\\{\\s*)(.+)(\\s*\\})(\\s*)");
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.find() || (string3 = (String)unitDictionaryToTypeMap.get((Object)(string2 = matcher.group().replaceAll("(\\{)", "").replaceAll("(\\})", "").trim()))) == null) continue;
                    String[] stringArray = string3.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!list.contains(stringArray[i])) continue;
                        sortMap.put((Object)stringArray[i], (Object)string.substring(matcher.end()).split(";")[0].trim());
                    }
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sortMap;
    }

    private static void initUnitTypeToDictionaryMap() {
        unitTypeToDictionaryMap = new SortMap();
        unitDictionaryToTypeMap = new SortMap();
        unitFactionMap = new SortMap();
        soldierUnitList = new ArrayList();
        guyongUnitList = new ArrayList();
        generalUnitList = new ArrayList();
        categoryMap = new SortMap();
        categoryMap.put((Object)INFANTRY, (Object)new SortMap());
        categoryMap.put((Object)CAVALRY, (Object)new SortMap());
        categoryMap.put((Object)SIEGE, (Object)new SortMap());
        categoryMap.put((Object)HANDLER, (Object)new SortMap());
        if (FileConstants.unitFile.exists()) {
            try {
                String string = null;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.unitFile), "GBK"));
                boolean bl = false;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    Matcher matcher;
                    Pattern pattern;
                    if (string.trim().startsWith(";")) continue;
                    if (!bl) {
                        pattern = Pattern.compile("^\\s*(type)(\\s+)", 2);
                        matcher = pattern.matcher(string);
                        if (!matcher.find()) continue;
                        string2 = string.split(";")[0].replaceAll("(?i)type", "").trim();
                        bl = true;
                        if (!string2.toLowerCase().startsWith("merc")) continue;
                        guyongUnitList.add(string2);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(dictionary)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.split(";")[0].replaceAll("(?i)dictionary", "").trim();
                        unitTypeToDictionaryMap.put((Object)string2, (Object)string3);
                        if (unitDictionaryToTypeMap.containsKey((Object)string3)) {
                            unitDictionaryToTypeMap.put((Object)string3, (Object)(unitDictionaryToTypeMap.get((Object)string3) + "," + string2));
                            continue;
                        }
                        unitDictionaryToTypeMap.put((Object)string3, (Object)string2);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(category)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string4 = string.split(";")[0].replaceAll("(?i)category", "").trim();
                        if (categoryMap.keySet().contains(string4)) continue;
                        string3 = null;
                        string2 = null;
                        bl = false;
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(soldier)(\\s+)(\\S+\\s*,)", 2);
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string5 = matcher.group().trim().replaceAll("(?i)soldier", "").replaceAll(",", "").trim();
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(ownership)(\\s+)");
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        ((SortMap)categoryMap.get((Object)string4)).put((Object)string2, (Object)string5);
                        String[] stringArray = string.split(";")[0].replaceAll("ownership", "").trim().split(",");
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (int i = 0; i < stringArray.length; ++i) {
                            arrayList.add(stringArray[i].trim().toUpperCase());
                        }
                        unitFactionMap.put((Object)string2, arrayList);
                        string3 = null;
                        string2 = null;
                        bl = false;
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(attributes)(\\s+)", 2);
                    matcher = pattern.matcher(string);
                    if (!matcher.find()) continue;
                    if (string.toLowerCase().indexOf("general_unit") == -1) {
                        soldierUnitList.add(string2);
                        continue;
                    }
                    generalUnitList.add(string2);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static SortMap initGeneralNameMap() {
        List list = generalOrderMap.getValueList();
        SortMap sortMap = new SortMap();
        if (FileConstants.nameFile.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.nameFile), "UTF-16LE"));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    Pattern pattern = Pattern.compile("^\\s*(\\{\\s*)(.+)(\\s*\\})(\\s*)");
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.find() || !list.contains(string2 = matcher.group().replaceAll("(\\{)", "").replaceAll("(\\})", "").trim())) continue;
                    sortMap.put((Object)string2, (Object)string.substring(matcher.end()).split(";")[0]);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sortMap;
    }

    private static SortMap initGeneralOrderMap() {
        Object object;
        Object object2;
        factionGeneralMap = new SortMap();
        factionLeaderMap = new SortMap();
        factionHeirMap = new SortMap();
        generalUnitTypeMap = new SortMap();
        generalModelMap = new SortMap();
        if (FileConstants.stratFile.exists()) {
            try {
                object2 = null;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.stratFile), "GBK"));
                String string = null;
                object = null;
                while ((object2 = bufferedReader.readLine()) != null) {
                    Pattern pattern;
                    Matcher matcher;
                    Matcher matcher2;
                    Pattern pattern2;
                    if (string == null) {
                        pattern2 = Pattern.compile("^\\s*(faction)(\\s+)(\\S+)(\\s*)(,)");
                        matcher2 = pattern2.matcher((CharSequence)object2);
                        if (!matcher2.find()) continue;
                        string = matcher2.group().replaceAll("faction", "").replaceAll(",", "").trim().toUpperCase();
                        factionGeneralMap.put((Object)string, new ArrayList());
                        continue;
                    }
                    pattern2 = Pattern.compile("^\\s*(relative)(\\s+)(\\S+)(\\s*)(,)");
                    matcher2 = pattern2.matcher((CharSequence)object2);
                    if (matcher2.find()) {
                        string = null;
                        continue;
                    }
                    Pattern pattern3 = Pattern.compile("^\\s*(character)(.+)(named)(\\s+)(character)");
                    Matcher matcher3 = pattern3.matcher((CharSequence)object2);
                    if (matcher3.find() && (matcher = (pattern = Pattern.compile("(named)(\\s+)(character)(\\s*)(,)")).matcher((CharSequence)object2)).find()) {
                        object = matcher3.group().indexOf("sub_faction") > -1 ? matcher3.group().replaceAll("character", "").split(",")[1].trim().trim() : matcher3.group().replaceAll("character", "").split(",")[0].trim();
                        if ("J-0300-SunJian".equalsIgnoreCase((String)object) || "J-1100-DongZhuo".equalsIgnoreCase((String)object)) {
                            object = null;
                            continue;
                        }
                        ((List)factionGeneralMap.get((Object)string)).add(object);
                        General general = new General();
                        general.setFaction(string);
                        String[] stringArray = ((String)object2).split(",\\s*");
                        for (int i = 0; i < stringArray.length; ++i) {
                            String[] stringArray2 = stringArray[i].split("\\s+");
                            if (stringArray2[0].equalsIgnoreCase("leader")) {
                                general.setLeader(true);
                                factionLeaderMap.put((Object)string, object);
                                continue;
                            }
                            if (stringArray2[0].equalsIgnoreCase("heir")) {
                                general.setHeir(true);
                                factionHeirMap.put((Object)string, object);
                                continue;
                            }
                            if (stringArray2.length != 2) continue;
                            if (stringArray2[0].equalsIgnoreCase("portrait")) {
                                general.setPortrait(stringArray2[1]);
                            }
                            if (stringArray2[0].equalsIgnoreCase("strat_model")) {
                                general.setStrat_model(stringArray2[1]);
                            }
                            if (stringArray2[0].equalsIgnoreCase("battle_model")) {
                                general.setBattle_model(stringArray2[1]);
                            }
                            if (stringArray2[0].equalsIgnoreCase("x")) {
                                general.setPosX(stringArray2[1]);
                            }
                            if (stringArray2[0].equalsIgnoreCase("y")) {
                                general.setPosY(stringArray2[1]);
                            }
                            if (!stringArray2[0].equalsIgnoreCase("age")) continue;
                            general.setAge(stringArray2[1]);
                        }
                        generalModelMap.put(object, (Object)general);
                        continue;
                    }
                    if (object == null || !(matcher2 = (pattern2 = Pattern.compile("^\\s*(unit)(.+)(exp)")).matcher((CharSequence)object2)).find()) continue;
                    generalUnitTypeMap.put(object, (Object)matcher2.group().replaceAll("unit", "").replaceAll("exp", "").trim());
                    object = null;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object2 = new SortMap();
        int n = 0;
        for (int i = 0; i < factionGeneralMap.getValueList().size(); ++i) {
            object = (List)factionGeneralMap.getValueList().get(i);
            if (object == null) continue;
            for (int j = 0; j < object.size(); ++j) {
                object2.put((Object)Integer.valueOf("" + ++n), object.get(j));
            }
        }
        return object2;
    }

    private static SortMap initAvailableGeneralNameMap() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(generalNameMap.getKeyList());
        UnitUtil.getAvailableGeneralCodes(arrayList);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)generalNameMap.get(object);
                String string2 = (String)generalNameMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
        SortMap sortMap = new SortMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            String string = ChangeCode.toLong((String)generalNameMap.get(e));
            if (sortMap.containsValue((Object)string)) {
                for (int j = 0; j < sortMap.getKeyList().size(); ++j) {
                    String string2 = (String)sortMap.getKeyList().get(j);
                    if (!sortMap.get(j).equals(string)) continue;
                    String string3 = UnitUtil.getGeneralFaction(string2);
                    sortMap.put((Object)string2, (Object)ChangeCode.toLong(string + "\uff08" + factionMap.get((Object)string3.toUpperCase()) + "\uff09"));
                }
                String string4 = UnitUtil.getGeneralFaction((String)e);
                sortMap.put(e, (Object)ChangeCode.toLong(string + "\uff08" + factionMap.get((Object)string4.toUpperCase()) + "\uff09"));
                continue;
            }
            sortMap.put(e, (Object)ChangeCode.toLong((String)generalNameMap.get(e)));
        }
        return sortMap;
    }

    private static SortMap initFactionMap() {
        final SortMap sortMap = new SortMap();
        Iterator iterator = factionProperty.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            sortMap.put(factionProperty.get(e), e);
        }
        Collections.sort(sortMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)sortMap.get(object);
                String string2 = (String)sortMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
        return sortMap;
    }

    private static void initGeneralUnitMaps() {
        String string;
        int n;
        generalUnitMap = new SortMap();
        soldierUnitMap = new SortMap();
        availableGeneralUnitMap = new SortMap();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = generalNameMap.getValueList();
        for (n = 0; n < unitMap.size(); ++n) {
            string = (String)unitMap.getKeyList().get(n);
            Object object = unitMap.get((Object)string);
            if (object == null) continue;
            if (list.contains(object)) {
                availableGeneralUnitMap.put((Object)string, object);
            }
            if (generalUnitList.contains(string)) {
                if (generalUnitMap.getValueList().contains(object)) {
                    arrayList.add(object);
                }
                generalUnitMap.put((Object)string, object);
                continue;
            }
            if (!soldierUnitList.contains(string)) continue;
            if (soldierUnitMap.getValueList().contains(object)) {
                arrayList.add(object);
            }
            soldierUnitMap.put((Object)string, object);
        }
        Collections.sort(generalUnitMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)generalUnitMap.get(object);
                String string2 = (String)generalUnitMap.get(object2);
                if (MapUtil.isNormalGeneral(string) && !MapUtil.isNormalGeneral(string2)) {
                    return 1;
                }
                if (MapUtil.isNormalGeneral(string2) && !MapUtil.isNormalGeneral(string)) {
                    return -1;
                }
                return PinyinComparator.compare(string, string2);
            }
        });
        Collections.sort(availableGeneralUnitMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)generalUnitMap.get(object);
                String string2 = (String)generalUnitMap.get(object2);
                if (MapUtil.isNormalGeneral(string) && !MapUtil.isNormalGeneral(string2)) {
                    return 1;
                }
                if (MapUtil.isNormalGeneral(string2) && !MapUtil.isNormalGeneral(string)) {
                    return -1;
                }
                return PinyinComparator.compare(string, string2);
            }
        });
        for (n = 0; n < arrayList.size(); ++n) {
            String string2;
            int n2;
            string = (String)arrayList.get(n);
            for (n2 = 0; n2 < soldierUnitMap.size(); ++n2) {
                if (!soldierUnitMap.get(n2).equals(string)) continue;
                string2 = (String)soldierUnitMap.getKeyList().get(n2);
                if (guyongUnitList.contains(string2)) {
                    soldierUnitMap.put((Object)string2, (Object)(string + "\uff08\u96c7\u4f63\u5175\uff09"));
                    continue;
                }
                List list2 = (List)unitFactionMap.get((Object)string2);
                String string3 = (String)factionMap.get(list2.get(0));
                if (string3 == null || list2.get(0).toString().equalsIgnoreCase("all")) {
                    soldierUnitMap.put((Object)string2, (Object)string);
                    continue;
                }
                soldierUnitMap.put((Object)string2, (Object)(string + "\uff08" + string3 + "\uff09"));
            }
            for (n2 = 0; n2 < generalUnitMap.size(); ++n2) {
                if (!generalUnitMap.get(n2).equals(string)) continue;
                string2 = (String)generalUnitMap.getKeyList().get(n2);
                if (string2.toLowerCase().endsWith("_b")) {
                    generalUnitMap.put((Object)string2, (Object)(string + "\uff08\u70b9\u5c06\u53f0\uff09"));
                    continue;
                }
                if (string2.toLowerCase().endsWith("az")) {
                    generalUnitMap.put((Object)string2, (Object)(string + "\uff08\u5bf9\u6218\uff09"));
                    continue;
                }
                if (!string2.toLowerCase().endsWith("ec")) continue;
                generalUnitMap.put((Object)string2, (Object)(string + "\uff08\u7535\u8111\uff09"));
            }
        }
        Collections.sort(soldierUnitMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)soldierUnitMap.get(object);
                String string2 = (String)soldierUnitMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
    }

    public static void initAvailableOfficerAndHorses() {
        int n;
        String[] stringArray;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (FileConstants.battleFile.exists()) {
            try {
                object = null;
                stringArray = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.battleFile), "GBK"));
                String string = null;
                while ((object = stringArray.readLine()) != null) {
                    Pattern pattern = Pattern.compile("^\\s*(type)(\\s+)");
                    Matcher matcher = pattern.matcher((CharSequence)object);
                    if (!matcher.find()) continue;
                    string = ((String)object).split(";")[0].replaceAll("type", "").trim();
                    arrayList.add(string);
                }
                stringArray.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        officerMap = new SortMap();
        object = FileUtil.loadProperties("officer");
        stringArray = object.keySet().toArray(new String[0]);
        for (n = 0; n < stringArray.length; ++n) {
            if (!arrayList.contains(stringArray[n])) continue;
            officerMap.put((Object)stringArray[n], object.get((Object)stringArray[n]));
        }
        Collections.sort(officerMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)officerMap.get(object);
                String string2 = (String)officerMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
        horseMap = new SortMap();
        object = FileUtil.loadProperties("horse");
        stringArray = object.keySet().toArray(new String[0]);
        for (n = 0; n < stringArray.length; ++n) {
            if (!arrayList.contains(stringArray[n])) continue;
            horseMap.put((Object)stringArray[n], object.get((Object)stringArray[n]));
        }
        Collections.sort(horseMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)horseMap.get(object);
                String string2 = (String)horseMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
    }

    private static void initMountTypeToModelMap() {
        mountTypeToModelMap = new SortMap();
        mountModelToTypeMap = new SortMap();
        if (FileConstants.desc_MountFile.exists()) {
            try {
                String string = null;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.desc_MountFile), "GBK"));
                boolean bl = false;
                String string2 = null;
                String string3 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    Matcher matcher;
                    Pattern pattern;
                    if (string.trim().startsWith(";")) continue;
                    if (!bl) {
                        pattern = Pattern.compile("^\\s*(type)(\\s+)");
                        matcher = pattern.matcher(string);
                        if (!matcher.find()) continue;
                        string2 = string.split(";")[0].replaceAll("type", "").trim();
                        bl = true;
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(model)(\\s+)");
                    matcher = pattern.matcher(string);
                    if (!matcher.find()) continue;
                    string3 = string.split(";")[0].replaceAll("model", "").trim();
                    if (!mountModelToTypeMap.containsKey((Object)string3)) {
                        mountTypeToModelMap.put((Object)string2, (Object)string3);
                        mountModelToTypeMap.put((Object)string3, (Object)string2);
                    } else {
                        String string4 = string2.trim();
                        String string5 = mountModelToTypeMap.get((Object)string3).toString().trim();
                        if (string4.length() > string5.length() || string4.toLowerCase().compareTo(string5.toLowerCase()) > 0) {
                            mountModelToTypeMap.put((Object)string3, (Object)string2);
                        }
                        mountTypeToModelMap.put((Object)string2, (Object)string3);
                    }
                    bl = false;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static boolean isNormalGeneral(String string) {
        return string.indexOf("\u91cd\u6b65") != -1 || string.indexOf("\u6b65\u5f13") != -1 || string.indexOf("\u91cd\u9a0e") != -1 || string.indexOf("\u5f13\u9a0e") != -1 || string.indexOf("\u5c07\u8ecd") != -1 || string.indexOf("\u7cbe\u92b3") != -1;
    }

    public static List getCustomGeneralModelList() {
        ArrayList arrayList = new ArrayList();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.battleFile), "GBK"));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                Pattern pattern = Pattern.compile("^\\s*(type)(\\s+)", 2);
                Matcher matcher = pattern.matcher(string);
                if (!matcher.find()) continue;
                String string2 = string.replaceFirst("type", "").trim();
                if (!string2.startsWith("custom_")) break;
                string2 = string2.replaceFirst("custom_", "").trim();
                int n = UnitUtil.getGeneralModelProperties().getValueList().indexOf(string2);
                if (n == -1) continue;
                arrayList.add(UnitUtil.getGeneralModelProperties().getKeyList().get(n));
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return PinyinComparator.compare(object.toString(), object2.toString());
            }
        });
        return arrayList;
    }

    static {
        if (!FileConstants.factionPropertiesFile.exists()) {
            FileUtil.writeToBinarayFile(FileConstants.factionPropertiesFile, MapUtil.class.getResourceAsStream("/org/sf/feeling/sanguo/patch/code/faction.properties"));
        }
        unAvailableGeneralPoints = new HashSet();
        try {
            Object object;
            int n;
            int n2;
            ImageData imageData = TgaLoader.loadImage((InputStream)new FileInputStream(FileConstants.mapRegionFile));
            RGB rGB = new RGB(0, 0, 0);
            RGB rGB2 = new RGB(255, 255, 255);
            for (n2 = 0; n2 < 180; ++n2) {
                for (n = 0; n < 180; ++n) {
                    if (!rGB.equals(imageData.palette.getRGB(imageData.getPixel(n2, n))) && !rGB2.equals(imageData.palette.getRGB(imageData.getPixel(n2, n)))) continue;
                    unAvailableGeneralPoints.add(new Point(n2, 179 - n));
                }
            }
            ImageData imageData2 = TgaLoader.loadImage((InputStream)new FileInputStream(FileConstants.mapFeatureFile));
            for (n2 = 0; n2 < 180; ++n2) {
                for (n = 0; n < 180; ++n) {
                    object = imageData2.palette.getRGB(imageData2.getPixel(n2, n));
                    if (((RGB)object).blue != 255) continue;
                    unAvailableGeneralPoints.add(new Point(n2, 179 - n));
                }
            }
            object = TgaLoader.loadImage((InputStream)new FileInputStream(FileConstants.mapGroundFile));
            List<RGB> list = Arrays.asList(new RGB(196, 128, 128), new RGB(98, 65, 65), new RGB(64, 0, 0), new RGB(196, 0, 0), new RGB(128, 0, 0), new RGB(0, 64, 0));
            for (n2 = 1; n2 < 381; ++n2) {
                for (n = 1; n < 361; ++n) {
                    RGB rGB3 = ((ImageData)object).palette.getRGB(((ImageData)object).getPixel(n2, n));
                    int n3 = (n2 - 1) / 2;
                    int n4 = 179 - n / 2;
                    if (!list.contains(rGB3)) continue;
                    unAvailableGeneralPoints.add(new Point(n3, n4));
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        generalModelProperty = FileUtil.loadProperties("generalmodel");
    }
}

