/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class ColorSelector {
    public static final String PROP_COLORCHANGE = "colorValue";
    private Button fButton;
    private Color fColor;
    private RGB fColorValue;
    private Point fExtent;
    private Image fImage;
    private List listeners;

    public ColorSelector(Composite composite) {
        this.fButton = new Button(composite, 8);
        this.fExtent = this.computeImageSize(composite);
        this.fImage = new Image((Device)composite.getDisplay(), this.fExtent.x, this.fExtent.y);
        GC gC = new GC(this.fImage);
        gC.setBackground(this.fButton.getBackground());
        gC.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
        gC.dispose();
        this.fButton.setImage(this.fImage);
        this.fButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorSelector.this.open();
            }
        });
        this.fButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ColorSelector.this.fImage != null) {
                    ColorSelector.this.fImage.dispose();
                    ColorSelector.this.fImage = null;
                }
                if (ColorSelector.this.fColor != null) {
                    ColorSelector.this.fColor.dispose();
                    ColorSelector.this.fColor = null;
                }
            }
        });
        this.fButton.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = JFaceResources.getString((String)"ColorSelector.Name");
            }
        });
    }

    private Point computeImageSize(Control control) {
        GC gC = new GC(control);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont");
        gC.setFont(font);
        int n = gC.getFontMetrics().getHeight();
        gC.dispose();
        Point point = new Point(n * 3 - 6, n);
        return point;
    }

    public Button getButton() {
        return this.fButton;
    }

    public RGB getColorValue() {
        return this.fColorValue;
    }

    public void setColorValue(RGB rGB) {
        this.fColorValue = rGB;
        this.updateColorImage();
    }

    public void setEnabled(boolean bl) {
        this.getButton().setEnabled(bl);
    }

    protected void updateColorImage() {
        Display display = this.fButton.getDisplay();
        GC gC = new GC(this.fImage);
        if (this.fColor != null) {
            this.fColor.dispose();
        }
        if (this.fColorValue == null) {
            gC.setBackground(this.fButton.getBackground());
            gC.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
        } else {
            gC.setForeground(display.getSystemColor(2));
            gC.drawRectangle(0, 2, this.fExtent.x - 1, this.fExtent.y - 4);
            this.fColor = new Color(display, this.fColorValue);
            gC.setBackground(this.fColor);
            gC.fillRectangle(1, 3, this.fExtent.x - 2, this.fExtent.y - 5);
        }
        gC.dispose();
        this.fButton.setImage(this.fImage);
    }

    public void open() {
        Shell shell = new Shell(Display.getCurrent(), 1264);
        shell.setLocation(this.fButton.toDisplay((int)0, (int)0).x + this.fButton.getBounds().width, this.fButton.toDisplay((int)0, (int)0).y - this.fButton.getBounds().height);
        ColorDialog colorDialog = new ColorDialog(shell, 65536);
        colorDialog.setRGB(this.fColorValue);
        colorDialog.setText("\u9009\u62e9\u989c\u8272");
        RGB rGB = colorDialog.open();
        if (rGB != null) {
            this.fColorValue = rGB;
            Event event = new Event();
            event.data = this.fColorValue;
            event.widget = this.fButton;
            this.fireModifyEvent(event);
            this.updateColorImage();
        }
        shell.dispose();
    }

    public void addModifyListener(ModifyListener modifyListener) {
        if (this.fButton == null || this.fButton.isDisposed()) {
            return;
        }
        if (modifyListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(modifyListener)) {
            this.listeners.add(modifyListener);
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        if (this.fButton == null || this.fButton.isDisposed()) {
            return;
        }
        if (modifyListener == null) {
            return;
        }
        this.listeners.remove(modifyListener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    void fireModifyEvent(Event event) {
        if (this.fButton == null || this.fButton.isDisposed() || !this.fButton.isEnabled()) {
            return;
        }
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                final ModifyEvent modifyEvent = new ModifyEvent(event);
                final ModifyListener modifyListener = (ModifyListener)this.listeners.get(i);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        modifyListener.modifyText(modifyEvent);
                    }
                });
            }
        }
    }
}

