/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

public class SWTGraphics {
    static final int AA_MASK;
    static final int AA_SHIFT;
    static final int AA_WHOLE_NUMBER = 1;
    static final int ADVANCED_GRAPHICS_MASK;
    static final int ADVANCED_HINTS_DEFAULTS;
    static final int ADVANCED_HINTS_MASK;
    static final int ADVANCED_SHIFT;
    static final int FILL_RULE_MASK;
    static final int FILL_RULE_SHIFT;
    static final int FILL_RULE_WHOLE_NUMBER = -1;
    static final int INTERPOLATION_MASK;
    static final int INTERPOLATION_SHIFT;
    static final int INTERPOLATION_WHOLE_NUMBER = 1;
    static final int TEXT_AA_MASK;
    static final int TEXT_AA_SHIFT;
    static final int XOR_MASK;
    static final int XOR_SHIFT;
    private final LazyState appliedState = new LazyState();
    private final State currentState = new State();
    private boolean elementsNeedUpdate;
    private GC gc;
    private boolean sharedClipping;
    private List stack = new ArrayList();
    private int stackPointer = 0;
    Transform transform;
    private int translateX = 0;
    private int translateY = 0;

    public SWTGraphics(GC gC) {
        this.gc = gC;
        this.init();
    }

    protected final void checkFill() {
        if (!this.currentState.bgColor.equals(this.appliedState.bgColor) && this.currentState.bgPattern == null) {
            this.appliedState.bgColor = this.currentState.bgColor;
            this.gc.setBackground(this.appliedState.bgColor);
        }
        this.checkGC();
    }

    protected final void checkGC() {
        if (this.appliedState.relativeClip != this.currentState.relativeClip) {
            this.appliedState.relativeClip = this.currentState.relativeClip;
            this.currentState.relativeClip.setOn(this.gc, this.translateX, this.translateY);
        }
        if (this.appliedState.graphicHints != this.currentState.graphicHints) {
            SWTGraphics.reconcileHints(this.gc, this.appliedState.graphicHints, this.currentState.graphicHints);
            this.appliedState.graphicHints = this.currentState.graphicHints;
        }
    }

    protected final void checkPaint() {
        LineAttributes lineAttributes;
        this.checkGC();
        if (!this.currentState.fgColor.equals(this.appliedState.fgColor) && this.currentState.fgPattern == null) {
            this.appliedState.fgColor = this.currentState.fgColor;
            this.gc.setForeground(this.appliedState.fgColor);
        }
        if (!this.appliedState.lineAttributes.equals(lineAttributes = this.currentState.lineAttributes)) {
            if (this.getAdvanced()) {
                this.gc.setLineAttributes(lineAttributes);
            } else {
                this.gc.setLineWidth((int)lineAttributes.width);
                this.gc.setLineCap(lineAttributes.cap);
                this.gc.setLineJoin(lineAttributes.join);
                this.gc.setLineStyle(lineAttributes.style);
                if (lineAttributes.dash != null) {
                    this.gc.setLineDash(SWTGraphics.convertFloatArrayToInt(lineAttributes.dash));
                }
            }
            this.appliedState.lineAttributes = SWTGraphics.clone(lineAttributes);
        }
        if (!this.currentState.bgColor.equals(this.appliedState.bgColor) && this.currentState.bgPattern == null) {
            this.appliedState.bgColor = this.currentState.bgColor;
            this.gc.setBackground(this.appliedState.bgColor);
        }
    }

    private void checkSharedClipping() {
        if (this.sharedClipping) {
            this.sharedClipping = false;
            boolean bl = this.appliedState == this.currentState.relativeClip;
            this.currentState.relativeClip = this.currentState.relativeClip.getCopy();
            if (bl) {
                this.appliedState.relativeClip = this.currentState.relativeClip;
            }
        }
    }

    protected final void checkText() {
        this.checkPaint();
        if (!this.appliedState.font.equals(this.currentState.font)) {
            this.appliedState.font = this.currentState.font;
            this.gc.setFont(this.appliedState.font);
        }
    }

    public void clipRect(Rectangle rectangle) {
        if (this.currentState.relativeClip == null) {
            throw new IllegalStateException("The current clipping area does not support intersection.");
        }
        this.checkSharedClipping();
        this.currentState.relativeClip.intersect(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        this.appliedState.relativeClip = null;
    }

    public void dispose() {
        while (this.stackPointer > 0) {
            this.popState();
        }
        if (this.transform != null) {
            this.transform.dispose();
        }
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkPaint();
        this.gc.drawArc(n + this.translateX, n2 + this.translateY, n3, n4, n5, n6);
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        this.checkPaint();
        this.gc.drawFocus(n + this.translateX, n2 + this.translateY, n3 + 1, n4 + 1);
    }

    public void drawImage(Image image, int n, int n2) {
        this.checkGC();
        this.gc.drawImage(image, n + this.translateX, n2 + this.translateY);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.checkGC();
        this.gc.drawImage(image, n, n2, n3, n4, n5 + this.translateX, n6 + this.translateY, n7, n8);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.checkPaint();
        this.gc.drawLine(n + this.translateX, n2 + this.translateY, n3 + this.translateX, n4 + this.translateY);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.checkPaint();
        this.gc.drawOval(n + this.translateX, n2 + this.translateY, n3, n4);
    }

    public void drawPath(Path path) {
        this.checkPaint();
        this.initTransform(false);
        this.gc.drawPath(path);
    }

    public void drawPoint(int n, int n2) {
        this.checkPaint();
        this.gc.drawPoint(n + this.translateX, n2 + this.translateY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolygon(int[] nArray) {
        this.checkPaint();
        try {
            this.translatePointArray(nArray, this.translateX, this.translateY);
            this.gc.drawPolygon(nArray);
        }
        finally {
            this.translatePointArray(nArray, -this.translateX, -this.translateY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolyline(int[] nArray) {
        this.checkPaint();
        try {
            this.translatePointArray(nArray, this.translateX, this.translateY);
            this.gc.drawPolyline(nArray);
        }
        finally {
            this.translatePointArray(nArray, -this.translateX, -this.translateY);
        }
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        this.checkPaint();
        this.gc.drawRectangle(n + this.translateX, n2 + this.translateY, n3, n4);
    }

    public void drawRoundRectangle(Rectangle rectangle, int n, int n2) {
        this.checkPaint();
        this.gc.drawRoundRectangle(rectangle.x + this.translateX, rectangle.y + this.translateY, rectangle.width, rectangle.height, n, n2);
    }

    public void drawString(String string, int n, int n2) {
        this.checkText();
        this.gc.drawString(string, n + this.translateX, n2 + this.translateY, true);
    }

    public void drawText(String string, int n, int n2) {
        this.checkText();
        this.gc.drawText(string, n + this.translateX, n2 + this.translateY, true);
    }

    public void drawTextLayout(TextLayout textLayout, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.checkText();
        textLayout.draw(this.gc, n + this.translateX, n2 + this.translateY, n3, n4, color, color2);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkFill();
        this.gc.fillArc(n + this.translateX, n2 + this.translateY, n3, n4, n5, n6);
    }

    public void fillGradient(int n, int n2, int n3, int n4, boolean bl) {
        this.checkPaint();
        this.gc.fillGradientRectangle(n + this.translateX, n2 + this.translateY, n3, n4, bl);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.checkFill();
        this.gc.fillOval(n + this.translateX, n2 + this.translateY, n3, n4);
    }

    public void fillPath(Path path) {
        this.checkFill();
        this.initTransform(false);
        this.gc.fillPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPolygon(int[] nArray) {
        this.checkFill();
        try {
            this.translatePointArray(nArray, this.translateX, this.translateY);
            this.gc.fillPolygon(nArray);
        }
        finally {
            this.translatePointArray(nArray, -this.translateX, -this.translateY);
        }
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        this.checkFill();
        this.gc.fillRectangle(n + this.translateX, n2 + this.translateY, n3, n4);
    }

    public void fillRoundRectangle(Rectangle rectangle, int n, int n2) {
        this.checkFill();
        this.gc.fillRoundRectangle(rectangle.x + this.translateX, rectangle.y + this.translateY, rectangle.width, rectangle.height, n, n2);
    }

    public void fillString(String string, int n, int n2) {
        this.checkText();
        this.gc.drawString(string, n + this.translateX, n2 + this.translateY, false);
    }

    public void fillText(String string, int n, int n2) {
        this.checkText();
        this.gc.drawText(string, n + this.translateX, n2 + this.translateY, false);
    }

    public int getAlpha() {
        return this.currentState.alpha;
    }

    public int getAntialias() {
        return ((this.currentState.graphicHints & AA_MASK) >> AA_SHIFT) - 1;
    }

    public boolean getAdvanced() {
        return (this.currentState.graphicHints & ADVANCED_GRAPHICS_MASK) != 0;
    }

    public Color getBackgroundColor() {
        return this.currentState.bgColor;
    }

    public Rectangle getClip(Rectangle rectangle) {
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.getBoundingBox(rectangle);
            return rectangle;
        }
        throw new IllegalStateException("Clipping can no longer be queried due to transformations");
    }

    public int getFillRule() {
        return ((this.currentState.graphicHints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1;
    }

    public Color getForegroundColor() {
        return this.currentState.fgColor;
    }

    public int getInterpolation() {
        return ((this.currentState.graphicHints & INTERPOLATION_MASK) >> INTERPOLATION_SHIFT) - 1;
    }

    public void getLineAttributes(LineAttributes lineAttributes) {
        SWTGraphics.copyLineAttributes(lineAttributes, this.currentState.lineAttributes);
    }

    public int getLineCap() {
        return this.currentState.lineAttributes.cap;
    }

    public int getLineJoin() {
        return this.currentState.lineAttributes.join;
    }

    public int getLineStyle() {
        return this.currentState.lineAttributes.style;
    }

    public int getLineWidth() {
        return (int)this.currentState.lineAttributes.width;
    }

    public float getLineWidthFloat() {
        return this.currentState.lineAttributes.width;
    }

    public float getLineMiterLimit() {
        return this.currentState.lineAttributes.miterLimit;
    }

    public float[] getLineDash() {
        return (float[])this.currentState.lineAttributes.dash.clone();
    }

    public float getLineDashOffset() {
        return this.currentState.lineAttributes.dashOffset;
    }

    public int getTextAntialias() {
        return ((this.currentState.graphicHints & TEXT_AA_MASK) >> TEXT_AA_SHIFT) - 1;
    }

    public boolean getXORMode() {
        return (this.currentState.graphicHints & XOR_MASK) != 0;
    }

    protected void init() {
        this.currentState.bgColor = this.appliedState.bgColor = this.gc.getBackground();
        this.currentState.fgColor = this.appliedState.fgColor = this.gc.getForeground();
        this.currentState.font = this.appliedState.font = this.gc.getFont();
        this.currentState.lineAttributes = this.gc.getLineAttributes();
        this.appliedState.lineAttributes = SWTGraphics.clone(this.currentState.lineAttributes);
        this.currentState.graphicHints |= this.gc.getLineStyle();
        this.currentState.graphicHints = this.currentState.graphicHints | (this.gc.getAdvanced() ? ADVANCED_GRAPHICS_MASK : 0);
        this.appliedState.graphicHints = this.currentState.graphicHints = this.currentState.graphicHints | (this.gc.getXORMode() ? XOR_MASK : 0);
        this.currentState.relativeClip = new RectangleClipping(this.gc.getClipping());
        this.currentState.alpha = this.gc.getAlpha();
    }

    private void initTransform(boolean bl) {
        if (!bl && this.translateX == 0 && this.translateY == 0) {
            return;
        }
        if (this.transform == null) {
            this.transform = new Transform(Display.getCurrent());
            this.elementsNeedUpdate = true;
            this.transform.translate(this.translateX, this.translateY);
            this.translateX = 0;
            this.translateY = 0;
            this.gc.setTransform(this.transform);
            this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
        }
    }

    public void popState() {
        --this.stackPointer;
        this.restoreState((State)this.stack.get(this.stackPointer));
    }

    public void pushState() {
        if (this.currentState.relativeClip == null) {
            throw new IllegalStateException("The clipping has been modified ina way that cannot be saved and restored.");
        }
        try {
            this.currentState.dx = this.translateX;
            this.currentState.dy = this.translateY;
            if (this.elementsNeedUpdate) {
                this.elementsNeedUpdate = false;
                this.currentState.affineMatrix = new float[6];
                this.transform.getElements(this.currentState.affineMatrix);
            }
            if (this.stack.size() > this.stackPointer) {
                State state = (State)this.stack.get(this.stackPointer);
                state.copyFrom(this.currentState);
            } else {
                this.stack.add(this.currentState.clone());
            }
            this.sharedClipping = true;
            ++this.stackPointer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    private static void reconcileHints(GC gC, int n, int n2) {
        int n3 = n2 ^ n;
        if ((n3 & XOR_MASK) != 0) {
            gC.setXORMode((n2 & XOR_MASK) != 0);
        }
        if ((n3 &= ~XOR_MASK) != 0) {
            if ((n3 & INTERPOLATION_MASK) != 0) {
                gC.setInterpolation(((n2 & INTERPOLATION_MASK) >> INTERPOLATION_SHIFT) - 1);
            }
            if ((n3 & FILL_RULE_MASK) != 0) {
                gC.setFillRule(((n2 & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1);
            }
            if ((n3 & AA_MASK) != 0) {
                gC.setAntialias(((n2 & AA_MASK) >> AA_SHIFT) - 1);
            }
            if ((n3 & TEXT_AA_MASK) != 0) {
                gC.setTextAntialias(((n2 & TEXT_AA_MASK) >> TEXT_AA_SHIFT) - 1);
            }
            if ((n3 & ADVANCED_GRAPHICS_MASK) != 0 && (n2 & ADVANCED_GRAPHICS_MASK) != 0 && !gC.getAdvanced()) {
                gC.setAdvanced(true);
            }
        }
    }

    public void restoreState() {
        this.restoreState((State)this.stack.get(this.stackPointer - 1));
    }

    protected void restoreState(State state) {
        this.setAffineMatrix(state.affineMatrix);
        this.currentState.relativeClip = state.relativeClip;
        this.sharedClipping = true;
        if (this.gc.getAdvanced() && (state.graphicHints & ADVANCED_GRAPHICS_MASK) == 0) {
            this.appliedState.relativeClip = null;
            this.gc.setAdvanced(false);
            this.appliedState.graphicHints &= ~ADVANCED_HINTS_MASK;
            this.appliedState.graphicHints |= ADVANCED_HINTS_DEFAULTS;
        }
        this.setBackgroundColor(state.bgColor);
        this.setBackgroundPattern(state.bgPattern);
        this.setForegroundColor(state.fgColor);
        this.setForegroundPattern(state.fgPattern);
        this.setAlpha(state.alpha);
        this.setLineAttributes(state.lineAttributes);
        this.setFont(state.font);
        this.setGraphicHints(state.graphicHints);
        this.translateX = this.currentState.dx = state.dx;
        this.translateY = this.currentState.dy = state.dy;
    }

    public void rotate(float f) {
        this.checkGC();
        this.initTransform(true);
        this.transform.rotate(f);
        this.gc.setTransform(this.transform);
        this.elementsNeedUpdate = true;
        this.currentState.relativeClip = null;
        this.appliedState.relativeClip = null;
    }

    public void scale(double d) {
        this.scale((float)d, (float)d);
    }

    public void scale(float f, float f2) {
        this.checkGC();
        this.initTransform(true);
        this.transform.scale(f, f2);
        this.gc.setTransform(this.transform);
        this.elementsNeedUpdate = true;
        this.checkSharedClipping();
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.scale(f, f2);
        }
    }

    private void setAffineMatrix(float[] fArray) {
        if (!this.elementsNeedUpdate && this.currentState.affineMatrix == fArray) {
            return;
        }
        this.currentState.affineMatrix = fArray;
        if (fArray != null) {
            this.transform.setElements(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
        } else if (this.transform != null) {
            this.transform.dispose();
            this.transform = null;
            this.elementsNeedUpdate = false;
        }
        this.gc.setTransform(this.transform);
    }

    public void setAlpha(int n) {
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
        if (this.currentState.alpha != n) {
            this.currentState.alpha = n;
            this.gc.setAlpha(this.currentState.alpha);
        }
    }

    public void setAntialias(int n) {
        this.currentState.graphicHints &= ~AA_MASK;
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK | n + 1 << AA_SHIFT;
    }

    public void setAdvanced(boolean bl) {
        this.currentState.graphicHints = bl ? (this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK) : (this.currentState.graphicHints &= ~ADVANCED_GRAPHICS_MASK);
    }

    public void setBackgroundColor(Color color) {
        this.currentState.bgColor = color;
        if (this.currentState.bgPattern != null) {
            this.currentState.bgPattern = null;
            this.appliedState.bgColor = null;
        }
    }

    public void setBackgroundPattern(Pattern pattern) {
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
        if (this.currentState.bgPattern == pattern) {
            return;
        }
        this.currentState.bgPattern = pattern;
        if (pattern != null) {
            this.initTransform(true);
        }
        this.gc.setBackgroundPattern(pattern);
    }

    public void setClip(Path path) {
        this.initTransform(false);
        if (((this.appliedState.graphicHints ^ this.currentState.graphicHints) & FILL_RULE_MASK) != 0) {
            this.gc.setFillRule(((this.currentState.graphicHints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1);
            this.appliedState.graphicHints ^= FILL_RULE_MASK;
        }
        this.gc.setClipping(path);
        this.currentState.relativeClip = null;
        this.appliedState.relativeClip = null;
    }

    public void setClip(Rectangle rectangle) {
        this.currentState.relativeClip = new RectangleClipping(rectangle);
    }

    public void setFillRule(int n) {
        this.currentState.graphicHints &= ~FILL_RULE_MASK;
        this.currentState.graphicHints |= n + -1 << FILL_RULE_SHIFT;
    }

    public void setFont(Font font) {
        this.currentState.font = font;
    }

    public void setForegroundColor(Color color) {
        this.currentState.fgColor = color;
        if (this.currentState.fgPattern != null) {
            this.currentState.fgPattern = null;
            this.appliedState.fgColor = null;
        }
    }

    public void setForegroundPattern(Pattern pattern) {
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
        if (this.currentState.fgPattern == pattern) {
            return;
        }
        this.currentState.fgPattern = pattern;
        if (pattern != null) {
            this.initTransform(true);
        }
        this.gc.setForegroundPattern(pattern);
    }

    private void setGraphicHints(int n) {
        this.currentState.graphicHints = n;
    }

    public void setInterpolation(int n) {
        this.currentState.graphicHints &= ~INTERPOLATION_MASK;
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK | n + 1 << INTERPOLATION_SHIFT;
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        SWTGraphics.copyLineAttributes(this.currentState.lineAttributes, lineAttributes);
    }

    public void setLineCap(int n) {
        this.currentState.lineAttributes.cap = n;
    }

    public void setLineDash(int[] nArray) {
        float[] fArray = null;
        if (nArray != null) {
            fArray = new float[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                fArray[i] = nArray[i];
            }
        }
        this.setLineDash(fArray);
    }

    public void setLineDash(float[] fArray) {
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                if (!(fArray[i] <= 0.0f)) continue;
                SWT.error(5);
            }
            this.currentState.lineAttributes.dash = (float[])fArray.clone();
            this.currentState.lineAttributes.style = 6;
        } else {
            this.currentState.lineAttributes.dash = null;
            this.currentState.lineAttributes.style = 1;
        }
    }

    public void setLineDashOffset(float f) {
        this.currentState.lineAttributes.dashOffset = f;
    }

    public void setLineJoin(int n) {
        this.currentState.lineAttributes.join = n;
    }

    public void setLineStyle(int n) {
        this.currentState.lineAttributes.style = n;
    }

    public void setLineWidth(int n) {
        this.currentState.lineAttributes.width = n;
    }

    public void setLineWidthFloat(float f) {
        this.currentState.lineAttributes.width = f;
    }

    public void setLineMiterLimit(float f) {
        this.currentState.lineAttributes.miterLimit = f;
    }

    public void setTextAntialias(int n) {
        this.currentState.graphicHints &= ~TEXT_AA_MASK;
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK | n + 1 << TEXT_AA_SHIFT;
    }

    public void setXORMode(boolean bl) {
        this.currentState.graphicHints &= ~XOR_MASK;
        if (bl) {
            this.currentState.graphicHints |= XOR_MASK;
        }
    }

    public void shear(float f, float f2) {
        this.checkGC();
        this.initTransform(true);
        float[] fArray = new float[6];
        this.transform.getElements(fArray);
        this.transform.setElements(fArray[0] + fArray[2] * f2, fArray[1] + fArray[3] * f2, fArray[0] * f + fArray[2], fArray[1] * f + fArray[3], fArray[4], fArray[5]);
        this.gc.setTransform(this.transform);
        this.elementsNeedUpdate = true;
        this.currentState.relativeClip = null;
        this.appliedState.relativeClip = null;
    }

    public void translate(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        if (this.transform != null) {
            this.checkGC();
            this.transform.translate(n, n2);
            this.elementsNeedUpdate = true;
            this.gc.setTransform(this.transform);
        } else {
            this.translateX += n;
            this.translateY += n2;
        }
        this.checkSharedClipping();
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.translate(-n, -n2);
        }
    }

    public void translate(float f, float f2) {
        this.initTransform(true);
        this.checkGC();
        this.transform.translate(f, f2);
        this.elementsNeedUpdate = true;
        this.gc.setTransform(this.transform);
        this.checkSharedClipping();
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.translate(-f, -f2);
        }
    }

    private void translatePointArray(int[] nArray, int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        int n3 = 0;
        while (n3 + 1 < nArray.length) {
            int n4 = n3;
            nArray[n4] = nArray[n4] + n;
            int n5 = n3 + 1;
            nArray[n5] = nArray[n5] + n2;
            n3 += 2;
        }
    }

    static LineAttributes clone(LineAttributes lineAttributes) {
        float[] fArray = null;
        if (lineAttributes.dash != null) {
            fArray = new float[lineAttributes.dash.length];
            System.arraycopy(lineAttributes.dash, 0, fArray, 0, fArray.length);
        }
        return new LineAttributes(lineAttributes.width, lineAttributes.cap, lineAttributes.join, lineAttributes.style, fArray, lineAttributes.dashOffset, lineAttributes.miterLimit);
    }

    static void copyLineAttributes(LineAttributes lineAttributes, LineAttributes lineAttributes2) {
        if (lineAttributes != lineAttributes2) {
            lineAttributes.cap = lineAttributes2.cap;
            lineAttributes.join = lineAttributes2.join;
            lineAttributes.miterLimit = lineAttributes2.miterLimit;
            lineAttributes.style = lineAttributes2.style;
            lineAttributes.width = lineAttributes2.width;
            if (lineAttributes2.dash == null) {
                lineAttributes.dash = null;
            } else {
                if (lineAttributes.dash == null || lineAttributes.dash.length != lineAttributes2.dash.length) {
                    lineAttributes.dash = new float[lineAttributes2.dash.length];
                }
                System.arraycopy(lineAttributes2.dash, 0, lineAttributes.dash, 0, lineAttributes2.dash.length);
            }
        }
    }

    private static int[] convertFloatArrayToInt(float[] fArray) {
        int[] nArray = null;
        if (fArray != null) {
            int n = fArray.length;
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = (int)fArray[i];
            }
        }
        return nArray;
    }

    static {
        XOR_SHIFT = 3;
        AA_SHIFT = 8;
        TEXT_AA_SHIFT = 10;
        INTERPOLATION_SHIFT = 12;
        FILL_RULE_SHIFT = 14;
        ADVANCED_SHIFT = 15;
        AA_MASK = 3 << AA_SHIFT;
        FILL_RULE_MASK = 1 << FILL_RULE_SHIFT;
        INTERPOLATION_MASK = 3 << INTERPOLATION_SHIFT;
        TEXT_AA_MASK = 3 << TEXT_AA_SHIFT;
        XOR_MASK = 1 << XOR_SHIFT;
        ADVANCED_GRAPHICS_MASK = 1 << ADVANCED_SHIFT;
        ADVANCED_HINTS_MASK = TEXT_AA_MASK | AA_MASK | INTERPOLATION_MASK;
        ADVANCED_HINTS_DEFAULTS = 0 << TEXT_AA_SHIFT | 0 << AA_SHIFT | 0 << INTERPOLATION_SHIFT;
    }

    static interface Clipping {
        public Rectangle getBoundingBox(Rectangle var1);

        public Clipping getCopy();

        public void intersect(int var1, int var2, int var3, int var4);

        public void scale(float var1, float var2);

        public void setOn(GC var1, int var2, int var3);

        public void translate(float var1, float var2);
    }

    static class LazyState {
        Color bgColor;
        Color fgColor;
        Font font;
        int graphicHints;
        LineAttributes lineAttributes;
        Clipping relativeClip;

        LazyState() {
        }
    }

    static class RectangleClipping
    implements Clipping {
        private float top;
        private float left;
        private float bottom;
        private float right;

        RectangleClipping(float f, float f2, float f3, float f4) {
            this.left = f;
            this.right = f3;
            this.bottom = f4;
            this.top = f2;
        }

        RectangleClipping(Rectangle rectangle) {
            this.left = rectangle.x;
            this.top = rectangle.y;
            this.right = rectangle.x + rectangle.width;
            this.bottom = rectangle.y + rectangle.height;
        }

        public Rectangle getBoundingBox(Rectangle rectangle) {
            rectangle.x = (int)this.left;
            rectangle.y = (int)this.top;
            rectangle.width = (int)Math.ceil(this.right) - rectangle.x;
            rectangle.height = (int)Math.ceil(this.bottom) - rectangle.y;
            return rectangle;
        }

        public Clipping getCopy() {
            return new RectangleClipping(this.left, this.top, this.right, this.bottom);
        }

        public void intersect(int n, int n2, int n3, int n4) {
            this.left = Math.max(this.left, (float)n);
            this.right = Math.min(this.right, (float)n3);
            this.top = Math.max(this.top, (float)n2);
            this.bottom = Math.min(this.bottom, (float)n4);
            if (n3 < n || n4 < n2) {
                this.right = n - 1;
                this.bottom = n2 - 1;
            }
        }

        public void scale(float f, float f2) {
            this.left /= f;
            this.right /= f;
            this.top /= f2;
            this.bottom /= f2;
        }

        public void setOn(GC gC, int n, int n2) {
            int n3 = (int)Math.floor(this.left);
            int n4 = (int)Math.floor(this.top);
            gC.setClipping(n3 + n, n4 + n2, (int)Math.ceil(this.right) - n3, (int)Math.ceil(this.bottom) - n4);
        }

        public void translate(float f, float f2) {
            this.left += f;
            this.right += f;
            this.top += f2;
            this.bottom += f2;
        }
    }

    static class State
    extends LazyState
    implements Cloneable {
        float[] affineMatrix;
        int alpha;
        Pattern bgPattern;
        int dx;
        int dy;
        Pattern fgPattern;

        State() {
        }

        public Object clone() throws CloneNotSupportedException {
            State state = (State)super.clone();
            state.lineAttributes = SWTGraphics.clone(state.lineAttributes);
            return state;
        }

        public void copyFrom(State state) {
            this.bgColor = state.bgColor;
            this.fgColor = state.fgColor;
            this.lineAttributes = SWTGraphics.clone(state.lineAttributes);
            this.dx = state.dx;
            this.dy = state.dy;
            this.bgPattern = state.bgPattern;
            this.fgPattern = state.fgPattern;
            this.font = state.font;
            this.graphicHints = state.graphicHints;
            this.affineMatrix = state.affineMatrix;
            this.relativeClip = state.relativeClip;
            this.alpha = state.alpha;
        }
    }
}

