/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import net.sourceforge.pinyin4j.ResourceHelper;

class ChineseToPinyinResource {
    private Properties unicodeToHanyuPinyinTable = null;

    private void setUnicodeToHanyuPinyinTable(Properties properties) {
        this.unicodeToHanyuPinyinTable = properties;
    }

    private Properties getUnicodeToHanyuPinyinTable() {
        return this.unicodeToHanyuPinyinTable;
    }

    private ChineseToPinyinResource() {
        this.initializeResource();
    }

    private void initializeResource() {
        try {
            this.setUnicodeToHanyuPinyinTable(new Properties());
            this.getUnicodeToHanyuPinyinTable().load(ResourceHelper.getResourceInputStream("/pinyindb/unicode_to_hanyu_pinyin.txt"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    String[] getHanyuPinyinStringArray(char c) {
        String string = this.getHanyuPinyinRecordFromChar(c);
        if (null != string) {
            int n = string.indexOf("(");
            int n2 = string.lastIndexOf(")");
            String string2 = string.substring(n + "(".length(), n2);
            return string2.split(",");
        }
        return null;
    }

    private boolean isValidRecord(String string) {
        return null != string && !string.equals("(none0)") && string.startsWith("(") && string.endsWith(")");
    }

    private String getHanyuPinyinRecordFromChar(char c) {
        char c2 = c;
        String string = Integer.toHexString(c2).toUpperCase();
        String string2 = this.getUnicodeToHanyuPinyinTable().getProperty(string);
        return this.isValidRecord(string2) ? string2 : null;
    }

    static ChineseToPinyinResource getInstance() {
        return ChineseToPinyinResourceHolder.theInstance;
    }

    private static class ChineseToPinyinResourceHolder {
        static final ChineseToPinyinResource theInstance = new ChineseToPinyinResource();

        private ChineseToPinyinResourceHolder() {
        }
    }

    class Field {
        static final String LEFT_BRACKET = "(";
        static final String RIGHT_BRACKET = ")";
        static final String COMMA = ",";

        Field() {
        }
    }
}

