/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.graphics.ImageData;
import org.sf.feeling.swt.win32.extension.graphics.dds.compression.DXTBufferDecompressor;
import org.sf.feeling.swt.win32.extension.graphics.dds.ddsutil.DDSUtil;
import org.sf.feeling.swt.win32.extension.graphics.dds.jogl.DDSImage;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Squish;
import org.sf.feeling.swt.win32.extension.graphics.dds.model.DDSFile;

public class DDSLoader {
    public static DDSImage loadDDSImage(InputStream inputStream) throws IOException {
        DDSImage dDSImage = DDSImage.read(inputStream);
        inputStream.close();
        return dDSImage;
    }

    public static ImageData getImageData(DDSImage dDSImage) {
        if (dDSImage == null) {
            return null;
        }
        Squish.CompressionType compressionType = DDSUtil.getSquishCompressionFormat(dDSImage.getFormatType());
        return new DXTBufferDecompressor(dDSImage.getMipMap(0).getData(), dDSImage.getWidth(), dDSImage.getHeight(), compressionType).getImage();
    }

    public static boolean isDDSImage(InputStream inputStream) throws IOException {
        boolean bl = DDSImage.isDDSImage(inputStream);
        inputStream.close();
        return bl;
    }

    public static void saveImage(OutputStream outputStream, ImageData imageData, DDSFile.PixelFormat pixelFormat, boolean bl) throws IOException {
        DDSUtil.write(outputStream, imageData, pixelFormat.getFormatType(), bl);
    }
}

