/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.sf.feeling.swt.win32.internal.extension.Extension;

public class GraphicsUtil {
    private static boolean gdip = true;

    public static RGB calculateColor(Color color, Color color2, int n) {
        float f = color.getRed();
        float f2 = color.getGreen();
        float f3 = color.getBlue();
        float f4 = color2.getRed();
        float f5 = color2.getGreen();
        float f6 = color2.getBlue();
        float f7 = f * (float)n / 255.0f + f4 * ((float)(255 - n) / 255.0f);
        float f8 = f2 * (float)n / 255.0f + f5 * ((float)(255 - n) / 255.0f);
        float f9 = f3 * (float)n / 255.0f + f6 * ((float)(255 - n) / 255.0f);
        int n2 = (int)f7;
        int n3 = (int)f8;
        int n4 = (int)f9;
        return new RGB(n2, n3, n4);
    }

    public static RGB calculateColor(RGB rGB, RGB rGB2, int n) {
        float f = rGB.red;
        float f2 = rGB.green;
        float f3 = rGB.blue;
        float f4 = rGB2.red;
        float f5 = rGB2.green;
        float f6 = rGB2.blue;
        float f7 = f * (float)n / 255.0f + f4 * ((float)(255 - n) / 255.0f);
        float f8 = f2 * (float)n / 255.0f + f5 * ((float)(255 - n) / 255.0f);
        float f9 = f3 * (float)n / 255.0f + f6 * ((float)(255 - n) / 255.0f);
        int n2 = (int)f7;
        int n3 = (int)f8;
        int n4 = (int)f9;
        return new RGB(n2, n3, n4);
    }

    public static RGB mergeColors(Color color, float f, Color color2, float f2, Color color3, float f3) {
        int n = (int)((float)color.getRed() * f + (float)color2.getRed() * f2 + (float)color3.getRed() * f3);
        int n2 = (int)((float)color.getGreen() * f + (float)color2.getGreen() * f2 + (float)color3.getGreen() * f3);
        int n3 = (int)((float)color.getBlue() * f + (float)color2.getBlue() * f2 + (float)color3.getBlue() * f3);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        return new RGB(n, n2, n3);
    }

    public static RGB mergeColors(RGB rGB, float f, RGB rGB2, float f2, RGB rGB3, float f3) {
        int n = (int)((float)rGB.red * f + (float)rGB2.red * f2 + (float)rGB3.red * f3);
        int n2 = (int)((float)rGB.green * f + (float)rGB2.green * f2 + (float)rGB3.green * f3);
        int n3 = (int)((float)rGB.blue * f + (float)rGB2.blue * f2 + (float)rGB3.blue * f3);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        return new RGB(n, n2, n3);
    }

    public static RGB mergeColors(Color color, float f, Color color2, float f2) {
        return GraphicsUtil.mergeColors(color, f, color2, f2, new Color(null, 0, 0, 0), 0.0f);
    }

    public static RGB mergeColors(RGB rGB, float f, RGB rGB2, float f2) {
        return GraphicsUtil.mergeColors(rGB, f, rGB2, f2, new RGB(0, 0, 0), 0.0f);
    }

    public static Path createRoundPath(Rectangle rectangle, float f) {
        Path path = new Path(null);
        path.moveTo((float)rectangle.x + f, (float)rectangle.y);
        path.lineTo((float)(rectangle.x + rectangle.width) - f, (float)rectangle.y);
        path.lineTo((float)(rectangle.x + rectangle.width) - f, (float)rectangle.y);
        path.lineTo((float)rectangle.x + (float)rectangle.width, (float)rectangle.y + f);
        path.lineTo((float)rectangle.x + (float)rectangle.width, (float)rectangle.y + f);
        path.lineTo((float)rectangle.x + (float)rectangle.width, (float)(rectangle.y + rectangle.height) - f);
        path.lineTo((float)rectangle.x + (float)rectangle.width, (float)(rectangle.y + rectangle.height) - f);
        path.lineTo((float)(rectangle.x + rectangle.width) - f, (float)rectangle.y + (float)rectangle.height);
        path.lineTo((float)(rectangle.x + rectangle.width) - f, (float)rectangle.y + (float)rectangle.height);
        path.lineTo((float)rectangle.x + f, (float)rectangle.y + (float)rectangle.height);
        path.lineTo((float)rectangle.x + f, (float)rectangle.y + (float)rectangle.height);
        path.lineTo((float)rectangle.x, (float)(rectangle.y + rectangle.height) - f);
        path.lineTo((float)rectangle.x, (float)(rectangle.y + rectangle.height) - f);
        path.lineTo((float)rectangle.x, (float)rectangle.y + f);
        path.lineTo((float)rectangle.x, (float)rectangle.y + f);
        path.lineTo((float)rectangle.x + f, (float)rectangle.y);
        return path;
    }

    public static Path createRoundRectangle(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.addArc((float)n2, (float)n3, (float)n6, (float)n6, -180.0f, -90.0f);
        path.lineTo((float)(n2 + n), (float)n3);
        path.lineTo((float)(n2 + n4 - n), (float)n3);
        path.addArc((float)(n2 + n4 - n6), (float)n3, (float)n6, (float)n6, -270.0f, -90.0f);
        path.lineTo((float)(n2 + n4), (float)(n3 + n));
        path.lineTo((float)(n2 + n4), (float)(n3 + n5 - n));
        path.addArc((float)(n2 + n4 - n6), (float)(n3 + n5 - n6), (float)n6, (float)n6, 0.0f, -90.0f);
        path.lineTo((float)(n2 + n4 - n), (float)(n3 + n5));
        path.lineTo((float)(n2 + n), (float)(n3 + n5));
        path.addArc((float)n2, (float)(n3 + n5 - n6), (float)n6, (float)n6, -90.0f, -90.0f);
        path.lineTo((float)n2, (float)(n3 + n5 - n));
        path.lineTo((float)n2, (float)(n3 + n));
        path.close();
        return path;
    }

    public static Path createTopRoundRectangle(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.addArc((float)n2, (float)n3, (float)n6, (float)n6, -180.0f, -90.0f);
        path.lineTo((float)(n2 + n), (float)n3);
        path.lineTo((float)(n2 + n4 - n), (float)n3);
        path.addArc((float)(n2 + n4 - n6), (float)n3, (float)n6, (float)n6, -270.0f, -90.0f);
        path.lineTo((float)(n2 + n4), (float)(n3 + n));
        path.lineTo((float)(n2 + n4), (float)(n3 + n5));
        path.lineTo((float)n2, (float)(n3 + n5));
        path.lineTo((float)n2, (float)(n3 + n));
        path.close();
        return path;
    }

    public static Path createBottomRoundRectangle(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.moveTo((float)n2, (float)n3);
        path.lineTo((float)(n2 + n4), (float)n3);
        path.lineTo((float)(n2 + n4), (float)(n3 + n5 - n));
        path.addArc((float)(n2 + n4 - n6), (float)(n3 + n5 - n6), (float)n6, (float)n6, 0.0f, -90.0f);
        path.lineTo((float)(n2 + n4 - n), (float)(n3 + n5));
        path.lineTo((float)(n2 + n), (float)(n3 + n5));
        path.addArc((float)n2, (float)(n3 + n5 - n6), (float)n6, (float)n6, -90.0f, -90.0f);
        path.lineTo((float)n2, (float)(n3 + n5 - n));
        path.lineTo((float)n2, (float)n3);
        path.close();
        return path;
    }

    public static Rectangle inflate(Rectangle rectangle, int n, int n2) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle2.x -= n;
        rectangle2.y -= n2;
        rectangle2.width += 2 * n;
        rectangle2.height += 2 * n2;
        return rectangle2;
    }

    public static boolean checkGdip() {
        return gdip;
    }

    public static Rectangle createRectangleFromLTRB(int n, int n2, int n3, int n4) {
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public static Path createEllipsePath(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        float f5 = f3;
        float f6 = f4;
        Path path = new Path(null);
        path.addArc(f, f2, f5, f6, -180.0f, -90.0f);
        path.addArc(f + f3 - f5, f2, f5, f6, -270.0f, -90.0f);
        path.addArc(f + f3 - f5, f2 + f4 - f6, f5, f6, 0.0f, -90.0f);
        path.addArc(f, f2 + f4 - f6, f5, f6, -90.0f, -90.0f);
        path.close();
        return path;
    }

    public static void drawArrow(GC gC, Rectangle rectangle, int n) {
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        int[] nArray = null;
        switch (n) {
            case 16384: {
                nArray = new int[]{point.x + 2, point.y - 4, point.x + 2, point.y + 4, point.x - 2, point.y};
                gC.fillPolygon(nArray);
                break;
            }
            case 128: {
                gC.fillRectangle(new Rectangle(point.x, point.y - 1, 1, 1));
                gC.fillRectangle(new Rectangle(point.x - 1, point.y, 3, 1));
                gC.fillRectangle(new Rectangle(point.x - 2, point.y + 1, 5, 1));
                break;
            }
            case 131072: {
                nArray = new int[]{point.x - 2, point.y - 4, point.x - 2, point.y + 4, point.x + 2, point.y};
                gC.fillPolygon(nArray);
                break;
            }
            default: {
                gC.fillRectangle(new Rectangle(point.x - 2, point.y - 1, 5, 1));
                gC.fillRectangle(new Rectangle(point.x - 1, point.y, 3, 1));
                gC.fillRectangle(new Rectangle(point.x, point.y + 1, 1, 1));
            }
        }
    }

    private static ImageData resize(Image image, int n, int n2) {
        ImageData imageData;
        ImageData imageData2 = imageData = image.getImageData();
        ImageData imageData3 = new ImageData(n, n2, 24, new PaletteData(0xFF0000, 65280, 255));
        Image image2 = new Image((Device)Display.getDefault(), imageData);
        Image image3 = new Image((Device)Display.getDefault(), imageData3);
        GC gC = new GC((Drawable)image3);
        gC.setAdvanced(true);
        try {
            gC.setInterpolation(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gC.drawImage(image2, 0, 0, imageData.width, imageData.height, 0, 0, imageData3.width, imageData3.height);
        gC.dispose();
        imageData2 = image3.getImageData();
        image2.dispose();
        image3.dispose();
        return imageData2;
    }

    public static ImageData resizeImage(ImageData imageData, int n, int n2, boolean bl) {
        Image image = new Image(null, imageData);
        ImageData imageData2 = GraphicsUtil.resizeImage(image, n, n2, bl);
        image.dispose();
        return imageData2;
    }

    public static ImageData resizeImage(Image image, int n, int n2, boolean bl) {
        ImageData imageData = null;
        if (bl) {
            ImageData imageData2 = image.getImageData();
            float f = 1.0f;
            f = (float)imageData2.width / (float)imageData2.height > (float)n / (float)n2 ? (float)n2 * f / (float)imageData2.height : (float)n * f / (float)imageData2.width;
            ImageData imageData3 = GraphicsUtil.resize(image, (int)((float)imageData2.width * f + 0.5f), (int)((float)imageData2.height * f + 0.5f));
            int n3 = (n - imageData3.width) / 2;
            n3 = n3 > 0 ? 0 : n3;
            int n4 = (n2 - imageData3.height) / 2;
            n4 = n4 > 0 ? 0 : n4;
            ImageData imageData4 = new ImageData(n, n2, 24, new PaletteData(0xFF0000, 65280, 255));
            Image image2 = new Image((Device)Display.getDefault(), imageData3);
            Image image3 = new Image((Device)Display.getDefault(), imageData4);
            GC gC = new GC((Drawable)image3);
            gC.setAdvanced(true);
            try {
                gC.setInterpolation(2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            gC.drawImage(image2, -n3, -n4, n, n2, 0, 0, n, n2);
            gC.dispose();
            imageData = image3.getImageData();
            image2.dispose();
            image3.dispose();
        } else {
            imageData = GraphicsUtil.resize(image, n, n2);
        }
        return imageData;
    }

    static {
        gdip = Extension.LoadLibrary("gdiplus.dll") != 0;
    }
}

