/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.compression;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Squish;
import org.sf.feeling.swt.win32.extension.graphics.dds.util.ImageUtils;

public class DXTBufferCompressor {
    protected byte[] byteData;
    protected int[] intData;
    protected Point dimension;
    protected Squish.CompressionType compressionType;

    public DXTBufferCompressor(byte[] byArray, int n, int n2, Squish.CompressionType compressionType) {
        this(byArray, new Point(n, n2), compressionType);
    }

    public DXTBufferCompressor(ByteBuffer byteBuffer, int n, int n2, Squish.CompressionType compressionType) {
        this(DXTBufferCompressor.toByteArray(byteBuffer), new Point(n, n2), compressionType);
    }

    public DXTBufferCompressor(ImageData imageData, Squish.CompressionType compressionType) {
        this(ImageUtils.convertRGBAToBGRA(imageData), new Point(imageData.width, imageData.height), compressionType);
    }

    public DXTBufferCompressor(byte[] byArray, Point point, Squish.CompressionType compressionType) {
        this.byteData = byArray;
        this.dimension = point;
        this.compressionType = compressionType;
    }

    public DXTBufferCompressor(int[] nArray, Point point, Squish.CompressionType compressionType) {
        this.intData = nArray;
        this.dimension = point;
        this.compressionType = compressionType;
    }

    public ByteBuffer getByteBuffer() {
        try {
            if (this.byteData.length < this.dimension.y * this.dimension.x * 4) {
                this.byteData = this.convertBGRArrayToBGRAArray(this.byteData, this.dimension);
            }
            byte[] byArray = DXTBufferCompressor.squishCompressToArray(this.byteData, this.dimension.x, this.dimension.y, this.compressionType);
            return ByteBuffer.wrap(byArray);
        }
        catch (DataFormatException dataFormatException) {
            dataFormatException.printStackTrace();
            return null;
        }
    }

    private byte[] convertBGRArrayToBGRAArray(byte[] byArray, Point point) {
        int n = byArray.length;
        int n2 = point.x * point.y * 4;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < n; i += 3) {
            int n4 = i;
            int n5 = i + n3;
            System.arraycopy(byArray, n4, byArray2, n5, 3);
            ++n3;
        }
        return byArray2;
    }

    public byte[] getArray() {
        try {
            return DXTBufferCompressor.squishCompressToArray(this.byteData, this.dimension.x, this.dimension.y, this.compressionType);
        }
        catch (DataFormatException dataFormatException) {
            dataFormatException.printStackTrace();
            return this.byteData;
        }
    }

    private static byte[] squishCompressToArray(byte[] byArray, int n, int n2, Squish.CompressionType compressionType) throws DataFormatException {
        int n3 = n * n2 * 4;
        if (byArray.length != n3) {
            throw new DataFormatException("unexpected length:" + byArray.length + " instead of " + n3);
        }
        int n4 = Squish.getStorageRequirements(n, n2, compressionType);
        return Squish.compressImage(byArray, n, n2, new byte[n4], compressionType, Squish.CompressionMethod.CLUSTER_FIT);
    }

    private static byte[] toByteArray(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.capacity()];
        byteBuffer.get(byArray);
        return byArray;
    }

    public int getStorageRequirements() {
        return DXTBufferCompressor.getStorageRequirements(this.dimension, this.compressionType);
    }

    public static int getStorageRequirements(int n, int n2, Squish.CompressionType compressionType) {
        return Squish.getStorageRequirements(n, n2, compressionType);
    }

    public static int getStorageRequirements(Point point, Squish.CompressionType compressionType) {
        return Squish.getStorageRequirements(point.x, point.y, compressionType);
    }
}

