/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.compression;

import java.nio.ByteBuffer;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Squish;
import org.sf.feeling.swt.win32.extension.graphics.dds.util.ImageUtils;

public class DXTBufferDecompressor {
    protected ByteBuffer uncompressedBuffer;
    protected Squish.CompressionType compressionType;
    protected Point dimension;

    public DXTBufferDecompressor(ByteBuffer byteBuffer, int n, int n2, Squish.CompressionType compressionType) {
        this(byteBuffer, new Point(n, n2), compressionType);
    }

    public DXTBufferDecompressor(byte[] byArray, int n, int n2, Squish.CompressionType compressionType) {
        this(ByteBuffer.wrap(byArray), new Point(n, n2), compressionType);
    }

    public DXTBufferDecompressor(ByteBuffer byteBuffer, Point point, Squish.CompressionType compressionType) {
        this.uncompressedBuffer = DXTBufferDecompressor.squishDecompressBuffer(byteBuffer, point.x, point.y, compressionType);
        this.dimension = point;
        this.compressionType = compressionType;
    }

    public ImageData getImage() {
        try {
            ImageData imageData = ImageUtils.convertBGRAToRGBA(this.uncompressedBuffer.array(), this.dimension);
            return imageData;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] squishDecompressToArray(byte[] byArray, int n, int n2, Squish.CompressionType compressionType) throws OutOfMemoryError {
        if (compressionType != null) {
            byte[] byArray2 = Squish.decompressImage(null, n, n2, byArray, compressionType);
            return byArray2;
        }
        return byArray;
    }

    public static ByteBuffer squishDecompress(byte[] byArray, int n, int n2, Squish.CompressionType compressionType) throws OutOfMemoryError {
        return ByteBuffer.wrap(DXTBufferDecompressor.squishDecompressToArray(byArray, n, n2, compressionType));
    }

    private static ByteBuffer squishDecompressBuffer(ByteBuffer byteBuffer, int n, int n2, Squish.CompressionType compressionType) throws OutOfMemoryError {
        byte[] byArray = new byte[byteBuffer.capacity()];
        byteBuffer.get(byArray);
        return DXTBufferDecompressor.squishDecompress(byArray, n, n2, compressionType);
    }
}

