/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.ddsutil;

import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.sf.feeling.swt.win32.extension.graphics.dds.model.MipMaps;

public class MipMapsUtil {
    public static final int TOP_MOST_MIP_MAP = 0;

    protected static ImageData[] generateBIMipMaps(ImageData imageData, int n, int n2, boolean bl) {
        ImageData[] imageDataArray;
        if (bl && MipMapsUtil.isPowerOfTwo(imageData.width) && MipMapsUtil.isPowerOfTwo(imageData.height)) {
            int n3 = MipMapsUtil.calculateMaxNumberOfMipMaps(n, n2);
            imageDataArray = new ImageData[n3];
            imageDataArray = MipMaps.generateMipMaps(imageData, n, n2, imageDataArray);
        } else {
            imageDataArray = new ImageData[]{imageData};
        }
        return imageDataArray;
    }

    public static int calculateMaxNumberOfMipMaps(int n, int n2) {
        return (int)Math.floor(Math.log(Math.max(n, n2)) / Math.log(2.0)) + 1;
    }

    public static int calculateMaxNumberOfMipMaps(Point point) {
        int n = point.x;
        int n2 = point.y;
        return (int)Math.floor(Math.log(Math.max(n, n2)) / Math.log(2.0)) + 1;
    }

    public static boolean isPowerOfTwo(int n) {
        double d = Math.floor(Math.log(n) / Math.log(2.0));
        double d2 = Math.pow(2.0, d);
        return d2 == (double)n;
    }
}

