/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.jsquish;

import java.util.Arrays;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Vec;

final class ColourBlock {
    private static final int[] remapped = new int[16];
    private static final int[] indices = new int[16];
    private static final int[] codes = new int[16];

    private ColourBlock() {
    }

    static int gammaColour(float f, float f2) {
        return Math.round(f2 * f);
    }

    private static int floatTo565(Vec vec) {
        int n = Math.round(31.0f * vec.x());
        int n2 = Math.round(63.0f * vec.y());
        int n3 = Math.round(31.0f * vec.z());
        return n << 11 | n2 << 5 | n3;
    }

    private static void writeColourBlock(int n, int n2, int[] nArray, byte[] byArray, int n3) {
        byArray[n3 + 0] = (byte)(n & 0xFF);
        byArray[n3 + 1] = (byte)(n >> 8);
        byArray[n3 + 2] = (byte)(n2 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 >> 8);
        for (int i = 0; i < 4; ++i) {
            int n4 = 4 * i;
            byArray[n3 + 4 + i] = (byte)(nArray[n4 + 0] | nArray[n4 + 1] << 2 | nArray[n4 + 2] << 4 | nArray[n4 + 3] << 6);
        }
    }

    static void writeColourBlock3(Vec vec, Vec vec2, int[] nArray, byte[] byArray, int n) {
        int n2;
        int n3 = ColourBlock.floatTo565(vec);
        if (n3 <= (n2 = ColourBlock.floatTo565(vec2))) {
            System.arraycopy(nArray, 0, remapped, 0, 16);
        } else {
            int n4 = n3;
            n3 = n2;
            n2 = n4;
            for (int i = 0; i < 16; ++i) {
                ColourBlock.remapped[i] = nArray[i] == 0 ? 1 : (nArray[i] == 1 ? 0 : nArray[i]);
            }
        }
        ColourBlock.writeColourBlock(n3, n2, remapped, byArray, n);
    }

    static void writeColourBlock4(Vec vec, Vec vec2, int[] nArray, byte[] byArray, int n) {
        int n2;
        int n3 = ColourBlock.floatTo565(vec);
        if (n3 < (n2 = ColourBlock.floatTo565(vec2))) {
            int n4 = n3;
            n3 = n2;
            n2 = n4;
            for (int i = 0; i < 16; ++i) {
                ColourBlock.remapped[i] = (nArray[i] ^ 1) & 3;
            }
        } else if (n3 == n2) {
            Arrays.fill(remapped, 0);
        } else {
            System.arraycopy(nArray, 0, remapped, 0, 16);
        }
        ColourBlock.writeColourBlock(n3, n2, remapped, byArray, n);
    }

    static void decompressColour(byte[] byArray, byte[] byArray2, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int[] nArray = codes;
        int n5 = ColourBlock.unpack565(byArray2, n, nArray, 0);
        int n6 = ColourBlock.unpack565(byArray2, n + 2, nArray, 4);
        for (int i = 0; i < 3; ++i) {
            n4 = nArray[i];
            n3 = nArray[4 + i];
            if (bl && n5 <= n6) {
                nArray[8 + i] = (n4 + n3) / 2;
                nArray[12 + i] = 0;
                continue;
            }
            nArray[8 + i] = (2 * n4 + n3) / 3;
            nArray[12 + i] = (n4 + 2 * n3) / 3;
        }
        nArray[11] = 255;
        nArray[15] = bl && n5 <= n6 ? 0 : 255;
        int[] nArray2 = indices;
        for (n4 = 0; n4 < 4; ++n4) {
            n3 = 4 * n4;
            n2 = byArray2[n + 4 + n4] & 0xFF;
            nArray2[n3 + 0] = n2 & 3;
            nArray2[n3 + 1] = n2 >> 2 & 3;
            nArray2[n3 + 2] = n2 >> 4 & 3;
            nArray2[n3 + 3] = n2 >> 6 & 3;
        }
        for (n4 = 0; n4 < 16; ++n4) {
            n3 = 4 * nArray2[n4];
            for (n2 = 0; n2 < 4; ++n2) {
                byArray[4 * n4 + n2] = (byte)nArray[n3 + n2];
            }
        }
    }

    private static int unpack565(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = byArray[n + 0] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
        int n4 = n3 >> 11 & 0x1F;
        int n5 = n3 >> 5 & 0x3F;
        int n6 = n3 & 0x1F;
        nArray[n2 + 0] = n4 << 3 | n4 >> 2;
        nArray[n2 + 1] = n5 << 2 | n5 >> 4;
        nArray[n2 + 2] = n6 << 3 | n6 >> 2;
        nArray[n2 + 3] = 255;
        return n3;
    }
}

