/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.jsquish;

import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.ColourBlock;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.ColourSet;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.CompressorColourFit;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Matrix;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Squish;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Vec;

final class CompressorCluster
extends CompressorColourFit {
    private static final int MAX_ITERATIONS = 8;
    private static final float TWO_THIRDS = 0.6666667f;
    private static final float ONE_THIRD = 0.33333334f;
    private static final float HALF = 0.5f;
    private static final float ZERO = 0.0f;
    private static Vec principle;
    private static final float[] dps;
    private static final float[] weighted;
    private static final float[] weights;
    private static Squish.CompressionMetric metric;
    private static final int[] indices;
    private static final int[] bestIndices;
    private static final float[] alpha;
    private static final float[] beta;
    private static final int[] unordered;
    private static final Vec xxSum;
    private static float bestError;
    private static final int[] orders;

    CompressorCluster(ColourSet colourSet, Squish.CompressionType compressionType, Squish.CompressionMetric compressionMetric) {
        super(colourSet, compressionType);
        bestError = Float.MAX_VALUE;
        metric = compressionMetric;
        Matrix matrix = Matrix.computeWeightedCovariance(colourSet, CompressorColourFit.covariance);
        principle = Matrix.computePrincipleComponent(matrix);
    }

    void compress3(byte[] byArray, int n) {
        int n2;
        int n3 = this.colours.getCount();
        Vec vec = new Vec(0.0f);
        Vec vec2 = new Vec(0.0f);
        float f = bestError;
        Vec vec3 = new Vec();
        Vec vec4 = new Vec();
        this.constructOrdering(principle, 0);
        int[] nArray = indices;
        int[] nArray2 = bestIndices;
        float[] fArray = alpha;
        float[] fArray2 = beta;
        float[] fArray3 = weights;
        int n4 = 0;
        int n5 = 0;
        do {
            int n6;
            for (n6 = 0; n6 < n3; ++n6) {
                nArray[n6] = 0;
                fArray[n6] = fArray3[n6];
                fArray2[n6] = 0.0f;
            }
            for (n6 = n3; n6 >= 0; --n6) {
                for (n2 = n6; n2 < n3; ++n2) {
                    nArray[n2] = 2;
                    fArray[n2] = fArray2[n2] = 0.5f * fArray3[n2];
                }
                for (n2 = n3; n2 >= n6; --n2) {
                    float f2;
                    if (n2 < n3) {
                        nArray[n2] = 1;
                        fArray[n2] = 0.0f;
                        fArray2[n2] = fArray3[n2];
                    }
                    if (!((f2 = this.solveLeastSquares(vec3, vec4)) < f)) continue;
                    vec.set(vec3);
                    vec2.set(vec4);
                    System.arraycopy(nArray, 0, nArray2, 0, 16);
                    f = f2;
                    n4 = n5;
                }
            }
        } while (n4 == n5 && ++n5 != 8 && this.constructOrdering(vec3.set(vec2).sub(vec), n5));
        if (f < bestError) {
            int[] nArray3 = orders;
            int[] nArray4 = unordered;
            n2 = 16 * n4;
            for (int i = 0; i < n3; ++i) {
                nArray4[nArray3[n2 + i]] = nArray2[i];
            }
            this.colours.remapIndices(nArray4, nArray2);
            ColourBlock.writeColourBlock3(vec, vec2, nArray2, byArray, n);
            bestError = f;
        }
    }

    void compress4(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4 = this.colours.getCount();
        Vec vec = new Vec(0.0f);
        Vec vec2 = new Vec(0.0f);
        float f = bestError;
        Vec vec3 = new Vec();
        Vec vec4 = new Vec();
        this.constructOrdering(principle, 0);
        int[] nArray = indices;
        int[] nArray2 = bestIndices;
        float[] fArray = alpha;
        float[] fArray2 = beta;
        float[] fArray3 = weights;
        int n5 = 0;
        int n6 = 0;
        do {
            int n7;
            for (n7 = 0; n7 < n4; ++n7) {
                nArray[n7] = 0;
                fArray[n7] = fArray3[n7];
                fArray2[n7] = 0.0f;
            }
            for (n7 = n4; n7 >= 0; --n7) {
                for (n3 = n7; n3 < n4; ++n3) {
                    nArray[n3] = 2;
                    fArray[n3] = 0.6666667f * fArray3[n3];
                    fArray2[n3] = 0.33333334f * fArray3[n3];
                }
                for (n3 = n4; n3 >= n7; --n3) {
                    for (n2 = n3; n2 < n4; ++n2) {
                        nArray[n2] = 3;
                        fArray[n2] = 0.33333334f * fArray3[n2];
                        fArray2[n2] = 0.6666667f * fArray3[n2];
                    }
                    for (n2 = n4; n2 >= n3; --n2) {
                        float f2;
                        if (n2 < n4) {
                            nArray[n2] = 1;
                            fArray[n2] = 0.0f;
                            fArray2[n2] = fArray3[n2];
                        }
                        if (!((f2 = this.solveLeastSquares(vec3, vec4)) < f)) continue;
                        vec.set(vec3);
                        vec2.set(vec4);
                        System.arraycopy(nArray, 0, nArray2, 0, 16);
                        f = f2;
                        n5 = n6;
                    }
                }
            }
        } while (n5 == n6 && ++n6 != 8 && this.constructOrdering(vec3.set(vec2).sub(vec), n6));
        if (f < bestError) {
            int[] nArray3 = orders;
            int[] nArray4 = unordered;
            n3 = 16 * n5;
            for (n2 = 0; n2 < n4; ++n2) {
                nArray4[nArray3[n3 + n2]] = nArray2[n2];
            }
            this.colours.remapIndices(nArray4, nArray2);
            ColourBlock.writeColourBlock4(vec, vec2, nArray2, byArray, n);
            bestError = f;
        }
    }

    private boolean constructOrdering(Vec vec, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.colours.getCount();
        Vec[] vecArray = this.colours.getPoints();
        int[] nArray = orders;
        float[] fArray = dps;
        int n6 = 16 * n;
        for (n4 = 0; n4 < n5; ++n4) {
            fArray[n4] = vecArray[n4].dot(vec);
            nArray[n6 + n4] = n4;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = n4; n3 > 0 && fArray[n3] < fArray[n3 - 1]; --n3) {
                float f = fArray[n3];
                fArray[n3] = fArray[n3 - 1];
                fArray[n3 - 1] = f;
                n2 = nArray[n6 + n3];
                nArray[n6 + n3] = nArray[n6 + n3 - 1];
                nArray[n6 + n3 - 1] = n2;
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            n3 = 16 * n4;
            boolean bl = true;
            for (n2 = 0; n2 < n5; ++n2) {
                if (nArray[n6 + n2] == nArray[n3 + n2]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return false;
        }
        Vec[] vecArray2 = this.colours.getPoints();
        float[] fArray2 = this.colours.getWeights();
        xxSum.set(0.0f);
        float[] fArray3 = weighted;
        n2 = 0;
        int n7 = 0;
        while (n2 < n5) {
            int n8 = nArray[n6 + n2];
            float f = fArray2[n8];
            Vec vec2 = vecArray2[n8];
            CompressorCluster.weights[n2] = f;
            float f2 = f * vec2.x();
            float f3 = f * vec2.y();
            float f4 = f * vec2.z();
            xxSum.add(f2 * f2, f3 * f3, f4 * f4);
            fArray3[n7 + 0] = f2;
            fArray3[n7 + 1] = f3;
            fArray3[n7 + 2] = f4;
            ++n2;
            n7 += 3;
        }
        return true;
    }

    private float solveLeastSquares(Vec vec, Vec vec2) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        int n = this.colours.getCount();
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float[] fArray = alpha;
        float[] fArray2 = beta;
        float[] fArray3 = weighted;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            f7 = fArray[n2];
            f6 = fArray2[n2];
            f8 += f7 * f7;
            f9 += f6 * f6;
            f10 += f7 * f6;
            f11 += fArray3[n3 + 0] * f7;
            f12 += fArray3[n3 + 1] * f7;
            f13 += fArray3[n3 + 2] * f7;
            f14 += fArray3[n3 + 0] * f6;
            f15 += fArray3[n3 + 1] * f6;
            f16 += fArray3[n3 + 2] * f6;
            ++n2;
            n3 += 3;
        }
        if (f9 == 0.0f) {
            f5 = 1.0f / f8;
            f4 = f11 * f5;
            f3 = f12 * f5;
            f7 = f13 * f5;
            f2 = 0.0f;
            f = 0.0f;
            f6 = 0.0f;
        } else if (f8 == 0.0f) {
            f5 = 1.0f / f9;
            f7 = 0.0f;
            f3 = 0.0f;
            f4 = 0.0f;
            f6 = f14 * f5;
            f = f15 * f5;
            f2 = f16 * f5;
        } else {
            f5 = 1.0f / (f8 * f9 - f10 * f10);
            if (f5 == Float.POSITIVE_INFINITY) {
                return Float.MAX_VALUE;
            }
            f4 = (f11 * f9 - f14 * f10) * f5;
            f3 = (f12 * f9 - f15 * f10) * f5;
            f7 = (f13 * f9 - f16 * f10) * f5;
            f6 = (f14 * f8 - f11 * f10) * f5;
            f = (f15 * f8 - f12 * f10) * f5;
            f2 = (f16 * f8 - f13 * f10) * f5;
        }
        f4 = CompressorCluster.clamp(f4, 31.0f, 0.032258064f);
        f3 = CompressorCluster.clamp(f3, 63.0f, 0.015873017f);
        f7 = CompressorCluster.clamp(f7, 31.0f, 0.032258064f);
        vec.set(f4, f3, f7);
        f6 = CompressorCluster.clamp(f6, 31.0f, 0.032258064f);
        f = CompressorCluster.clamp(f, 63.0f, 0.015873017f);
        f2 = CompressorCluster.clamp(f2, 31.0f, 0.032258064f);
        vec2.set(f6, f, f2);
        f5 = f4 * f4 * f8 + f6 * f6 * f9 + xxSum.x() + 2.0f * (f4 * f6 * f10 - f4 * f11 - f6 * f14);
        float f17 = f3 * f3 * f8 + f * f * f9 + xxSum.y() + 2.0f * (f3 * f * f10 - f3 * f12 - f * f15);
        float f18 = f7 * f7 * f8 + f2 * f2 * f9 + xxSum.z() + 2.0f * (f7 * f2 * f10 - f7 * f13 - f2 * f16);
        return metric.dot(f5, f17, f18);
    }

    static {
        dps = new float[16];
        weighted = new float[48];
        weights = new float[16];
        indices = new int[16];
        bestIndices = new int[16];
        alpha = new float[16];
        beta = new float[16];
        unordered = new int[16];
        xxSum = new Vec();
        orders = new int[128];
    }
}

