/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.jsquish;

import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.ColourBlock;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.ColourSet;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.CompressorColourFit;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Matrix;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Squish;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Vec;

final class CompressorRange
extends CompressorColourFit {
    private static final int[] closest = new int[16];
    private static final int[] indices = new int[16];
    private static final Vec[] codes = new Vec[4];
    private final Squish.CompressionMetric metric;
    private final Vec start = new Vec();
    private final Vec end = new Vec();
    private float bestError;

    CompressorRange(ColourSet colourSet, Squish.CompressionType compressionType, Squish.CompressionMetric compressionMetric) {
        super(colourSet, compressionType);
        this.metric = compressionMetric;
        this.bestError = Float.MAX_VALUE;
        int n = this.colours.getCount();
        Vec[] vecArray = this.colours.getPoints();
        Matrix matrix = Matrix.computeWeightedCovariance(colourSet, CompressorColourFit.covariance);
        Vec vec = Matrix.computePrincipleComponent(matrix);
        if (n > 0) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5 = f4 = vecArray[0].x();
            float f6 = f3 = vecArray[0].y();
            float f7 = f2 = vecArray[0].z();
            float f8 = f = vecArray[0].dot(vec);
            for (int i = 1; i < n; ++i) {
                Vec vec2 = vecArray[i];
                float f9 = vec2.dot(vec);
                if (f9 < f8) {
                    f5 = vec2.x();
                    f6 = vec2.y();
                    f7 = vec2.z();
                    f8 = f9;
                    continue;
                }
                if (!(f9 > f)) continue;
                f4 = vec2.x();
                f3 = vec2.y();
                f2 = vec2.z();
                f = f9;
            }
            f5 = CompressorRange.clamp(f5, 31.0f, 0.032258064f);
            f6 = CompressorRange.clamp(f6, 63.0f, 0.015873017f);
            f7 = CompressorRange.clamp(f7, 31.0f, 0.032258064f);
            this.start.set(f5, f6, f7);
            f4 = CompressorRange.clamp(f4, 31.0f, 0.032258064f);
            f3 = CompressorRange.clamp(f3, 63.0f, 0.015873017f);
            f2 = CompressorRange.clamp(f2, 31.0f, 0.032258064f);
            this.end.set(f4, f3, f2);
        }
    }

    void compress3(byte[] byArray, int n) {
        int n2 = this.colours.getCount();
        Vec[] vecArray = this.colours.getPoints();
        Vec vec = new Vec();
        Vec[] vecArray2 = codes;
        vecArray2[0].set(this.start);
        vecArray2[1].set(this.end);
        vecArray2[2].set(this.start).add(this.end).mul(0.5f);
        int[] nArray = closest;
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            Vec vec2 = vecArray[i];
            float f2 = Float.MAX_VALUE;
            int n3 = 0;
            for (int j = 0; j < 3; ++j) {
                Vec vec3 = vecArray2[j];
                vec.set((vec2.x() - vec3.x()) * this.metric.r, (vec2.y() - vec3.y()) * this.metric.g, (vec2.z() - vec3.z()) * this.metric.b);
                float f3 = vec.lengthSQ();
                if (!(f3 < f2)) continue;
                f2 = f3;
                n3 = j;
            }
            nArray[i] = n3;
            f += f2;
        }
        if (f < this.bestError) {
            this.colours.remapIndices(nArray, indices);
            ColourBlock.writeColourBlock3(this.start, this.end, indices, byArray, n);
            this.bestError = f;
        }
    }

    void compress4(byte[] byArray, int n) {
        int n2 = this.colours.getCount();
        Vec[] vecArray = this.colours.getPoints();
        Vec vec = new Vec();
        Vec[] vecArray2 = codes;
        vecArray2[0].set(this.start);
        vecArray2[1].set(this.end);
        vecArray2[2].set(0.6666667f).mul(this.start).add(vec.set(0.33333334f).mul(this.end));
        vecArray2[3].set(0.33333334f).mul(this.start).add(vec.set(0.6666667f).mul(this.end));
        int[] nArray = closest;
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            Vec vec2 = vecArray[i];
            float f2 = Float.MAX_VALUE;
            int n3 = 0;
            for (int j = 0; j < 4; ++j) {
                Vec vec3 = vecArray2[j];
                vec.set((vec2.x() - vec3.x()) * this.metric.r, (vec2.y() - vec3.y()) * this.metric.g, (vec2.z() - vec3.z()) * this.metric.b);
                float f3 = vec.lengthSQ();
                if (!(f3 < f2)) continue;
                f2 = f3;
                n3 = j;
            }
            nArray[i] = n3;
            f += f2;
        }
        if (f < this.bestError) {
            this.colours.remapIndices(nArray, indices);
            ColourBlock.writeColourBlock4(this.start, this.end, indices, byArray, n);
            this.bestError = f;
        }
    }

    static {
        for (int i = 0; i < codes.length; ++i) {
            CompressorRange.codes[i] = new Vec();
        }
    }
}

