/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.jsquish;

import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.ColourBlock;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.ColourSet;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.CompressorColourFit;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.SingleColourLookup3;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.SingleColourLookup4;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Squish;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Vec;

final class CompressorSingleColour
extends CompressorColourFit {
    private static final int[] indices = new int[16];
    private static final int[][][][] lookups = new int[3][][][];
    private static int[][] sources = new int[3][];
    private static final Vec start = new Vec();
    private static final Vec end = new Vec();
    private static int[] index = new int[1];
    private static int bestError;
    private int[] colour = new int[3];

    CompressorSingleColour(ColourSet colourSet, Squish.CompressionType compressionType) {
        super(colourSet, compressionType);
        Vec vec = colourSet.getPoints()[0];
        this.colour[0] = Math.round(255.0f * vec.x());
        this.colour[1] = Math.round(255.0f * vec.y());
        this.colour[2] = Math.round(255.0f * vec.z());
        bestError = Integer.MAX_VALUE;
    }

    void compress3(byte[] byArray, int n) {
        CompressorSingleColour.lookups[0] = SingleColourLookup3.LOOKUP_5_3;
        CompressorSingleColour.lookups[1] = SingleColourLookup3.LOOKUP_6_3;
        CompressorSingleColour.lookups[2] = SingleColourLookup3.LOOKUP_5_3;
        int n2 = this.computeEndPoints(3, lookups);
        if (n2 < bestError) {
            this.colours.remapIndices(index, indices);
            ColourBlock.writeColourBlock3(start, end, indices, byArray, n);
            bestError = n2;
        }
    }

    void compress4(byte[] byArray, int n) {
        CompressorSingleColour.lookups[0] = SingleColourLookup4.LOOKUP_5_4;
        CompressorSingleColour.lookups[1] = SingleColourLookup4.LOOKUP_6_4;
        CompressorSingleColour.lookups[2] = SingleColourLookup4.LOOKUP_5_4;
        int n2 = this.computeEndPoints(4, lookups);
        if (n2 < bestError) {
            this.colours.remapIndices(index, indices);
            ColourBlock.writeColourBlock4(start, end, indices, byArray, n);
            bestError = n2;
        }
    }

    private int computeEndPoints(int n, int[][][][] nArray) {
        int[][] nArray2 = sources;
        int n2 = bestError;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            for (int j = 0; j < 3; ++j) {
                int[][][] nArray3 = nArray[j];
                int n4 = this.colour[j];
                nArray2[j] = nArray3[n4][i];
                int n5 = nArray2[j][2];
                n3 += n5 * n5;
            }
            if (n3 >= n2) continue;
            start.set((float)nArray2[0][0] * 0.032258064f, (float)nArray2[1][0] * 0.015873017f, (float)nArray2[2][0] * 0.032258064f);
            end.set((float)nArray2[0][1] * 0.032258064f, (float)nArray2[1][1] * 0.015873017f, (float)nArray2[2][1] * 0.032258064f);
            CompressorSingleColour.index[0] = i;
            n2 = n3;
        }
        return n2;
    }
}

