/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.jsquish;

import java.nio.ByteBuffer;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.ColourBlock;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.ColourSet;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.CompressorAlpha;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.CompressorCluster;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.CompressorColourFit;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.CompressorRange;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.CompressorSingleColour;

public final class Squish {
    private static final ColourSet colours = new ColourSet();

    private Squish() {
    }

    public static int getStorageRequirements(int n, int n2, CompressionType compressionType) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Invalid image dimensions specified: " + n + " x " + n2);
        }
        int n3 = (n + 3) / 4 * ((n2 + 3) / 4);
        return n3 * compressionType.blockSize;
    }

    public static byte[] compressImage(byte[] byArray, int n, int n2, byte[] byArray2, CompressionType compressionType) {
        return Squish.compressImage(byArray, n, n2, byArray2, compressionType, CompressionMethod.CLUSTER_FIT, CompressionMetric.PERCEPTUAL, false);
    }

    public static byte[] compressImage(int[] nArray, int n, int n2, byte[] byArray, CompressionType compressionType) {
        return Squish.compressImage(nArray, n, n2, byArray, compressionType, CompressionMethod.CLUSTER_FIT, CompressionMetric.PERCEPTUAL, false);
    }

    public static byte[] compressImage(ByteBuffer byteBuffer, int n, int n2, byte[] byArray, CompressionType compressionType) {
        return Squish.compressImage(byteBuffer, n, n2, byArray, compressionType, CompressionMethod.CLUSTER_FIT, CompressionMetric.PERCEPTUAL, false);
    }

    public static byte[] compressImage(byte[] byArray, int n, int n2, byte[] byArray2, CompressionType compressionType, CompressionMethod compressionMethod) {
        return Squish.compressImage(byArray, n, n2, byArray2, compressionType, compressionMethod, CompressionMetric.PERCEPTUAL, false);
    }

    public static byte[] compressImage(int[] nArray, int n, int n2, byte[] byArray, CompressionType compressionType, CompressionMethod compressionMethod) {
        return Squish.compressImage(nArray, n, n2, byArray, compressionType, compressionMethod, CompressionMetric.PERCEPTUAL, false);
    }

    public static byte[] compressImage(ByteBuffer byteBuffer, int n, int n2, byte[] byArray, CompressionType compressionType, CompressionMethod compressionMethod) {
        return Squish.compressImage(byteBuffer, n, n2, byArray, compressionType, compressionMethod, CompressionMetric.PERCEPTUAL, false);
    }

    public static byte[] compressImage(byte[] byArray, int n, int n2, byte[] byArray2, CompressionType compressionType, CompressionMethod compressionMethod, CompressionMetric compressionMetric, boolean bl) {
        byArray2 = Squish.checkCompressInput(byArray, n, n2, byArray2, compressionType);
        byte[] byArray3 = new byte[64];
        int n3 = 0;
        for (int i = 0; i < n2; i += 4) {
            for (int j = 0; j < n; j += 4) {
                int n4 = 0;
                int n5 = 0;
                for (int k = 0; k < 4; ++k) {
                    int n6 = i + k;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        int n7 = j + i2;
                        if (n7 < n && n6 < n2) {
                            int n8 = 4 * (n * n6 + n7);
                            for (int i3 = 0; i3 < 4; ++i3) {
                                byArray3[n4++] = byArray[n8++];
                            }
                            n5 |= 1 << 4 * k + i2;
                            continue;
                        }
                        n4 += 4;
                    }
                }
                Squish.compress(byArray3, n5, byArray2, n3, compressionType, compressionMethod, compressionMetric, bl);
                n3 += compressionType.blockSize;
            }
        }
        return byArray2;
    }

    public static byte[] compressImage(int[] nArray, int n, int n2, byte[] byArray, CompressionType compressionType, CompressionMethod compressionMethod, CompressionMetric compressionMetric, boolean bl) {
        byArray = Squish.checkCompressInput(nArray, n, n2, byArray, compressionType);
        byte[] byArray2 = new byte[64];
        int n3 = 0;
        for (int i = 0; i < n2; i += 4) {
            for (int j = 0; j < n; j += 4) {
                int n4 = 0;
                int n5 = 0;
                for (int k = 0; k < 4; ++k) {
                    int n6 = i + k;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        int n7 = j + i2;
                        if (n7 < n && n6 < n2) {
                            for (int i3 = 0; i3 < 4; ++i3) {
                                byArray2[n4++] = (byte)((nArray[i3] & 0xFF000000) >> 24);
                                byArray2[n4++] = (byte)(nArray[i3] & 0xFF);
                                byArray2[n4++] = (byte)((nArray[i3] & 0xFF00) >> 8);
                                byArray2[n4++] = (byte)((nArray[i3] & 0xFF0000) >> 16);
                            }
                            n5 |= 1 << 4 * k + i2;
                            continue;
                        }
                        n4 += 4;
                    }
                }
                Squish.compress(byArray2, n5, byArray, n3, compressionType, compressionMethod, compressionMetric, bl);
                n3 += compressionType.blockSize;
            }
        }
        return byArray;
    }

    public static byte[] compressImage(ByteBuffer byteBuffer, int n, int n2, byte[] byArray, CompressionType compressionType, CompressionMethod compressionMethod, CompressionMetric compressionMetric, boolean bl) {
        byArray = Squish.checkCompressInput(byteBuffer, n, n2, byArray, compressionType);
        byte[] byArray2 = new byte[64];
        int n3 = 0;
        for (int i = 0; i < n2; i += 4) {
            for (int j = 0; j < n; j += 4) {
                int n4 = 0;
                int n5 = 0;
                for (int k = 0; k < 4; ++k) {
                    int n6 = i + k;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        int n7 = j + i2;
                        if (n7 < n && n6 < n2) {
                            for (int i3 = 0; i3 < 4; ++i3) {
                                byArray2[n4++] = byteBuffer.get();
                            }
                            n5 |= 1 << 4 * k + i2;
                            continue;
                        }
                        n4 += 4;
                    }
                }
                Squish.compress(byArray2, n5, byArray, n3, compressionType, compressionMethod, compressionMetric, bl);
                n3 += compressionType.blockSize;
            }
        }
        return byArray;
    }

    private static byte[] checkCompressInput(int[] nArray, int n, int n2, byte[] byArray, CompressionType compressionType) {
        return Squish.checkStorageSize(n, n2, byArray, compressionType, nArray.length, nArray == null);
    }

    private static byte[] checkCompressInput(ByteBuffer byteBuffer, int n, int n2, byte[] byArray, CompressionType compressionType) {
        return Squish.checkStorageSize(n, n2, byArray, compressionType, byteBuffer.capacity(), byteBuffer == null);
    }

    private static byte[] checkCompressInput(byte[] byArray, int n, int n2, byte[] byArray2, CompressionType compressionType) {
        return Squish.checkStorageSize(n, n2, byArray2, compressionType, byArray.length, byArray == null);
    }

    private static byte[] checkStorageSize(int n, int n2, byte[] byArray, CompressionType compressionType, int n3, boolean bl) {
        if (bl || n3 < n * n2 * 4) {
            throw new IllegalArgumentException("Invalid source image data specified.");
        }
        int n4 = Squish.getStorageRequirements(n, n2, compressionType);
        if (byArray == null || byArray.length < n4) {
            byArray = new byte[n4];
        }
        return byArray;
    }

    private static void compress(byte[] byArray, int n, byte[] byArray2, int n2, CompressionType compressionType, CompressionMethod compressionMethod, CompressionMetric compressionMetric, boolean bl) {
        int n3 = n2 + compressionType.blockOffset;
        int n4 = n2;
        colours.init(byArray, n, compressionType, bl);
        CompressorColourFit compressorColourFit = colours.getCount() == 1 ? new CompressorSingleColour(colours, compressionType) : compressionMethod.getCompressor(colours, compressionType, compressionMetric);
        compressorColourFit.compress(byArray2, n3);
        if (compressionType == CompressionType.DXT3) {
            CompressorAlpha.compressAlphaDxt3(byArray, n, byArray2, n4);
        } else if (compressionType == CompressionType.DXT5) {
            CompressorAlpha.compressAlphaDxt5(byArray, n, byArray2, n4);
        }
    }

    public static byte[] decompressImage(byte[] byArray, int n, int n2, byte[] byArray2, CompressionType compressionType) {
        byArray = Squish.checkDecompressInput(byArray, n, n2, byArray2, compressionType);
        byte[] byArray3 = new byte[64];
        int n3 = 0;
        for (int i = 0; i < n2; i += 4) {
            for (int j = 0; j < n; j += 4) {
                Squish.decompress(byArray3, byArray2, n3, compressionType);
                int n4 = 0;
                for (int k = 0; k < 4; ++k) {
                    for (int i2 = 0; i2 < 4; ++i2) {
                        int n5 = j + i2;
                        int n6 = i + k;
                        if (n5 < n && n6 < n2) {
                            int n7 = 4 * (n * n6 + n5);
                            for (int i3 = 0; i3 < 4; ++i3) {
                                byArray[n7++] = byArray3[n4++];
                            }
                            continue;
                        }
                        n4 += 4;
                    }
                }
                n3 += compressionType.blockSize;
            }
        }
        return byArray;
    }

    private static byte[] checkDecompressInput(byte[] byArray, int n, int n2, byte[] byArray2, CompressionType compressionType) {
        int n3 = Squish.getStorageRequirements(n, n2, compressionType);
        if (byArray2 == null || byArray2.length < n3) {
            throw new IllegalArgumentException("Invalid source image data specified.");
        }
        if (byArray == null || byArray.length < n * n2 * 4) {
            byArray = new byte[n * n2 * 4];
        }
        return byArray;
    }

    private static void decompress(byte[] byArray, byte[] byArray2, int n, CompressionType compressionType) {
        int n2 = n + compressionType.blockOffset;
        int n3 = n;
        ColourBlock.decompressColour(byArray, byArray2, n2, compressionType == CompressionType.DXT1);
        if (compressionType == CompressionType.DXT3) {
            CompressorAlpha.decompressAlphaDxt3(byArray, byArray2, n3);
        } else if (compressionType == CompressionType.DXT5) {
            CompressorAlpha.decompressAlphaDxt5(byArray, byArray2, n3);
        }
    }

    public static abstract class CompressionMethod {
        public static final CompressionMethod CLUSTER_FIT = new CompressionMethod(){

            CompressorColourFit getCompressor(ColourSet colourSet, CompressionType compressionType, CompressionMetric compressionMetric) {
                return new CompressorCluster(colourSet, compressionType, compressionMetric);
            }
        };
        public static final CompressionMethod RANGE_FIT = new CompressionMethod(){

            CompressorColourFit getCompressor(ColourSet colourSet, CompressionType compressionType, CompressionMetric compressionMetric) {
                return new CompressorRange(colourSet, compressionType, compressionMetric);
            }
        };

        abstract CompressorColourFit getCompressor(ColourSet var1, CompressionType var2, CompressionMetric var3);
    }

    public static class CompressionMetric {
        public static final CompressionMetric PERCEPTUAL = new CompressionMetric(0.2126f, 0.7152f, 0.0722f);
        public static final CompressionMetric UNIFORM = new CompressionMetric(1.0f, 1.0f, 1.0f);
        public final float r;
        public final float g;
        public final float b;

        public CompressionMetric(float f, float f2, float f3) {
            this.r = f;
            this.g = f2;
            this.b = f3;
        }

        public float dot(float f, float f2, float f3) {
            return this.r * f + this.g * f2 + this.b * f3;
        }
    }

    public static class CompressionType {
        public static final CompressionType DXT1 = new CompressionType(8);
        public static final CompressionType DXT3 = new CompressionType(16);
        public static final CompressionType DXT5 = new CompressionType(16);
        public final int blockSize;
        public final int blockOffset;

        public CompressionType(int n) {
            this.blockSize = n;
            this.blockOffset = n - 8;
        }
    }
}

