/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.nio.ByteBuffer;
import org.sf.feeling.swt.win32.extension.graphics.dds.ddsutil.DDSUtil;
import org.sf.feeling.swt.win32.extension.graphics.dds.jogl.DDSImage;

public class DDSFile {
    public static final int TOP_MOST_MIP_MAP = 0;
    protected int height;
    protected int width;
    protected int pixelformat;
    protected File file = null;
    private int depth;
    protected int numMipMaps;
    protected boolean hasMipMaps;
    protected TextureType textureType;

    protected DDSFile() {
    }

    public DDSFile(String string) {
        this(new File(string));
    }

    public DDSFile(File file) {
        this.file = file;
        DDSImage dDSImage = null;
        try {
            dDSImage = DDSImage.read(file);
            this.initDdsValues(dDSImage);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public DDSFile(File file, DDSImage dDSImage) {
        this.file = file;
        this.initDdsValues(dDSImage);
    }

    public DDSFile(String string, DDSImage dDSImage) throws InvalidObjectException {
        this(new File(string), dDSImage);
    }

    protected void initDdsValues(DDSImage dDSImage) {
        this.height = dDSImage.getHeight();
        this.width = dDSImage.getWidth();
        this.depth = dDSImage.getDepth();
        this.pixelformat = dDSImage.getFormatType();
        this.textureType = DDSFile.getTextureType(dDSImage);
        this.numMipMaps = dDSImage.getNumMipMaps();
        this.hasMipMaps = dDSImage.getNumMipMaps() > 1;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getPixelformat() {
        return this.pixelformat;
    }

    public void setPixelformat(int n) {
        this.pixelformat = n;
    }

    public void setPixelformat(PixelFormat pixelFormat) {
        this.setPixelformat(pixelFormat.getFormatType());
    }

    public String getPixelformatVerbose() {
        return DDSFile.verbosePixelformat(this.pixelformat);
    }

    public boolean isCompressed() {
        return DDSUtil.isDXTCompressed(this.pixelformat);
    }

    public int getDepth() {
        return this.depth;
    }

    public int getChannelDepth() {
        switch (this.pixelformat) {
            case 21: 
            case 22: 
            case 844388420: 
            case 861165636: 
            case 877942852: 
            case 894720068: {
                return this.depth / 4;
            }
            case 20: 
            case 827611204: {
                return this.depth / 3;
            }
        }
        return 0;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public String getFileName() {
        return this.file.getName();
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getAbsolutePath() + DDSFile.verbosePixelformat(this.pixelformat);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DDSFile) {
            DDSFile dDSFile = (DDSFile)object;
            boolean bl = this.getFile().getAbsoluteFile().equals(dDSFile.getFile().getAbsoluteFile()) && this.hasMipMaps() == dDSFile.hasMipMaps() && this.getPixelformat() == dDSFile.getPixelformat() && this.getHeight() == dDSFile.getHeight() && this.getWidth() == dDSFile.getWidth();
            return bl;
        }
        return false;
    }

    public boolean hasMipMaps() {
        return this.hasMipMaps;
    }

    public int getNumMipMaps() {
        return this.numMipMaps;
    }

    public TextureType getTextureType() {
        return this.textureType;
    }

    public static TextureType getTextureType(DDSImage dDSImage) {
        if (dDSImage.isCubemap()) {
            return TextureType.CUBEMAP;
        }
        if (dDSImage.isVolume()) {
            return TextureType.VOLUME;
        }
        return TextureType.TEXTURE;
    }

    public static String verbosePixelformat(int n) {
        switch (n) {
            default: {
                return PixelFormat.Unknown.toString();
            }
            case 21: {
                return PixelFormat.Unknown.toString();
            }
            case 827611204: {
                return PixelFormat.DXT1.toString();
            }
            case 844388420: {
                return PixelFormat.DXT2.toString();
            }
            case 861165636: {
                return PixelFormat.DXT3.toString();
            }
            case 877942852: {
                return PixelFormat.DXT4.toString();
            }
            case 894720068: {
                return PixelFormat.DXT5.toString();
            }
            case 20: {
                return PixelFormat.R8G8B8.toString();
            }
            case 22: 
        }
        return PixelFormat.X8R8G8B8.toString();
    }

    public static int verbosePixelformat(String string) {
        if (string.equals(PixelFormat.DXT1.toString())) {
            return 827611204;
        }
        if (string.equals(PixelFormat.DXT2.toString())) {
            return 844388420;
        }
        if (string.equals(PixelFormat.DXT3.toString())) {
            return 861165636;
        }
        if (string.equals(PixelFormat.DXT4.toString())) {
            return 877942852;
        }
        if (string.equals(PixelFormat.DXT5.toString())) {
            return 894720068;
        }
        if (string == PixelFormat.R8G8B8.toString()) {
            return 20;
        }
        if (string.equals(PixelFormat.X8R8G8B8.toString())) {
            return 22;
        }
        if (string.equals(PixelFormat.A8R8G8B8.toString())) {
            return 21;
        }
        return 0;
    }

    public void write() throws IOException {
        this.write(this.file);
    }

    public void write(String string) throws IOException {
        this.write(new File(string));
    }

    public void write(File file) throws IOException {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.numMipMaps];
        for (int i = 0; i < byteBufferArray.length; ++i) {
            byteBufferArray[i] = DDSImage.read(this.file).getMipMap(i).getData();
        }
        DDSImage dDSImage = DDSImage.createFromData(this.pixelformat, this.width, this.height, byteBufferArray);
        dDSImage.write(file);
        dDSImage.close();
    }

    public static boolean isValidDDSImage(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        boolean bl = DDSImage.isDDSImage(fileInputStream);
        fileInputStream.close();
        return bl;
    }

    public static class PixelFormat {
        private int formatType;
        public static final int DXT5_TYPE = 894720068;
        public static final int DXT4_TYPE = 877942852;
        public static final int DXT3_TYPE = 861165636;
        public static final int DXT2_TYPE = 844388420;
        public static final int DXT1_TYPE = 827611204;
        public static final int A8R8G8B8_TYPE = 21;
        public static final int X8R8G8B8_TYPE = 22;
        public static final int R8G8B8_TYPE = 20;
        public static final int UNKNOWN_TYPE = 0;
        public static final PixelFormat DXT5 = new PixelFormat(894720068);
        public static final PixelFormat DXT4 = new PixelFormat(877942852);
        public static final PixelFormat DXT3 = new PixelFormat(861165636);
        public static final PixelFormat DXT2 = new PixelFormat(844388420);
        public static final PixelFormat DXT1 = new PixelFormat(827611204);
        public static final PixelFormat A8R8G8B8 = new PixelFormat(21);
        public static final PixelFormat X8R8G8B8 = new PixelFormat(22);
        public static final PixelFormat R8G8B8 = new PixelFormat(20);
        public static final PixelFormat Unknown = new PixelFormat(0);

        public int getFormatType() {
            return this.formatType;
        }

        public PixelFormat(int n) {
            this.formatType = n;
        }

        public static PixelFormat valueOf(int n) {
            switch (n) {
                case 894720068: {
                    return DXT5;
                }
                case 877942852: {
                    return DXT4;
                }
                case 861165636: {
                    return DXT3;
                }
                case 844388420: {
                    return DXT2;
                }
                case 827611204: {
                    return DXT1;
                }
                case 21: {
                    return A8R8G8B8;
                }
                case 22: {
                    return X8R8G8B8;
                }
                case 20: {
                    return R8G8B8;
                }
            }
            return Unknown;
        }
    }

    public static class TextureType {
        private int type;
        public static final TextureType TEXTURE = new TextureType(0);
        public static final TextureType CUBEMAP = new TextureType(1);
        public static final TextureType VOLUME = new TextureType(2);

        public int getType() {
            return this.type;
        }

        public TextureType(int n) {
            this.type = n;
        }
    }
}

