/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.model;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.sf.feeling.swt.win32.extension.graphics.dds.ddsutil.MipMapsUtil;
import org.sf.feeling.swt.win32.extension.graphics.dds.ddsutil.NonCubicDimensionException;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Squish;
import org.sf.feeling.swt.win32.extension.graphics.dds.model.AbstractTextureMap;
import org.sf.feeling.swt.win32.extension.graphics.dds.model.DDSImageFile;
import org.sf.feeling.swt.win32.extension.graphics.dds.util.ImageUtils;

public class MipMaps
extends AbstractTextureMap {
    public static final int TOP_MOST_MIP_MAP = 0;
    Vector mipmaps = new Vector();
    private int numMipMaps;

    public void generateMipMaps(ImageData imageData) {
        this.mipmaps.add(imageData);
        if (!DDSImageFile.isPowerOfTwo(imageData.width) && !DDSImageFile.isPowerOfTwo(imageData.height)) {
            throw new NonCubicDimensionException();
        }
        this.mipmaps = this.generateMipMapArray(this.mipmaps);
    }

    private Vector generateMipMapArray(Vector vector) {
        ImageData imageData = (ImageData)vector.get(0);
        int n = imageData.width;
        int n2 = imageData.height;
        this.numMipMaps = MipMapsUtil.calculateMaxNumberOfMipMaps(n, n2);
        ImageData imageData2 = imageData;
        for (int i = 1; i < this.numMipMaps; ++i) {
            n = MipMaps.calculateMipMapSize(n);
            n2 = MipMaps.calculateMipMapSize(n2);
            ImageData imageData3 = imageData2.scaledTo(n, n2);
            vector.add(imageData3);
            imageData2 = imageData3;
        }
        return vector;
    }

    public ImageData getTopMostMipMap() {
        return this.getMipMap(0);
    }

    public int getNumMipMaps() {
        return this.numMipMaps;
    }

    public int getHeight() {
        return this.getMipMap((int)0).height;
    }

    public int getWidth() {
        return this.getMipMap((int)0).width;
    }

    public ImageData getMipMap(int n) {
        return (ImageData)this.mipmaps.get(n);
    }

    public ByteBuffer[] getDXTCompressedBuffer(Squish.CompressionType compressionType) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.numMipMaps];
        for (int i = 0; i < this.numMipMaps; ++i) {
            byteBufferArray[i] = this.compress(this.getMipMap(i), compressionType);
        }
        return byteBufferArray;
    }

    public Vector getAllMipMaps() {
        return this.mipmaps;
    }

    public ImageData[] getAllMipMapsArray() {
        return this.mipmaps.toArray(new ImageData[0]);
    }

    public ByteBuffer[] getUncompressedBuffer() {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.numMipMaps];
        for (int i = 0; i < this.numMipMaps; ++i) {
            byteBufferArray[i] = ByteBuffer.wrap(ImageUtils.convertRGBAToBGRA(this.getMipMap(i)));
        }
        return byteBufferArray;
    }

    public static ImageData[] generateMipMaps(ImageData imageData, int n, int n2, ImageData[] imageDataArray) {
        int n3 = 0;
        while (true) {
            imageDataArray[n3] = imageDataArray[n3].scaledTo(n, n2);
            if (n == 1 || n2 == 1) break;
            ++n3;
            n = MipMaps.calculateMipMapSize(n);
            n2 = MipMaps.calculateMipMapSize(n2);
        }
        return imageDataArray;
    }

    public Iterator iterator() {
        return new Iterator(){
            int count = 0;

            public boolean hasNext() {
                boolean bl = this.count++ < MipMaps.this.mipmaps.size() - 1;
                return bl;
            }

            public Object next() {
                return MipMaps.this.mipmaps.get(this.count);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int calculateMipMapSize(int n) {
        return n > 1 ? n / 2 : 1;
    }

    public static int getMipMapSizeAtIndex(int n, int n2) {
        int n3 = n2;
        for (int i = 0; i < n; ++i) {
            n3 = MipMaps.calculateMipMapSize(n3);
        }
        return n3;
    }

    public int getMipMapWidth(int n) {
        return this.getMipMap((int)n).width;
    }

    public int getMipMapHeight(int n) {
        return this.getMipMap((int)n).height;
    }

    public Point getMipMapDimension(int n) {
        return new Point(this.getMipMapWidth(n), this.getMipMapHeight(n));
    }
}

