/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.hook;

import java.util.ArrayList;
import java.util.List;
import org.sf.feeling.swt.win32.extension.hook.data.HookData;
import org.sf.feeling.swt.win32.extension.hook.listener.HookEventListener;
import org.sf.feeling.swt.win32.extension.util.SortMap;
import org.sf.feeling.swt.win32.internal.extension.EventObject;
import org.sf.feeling.swt.win32.internal.extension.Extension;

public class Hook {
    private final SortMap listeners = new SortMap();
    private Descriptor descriptor;
    public static final Hook KEYBOARD = new Hook(Descriptor.KEYBOARD);
    public static final Hook GETMESSAGE = new Hook(Descriptor.GETMESSAGE);
    public static final Hook CALLWNDPROC = new Hook(Descriptor.CALLWNDPROC);
    public static final Hook SYSMSGFILTER = new Hook(Descriptor.SYSMSGFILTER);
    public static final Hook MOUSE = new Hook(Descriptor.MOUSE);
    public static final Hook SHELL = new Hook(Descriptor.SHELL);
    public static final Hook FOREGROUNDIDLE = new Hook(Descriptor.FOREGROUNDIDLE);
    public static final Hook CALLWNDPROCRET = new Hook(Descriptor.CALLWNDPROCRET);
    private Thread eventsThread = null;
    private HookEventLoop eventLoop = null;
    private boolean installed = false;
    private List refList = new ArrayList();
    int threadId = Extension.GetCurrentThreadId();

    private Hook(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public synchronized boolean isInstalled(Object object) {
        if (!this.installed) {
            return false;
        }
        return this.refList.contains(object);
    }

    public synchronized void install(Object object) {
        if (this.isInstalled(object)) {
            throw new IllegalStateException("Hook is already installed.");
        }
        if (!this.installed) {
            this.eventLoop = new HookEventLoop();
            this.eventsThread = new Thread(this.eventLoop);
            this.eventsThread.start();
        }
        this.refList.add(object);
    }

    public synchronized void install(Object object, boolean bl) {
        if (this.isInstalled(object)) {
            throw new IllegalStateException("Hook is already installed.");
        }
        if (!this.installed) {
            this.eventLoop = new HookEventLoop(bl);
            this.eventsThread = new Thread(this.eventLoop);
            this.eventsThread.start();
        }
        this.refList.add(object);
    }

    public synchronized void uninstall(Object object) {
        if (!this.isInstalled(object)) {
            throw new IllegalStateException("Hook is not installed.");
        }
        this.refList.remove(object);
        if (this.refList.size() == 0) {
            this.eventLoop.uninstall();
            try {
                this.eventsThread.join();
                this.eventsThread = null;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Object object, HookEventListener hookEventListener) {
        SortMap sortMap = this.listeners;
        synchronized (sortMap) {
            if (this.listeners.containsKey(object)) {
                List list = (List)this.listeners.get(object);
                list.add(hookEventListener);
            } else {
                ArrayList<HookEventListener> arrayList = new ArrayList<HookEventListener>();
                arrayList.add(hookEventListener);
                this.listeners.put(object, arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object object, HookEventListener hookEventListener) {
        SortMap sortMap = this.listeners;
        synchronized (sortMap) {
            if (this.listeners.containsKey(object)) {
                List list = (List)this.listeners.get(object);
                list.remove(hookEventListener);
                if (list.size() == 0) {
                    this.listeners.remove(object);
                }
            }
        }
    }

    public static class Descriptor {
        public static final Descriptor KEYBOARD = new Descriptor(2, "KEYBOARD");
        public static final Descriptor GETMESSAGE = new Descriptor(3, "GETMESSAGE");
        public static final Descriptor CALLWNDPROC = new Descriptor(4, "CALLWNDPROC");
        public static final Descriptor CBT = new Descriptor(5, "CBT");
        public static final Descriptor SYSMSGFILTER = new Descriptor(6, "SYSMSGFILTER", true);
        public static final Descriptor MOUSE = new Descriptor(7, "MOUSE");
        public static final Descriptor DEBUG = new Descriptor(9, "DEBUG");
        public static final Descriptor SHELL = new Descriptor(10, "SHELL");
        public static final Descriptor FOREGROUNDIDLE = new Descriptor(11, "FOREGROUNDIDLE");
        public static final Descriptor CALLWNDPROCRET = new Descriptor(12, "CALLWNDPROCRET");
        private boolean globalOnly;
        private String name = null;
        private int value;

        private Descriptor(int n, String string) {
            this.value = n;
            this.name = string;
        }

        private Descriptor(int n, String string, boolean bl) {
            this.value = n;
            this.name = string;
            this.globalOnly = bl;
        }

        public boolean isGlobalOnly() {
            return this.globalOnly;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }
    }

    private class HookEventLoop
    implements Runnable {
        private EventObject eventObject;
        private boolean messageThreadAlive = false;
        private boolean global = true;

        public HookEventLoop(boolean bl) {
            this.global = bl;
        }

        public HookEventLoop() {
        }

        private void installHook() {
            if (!this.global && Hook.this.descriptor.isGlobalOnly()) {
                throw new UnsupportedOperationException("The " + Hook.this.descriptor.getName() + " hook doesn't support thread hook.");
            }
            if (Extension.InstallSystemHook(Hook.this.descriptor.getValue(), this.global ? 0 : Hook.this.threadId)) {
                Hook.this.installed = true;
            }
        }

        private void unInstallHook() {
            if (Extension.UnInstallSystemHook(Hook.this.descriptor.getValue())) {
                Hook.this.installed = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners(HookData hookData) {
            SortMap sortMap = Hook.this.listeners;
            synchronized (sortMap) {
                for (int i = 0; i < Hook.this.listeners.size() && this.messageThreadAlive; ++i) {
                    List list = (List)Hook.this.listeners.get(i);
                    if (list == null) continue;
                    for (int j = 0; j < list.size(); ++j) {
                        ((HookEventListener)list.get(j)).acceptHookData(hookData);
                    }
                }
            }
        }

        public void run() {
            this.messageThreadAlive = true;
            this.eventObject = new EventObject(Hook.this.descriptor.getName() + System.currentTimeMillis());
            this.eventObject.reset();
            Hook.this.eventLoop.installHook();
            while (this.messageThreadAlive) {
                this.eventObject.waitFor();
                if (!this.messageThreadAlive) continue;
                HookData hookData = (HookData)Extension.ReadHookData(Hook.this.descriptor.getValue());
                this.notifyListeners(hookData);
                this.eventObject.reset();
            }
            this.unInstallHook();
            this.eventObject.reset();
            this.eventObject.close();
            Hook.this.installed = false;
        }

        private void uninstall() {
            this.messageThreadAlive = false;
            if (this.eventObject != null) {
                this.eventObject.notifyEvent();
            }
        }
    }
}

