/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.io;

import java.io.File;
import org.sf.feeling.swt.win32.extension.jna.win32.Kernel32;
import org.sf.feeling.swt.win32.internal.extension.DISKFREESPACE;
import org.sf.feeling.swt.win32.internal.extension.Extension;

public class FileSystem {
    public static final int DRIVE_TYPE_CDROM = 5;
    public static final int DRIVE_TYPE_FIXED = 3;
    public static final int DRIVE_TYPE_NOT_EXIST = 1;
    public static final int DRIVE_TYPE_RAMDISK = 6;
    public static final int DRIVE_TYPE_REMOTE = 4;
    public static final int DRIVE_TYPE_REMOVABLE = 2;
    public static final int DRIVE_TYPE_UNKNOW = 0;

    public static int getDriveType(String string) {
        return Extension.GetDriveType(string);
    }

    public static int getDriveType(File file) {
        return Extension.GetDriveType(file.getAbsolutePath());
    }

    public static long getDiskFreeSpace(String string) {
        DISKFREESPACE dISKFREESPACE = Extension.GetDiskFreeSpace(string);
        return dISKFREESPACE.freeBytesAvailable;
    }

    public static long getDiskFreeSpace(File file) {
        return FileSystem.getDiskFreeSpace(file.getAbsolutePath());
    }

    public static long getDiskTotalSize(String string) {
        DISKFREESPACE dISKFREESPACE = Extension.GetDiskFreeSpace(string);
        return dISKFREESPACE.totalNumberOfBytes;
    }

    public static long getDiskTotalSize(File file) {
        return FileSystem.getDiskTotalSize(file.getAbsolutePath());
    }

    public static String[] getLogicalDrives() {
        return Extension.GetLogicalDrives();
    }

    public static String getVolumeSerialNumber(String string) {
        return Extension.GetVolumeSerialNumber(string);
    }

    public static String getVolumeSerialNumber(File file) {
        return FileSystem.getVolumeSerialNumber(file.getAbsolutePath());
    }

    public static String getVolumeLabel(String string) {
        return Extension.GetVolumeLabel(string);
    }

    public static String getVolumeLabel(File file) {
        return FileSystem.getVolumeLabel(file.getAbsolutePath());
    }

    public static boolean setVolumeLabel(String string, String string2) {
        return Extension.SetVolumeLabel(string, string2);
    }

    public static boolean setVolumeLabel(File file, String string) {
        return FileSystem.setVolumeLabel(file.getAbsolutePath(), string);
    }

    public static String getCurrentDirectory() {
        return Extension.GetCurrentDirectory();
    }

    public static boolean setCurrentDirectory(String string) {
        return Extension.SetCurrentDirectory(string);
    }

    public static boolean setCurrentDirectory(File file) {
        return FileSystem.setCurrentDirectory(file.getAbsolutePath());
    }

    public static String getSystemDirectory() {
        return Extension.GetSystemDirectory();
    }

    public static String getWindowsDirectory() {
        return Extension.GetWindowsDirectory();
    }

    public static String getTempPath() {
        return Extension.GetTempPath();
    }

    public static String getLongPathName(String string) {
        return Extension.GetLongPathName(string);
    }

    public static String getShortPathName(String string) throws IllegalArgumentException {
        try {
            File file = new File(string);
            if (file.exists()) {
                return Kernel32.GetShortPathName(string);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException("The path is not exist.");
    }
}

