/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.ptr.memory;

import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.AbstractMemoryBlock;
import org.sf.feeling.swt.win32.extension.jna.win32.Kernel32;

public class GlobalMemoryBlock
extends AbstractMemoryBlock {
    public static final int GMEM_FIXED = 0;
    public static final int GMEM_ZEROINIT = 64;
    public static final int GPTR = 64;
    public static final int GMEM_MOVEABLE = 2;
    public static final int GHND = 66;
    private int type;

    public GlobalMemoryBlock(int n) throws NativeException {
        this(n, 64);
    }

    public GlobalMemoryBlock(int n, int n2) throws NativeException {
        super(n);
        this.type = n2;
        this.reserveMemory(n);
    }

    public int reserveMemory(int n) throws NativeException {
        this.setSize(n);
        if (this.getPointer() != 0) {
            this.dispose();
        }
        try {
            this.setPointer(Kernel32.GlobalAlloc(n, this.type));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException.getLocalizedMessage());
        }
        return this.getPointer();
    }

    public void dispose() throws NativeException {
        try {
            if (this.getPointer() != 0) {
                if (Kernel32.GlobalFree(this.getPointer()) != 0) {
                    throw new NativeException("Memory not freed !");
                }
                this.setPointer(0);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException.getLocalizedMessage());
        }
    }

    public int globalLock() throws NativeException, IllegalAccessException {
        return Kernel32.GlobalLock(this.getPointer());
    }

    public boolean globalUnlock() throws NativeException, IllegalAccessException {
        return Kernel32.GlobalUnlock(this.getPointer());
    }

    public boolean copyMemory(Pointer pointer) throws NativeException, IllegalAccessException {
        int n = this.globalLock();
        if (n != 0) {
            Kernel32.RtlMoveMemory(n, pointer.getPointer(), pointer.getSize());
        }
        return n != 0 && this.globalUnlock();
    }

    public boolean copyMemory(Pointer pointer, int n) throws NativeException, IllegalAccessException {
        int n2 = this.globalLock();
        if (n2 != 0) {
            Kernel32.RtlMoveMemory(n2, pointer.getPointer(), n);
        }
        return n2 != 0 && this.globalUnlock();
    }
}

