/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.HeapMemoryBlock;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;

public class BITMAP
extends Structure {
    public BITMAP() {
        try {
            this.createPointer();
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
    }

    public Pointer createBitmapBuffer() throws NativeException {
        return new Pointer(new HeapMemoryBlock(this.getNeededBufferSize()));
    }

    public int getWidth() throws NativeException {
        return this.pointer.getAsInt(4);
    }

    public int getHeight() throws NativeException {
        return this.pointer.getAsInt(8);
    }

    public int getNeededBufferSize() throws NativeException {
        return this.getWidth() * this.getHeight() * 4;
    }

    public int getRealBitmapSize() throws NativeException {
        return this.getWidth() * this.getHeight();
    }

    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    public int getSizeOf() {
        return BITMAP.sizeOf();
    }

    public static int sizeOf() {
        return 24;
    }

    public Object getValueFromPointer() {
        return this;
    }

    public BITMAP getValue() {
        return this;
    }
}

