/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.eclipse.swt.graphics.Rectangle;
import org.sf.feeling.swt.win32.extension.jna.Machine;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;

public class LRECT
extends Structure {
    public LRECT() {
        try {
            this.createPointer();
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
    }

    public LRECT(Rectangle rectangle) {
        this();
        try {
            this.setTop(rectangle.y);
            this.setLeft(rectangle.x);
            this.setRight(rectangle.x + rectangle.width);
            this.setBottom(rectangle.y + rectangle.height);
        }
        catch (NativeException nativeException) {
            nativeException.printStackTrace();
            throw new RuntimeException(nativeException);
        }
    }

    public int getWidth() throws NativeException {
        return this.getRight() - this.getLeft();
    }

    public int getHeight() throws NativeException {
        return this.getBottom() - this.getTop();
    }

    public int getLeft() throws NativeException {
        return this.pointer.getAsInt(0);
    }

    public int getRight() throws NativeException {
        return this.pointer.getAsInt(8);
    }

    public int getTop() throws NativeException {
        return this.pointer.getAsInt(4);
    }

    public int getBottom() throws NativeException {
        return this.pointer.getAsInt(12);
    }

    public void setLeft(int n) throws NativeException {
        this.pointer.setIntAt(0, n);
    }

    public void setRight(int n) throws NativeException {
        this.pointer.setIntAt(8, n);
    }

    public void setTop(int n) throws NativeException {
        this.pointer.setIntAt(4, n);
    }

    public void setBottom(int n) throws NativeException {
        this.pointer.setIntAt(12, n);
    }

    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(LRECT.sizeOf()));
        return this.pointer;
    }

    public Object getValueFromPointer() throws NativeException {
        return this;
    }

    public LRECT getValueValue() throws NativeException {
        return this;
    }

    public int getSizeOf() {
        return LRECT.sizeOf();
    }

    public static int sizeOf() {
        return Machine.SIZE * 16;
    }
}

