/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;

public class POINT
extends Structure {
    protected int x;
    protected int y;

    public POINT() {
        this(0, 0);
    }

    public POINT(int n, int n2) {
        try {
            this.createPointer();
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
        this.x = n;
        this.y = n2;
    }

    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(POINT.sizeOf()));
        return this.pointer;
    }

    public Object getValueFromPointer() throws NativeException {
        this.x = this.pointer.getAsInt(0);
        this.y = this.pointer.getAsInt(4);
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int n) throws NativeException {
        this.x = n;
        this.pointer.setIntAt(0, n);
    }

    public void setY(int n) throws NativeException {
        this.y = n;
        this.pointer.setIntAt(4, n);
    }

    public POINT getValue() {
        try {
            this.pointer.setIntAt(0, this.x);
            this.pointer.setIntAt(4, this.y);
        }
        catch (NativeException nativeException) {
            nativeException.printStackTrace();
        }
        return this;
    }

    public int getSizeOf() {
        return POINT.sizeOf();
    }

    public static int sizeOf() {
        return 8;
    }
}

