/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.NullPointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;

public class SECURITY_ATTRIBUTES {
    private int nLength = 12;
    private Pointer lpSecurityDescriptor = new NullPointer();
    private boolean bInheritHandle = true;
    private Pointer self;

    public SECURITY_ATTRIBUTES() {
        try {
            this.self = Pointer.createPointer(this.nLength);
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
    }

    public Pointer getPointer() {
        return this.self;
    }

    public void dispose() throws NativeException {
        this.self.dispose();
        this.lpSecurityDescriptor.dispose();
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (NativeException nativeException) {
            nativeException.printStackTrace();
        }
    }

    public void setNLength(int n) throws NativeException {
        this.nLength = n;
        this.self.setIntAt(0, n);
    }

    public int getNLength() throws NativeException {
        this.nLength = this.self.getAsInt(0);
        return this.nLength;
    }

    public void setLpSecurityDescriptor(Pointer pointer) throws NativeException {
        this.lpSecurityDescriptor = pointer;
        this.self.setIntAt(4, pointer.getPointer());
    }

    public Pointer getLpSecurityDescriptor() {
        return this.lpSecurityDescriptor;
    }

    public void setBInheritHandle(boolean bl) throws NativeException {
        this.bInheritHandle = bl;
        this.lpSecurityDescriptor.setIntAt(8, bl ? 1 : 0);
    }

    public boolean isBInheritHandle() throws NativeException {
        this.bInheritHandle = this.lpSecurityDescriptor.getAsInt(8) != 0;
        return this.bInheritHandle;
    }
}

