/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.shell;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.Win32;
import org.sf.feeling.swt.win32.extension.shell.SystemMenuItem;
import org.sf.feeling.swt.win32.extension.shell.SystemMenuMsgHook;
import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.Extension2;
import org.sf.feeling.swt.win32.internal.extension.graphics.BitmapUtil;

public class SystemMenuManager {
    private int hMenu;
    private Map itemMap = new HashMap();
    private Shell shell;
    private SystemMenuMsgHook hook;
    boolean visiable = false;
    boolean disposed = false;

    public SystemMenuManager(Shell shell) {
        this.shell = shell;
        this.hMenu = Extension.GetSystemMenu((int)shell.handle, (boolean)false);
        this.hook = new SystemMenuMsgHook(this);
        this.hook.installHook();
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SystemMenuManager.this.dispose();
            }
        });
    }

    public void addItem(SystemMenuItem systemMenuItem) {
        this.addItem(systemMenuItem, -1);
    }

    public void addItem(SystemMenuItem systemMenuItem, int n) {
        this.addItem(systemMenuItem, n, 1024);
    }

    public void addItem(SystemMenuItem systemMenuItem, int n, int n2) {
        this.checkState();
        if (this.itemMap.containsKey(systemMenuItem.getId())) {
            return;
        }
        int n3 = 0;
        if (n2 == 1024) {
            n3 = 1024;
        }
        TCHAR tCHAR = null;
        if ((systemMenuItem.getStyle() & 2) != 0) {
            n3 |= 0x800;
        } else {
            n3 |= 0;
            tCHAR = new TCHAR(0, systemMenuItem.getText(), true);
        }
        Extension2.InsertMenu(this.hMenu, n, n3, systemMenuItem.getId(), tCHAR);
        if ((systemMenuItem.getStyle() & 2) == 0) {
            systemMenuItem.setEnabled(systemMenuItem.isEnabled());
            systemMenuItem.setSelection(systemMenuItem.getSelection());
            if (systemMenuItem.getImage() != null) {
                this.setImage(systemMenuItem.getId(), systemMenuItem.getImage());
            }
        }
        this.itemMap.put(systemMenuItem.getId(), systemMenuItem);
    }

    private void checkState() {
        if (this.shell == null) {
            throw new NullPointerException("Shell is null");
        }
        if (this.shell.isDisposed()) {
            throw new IllegalStateException("Shell has been closed");
        }
    }

    boolean getEnabled(int n) {
        int n2;
        this.checkState();
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        boolean bl = Extension.GetMenuItemInfo((int)this.hMenu, (int)n, (boolean)false, (MENUITEMINFO)mENUITEMINFO);
        if (!bl) {
            SWT.error((int)31);
        }
        return (mENUITEMINFO.fState & (n2 = 3)) == 0;
    }

    SystemMenuItem getItem(int n) {
        return (SystemMenuItem)this.itemMap.get(new Integer(n));
    }

    boolean getSelection(int n) {
        this.checkState();
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        boolean bl = Extension.GetMenuItemInfo((int)this.hMenu, (int)n, (boolean)false, (MENUITEMINFO)mENUITEMINFO);
        if (!bl) {
            SWT.error((int)9);
        }
        return (mENUITEMINFO.fState & 8) != 0;
    }

    public Shell getShell() {
        return this.shell;
    }

    String getText(int n) {
        this.checkState();
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        if (Win32.getWin32Version() >= Win32.VERSION(4, 10)) {
            mENUITEMINFO.fMask = 64;
        } else {
            mENUITEMINFO.fMask = 16;
            mENUITEMINFO.fType = 0;
        }
        int n2 = Extension.GetProcessHeap();
        int n3 = 0;
        mENUITEMINFO.dwTypeData = n3 = Extension.HeapAlloc((int)n2, (int)8, (int)1024);
        mENUITEMINFO.cch = 1024;
        boolean bl = Extension.GetMenuItemInfo((int)this.hMenu, (int)n, (boolean)false, (MENUITEMINFO)mENUITEMINFO);
        if (!bl) {
            if (n3 != 0) {
                OS.HeapFree((int)n2, (int)0, (int)n3);
            }
            SWT.error((int)12);
        }
        n3 = mENUITEMINFO.dwTypeData;
        TCHAR tCHAR = new TCHAR(0, mENUITEMINFO.cch / TCHAR.sizeof);
        OS.MoveMemory((TCHAR)tCHAR, (int)n3, (int)mENUITEMINFO.cch);
        if (n3 != 0) {
            OS.HeapFree((int)n2, (int)0, (int)n3);
        }
        return tCHAR.toString(0, tCHAR.strlen());
    }

    private void initSysMenuPopup(int n, int n2) {
        boolean bl = (n & 0x40000) == 0 || (n & 0x21000000) != 0;
        this.setEnabled(61440, !bl);
        bl = (n & 0x21000000) != 0;
        this.setEnabled(61456, !bl);
        bl = (n & Win32.WS_MINIMIZEBOX) == 0 || (n & 0x20000000) != 0;
        this.setEnabled(61472, !bl);
        bl = (n & Win32.WS_MAXIMIZEBOX) == 0 || (n & 0x1000000) != 0;
        this.setEnabled(61488, !bl);
        bl = (n & 0x21000000) == 0;
        this.setEnabled(61728, !bl);
        boolean bl2 = bl = (n2 & 0x200) != 0;
        if (bl) {
            this.setEnabled(61536, false);
        }
    }

    void removeItem(int n) {
        this.checkState();
        Extension.RemoveMenu((int)this.hMenu, (int)n, (int)0);
        this.itemMap.remove(new Integer(n));
    }

    public void resetMenu() {
        this.checkState();
        Extension.GetSystemMenu((int)this.shell.handle, (boolean)true);
        this.itemMap.clear();
        this.hMenu = Extension.GetSystemMenu((int)this.shell.handle, (boolean)false);
    }

    void setEnabled(int n, boolean bl) {
        this.checkState();
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        boolean bl2 = Extension.GetMenuItemInfo((int)this.hMenu, (int)n, (boolean)false, (MENUITEMINFO)mENUITEMINFO);
        if (!bl2) {
            return;
        }
        int n2 = 3;
        if (bl) {
            if ((mENUITEMINFO.fState & n2) == 0) {
                return;
            }
            mENUITEMINFO.fState &= ~n2;
        } else {
            if ((mENUITEMINFO.fState & n2) == n2) {
                return;
            }
            mENUITEMINFO.fState |= n2;
        }
        bl2 = Extension.SetMenuItemInfo((int)this.hMenu, (int)n, (boolean)false, (MENUITEMINFO)mENUITEMINFO);
        if (!bl2) {
            if (Win32.getWin32Version() >= Win32.VERSION(6, 0)) {
                boolean bl3 = bl2 = n == Extension.GetMenuDefaultItem((int)this.hMenu, (int)0, (int)1);
            }
            if (!bl2) {
                SWT.error((int)30);
            }
        }
    }

    void setImage(int n, Image image) {
        this.checkState();
        int n2 = image != null ? BitmapUtil.create32bitDIB(image) : 0;
        Extension.SetMenuItemBitmaps(this.hMenu, n, 4, n2, n2);
    }

    void setSelection(int n, boolean bl) {
        this.checkState();
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        boolean bl2 = Extension.GetMenuItemInfo((int)this.hMenu, (int)n, (boolean)false, (MENUITEMINFO)mENUITEMINFO);
        if (!bl2) {
            SWT.error((int)28);
        }
        if (!bl2) {
            SWT.error((int)28);
        }
        mENUITEMINFO.fState &= 0xFFFFFFF7;
        if (bl) {
            mENUITEMINFO.fState |= 8;
        }
        if (!(bl2 = Extension.SetMenuItemInfo((int)this.hMenu, (int)n, (boolean)false, (MENUITEMINFO)mENUITEMINFO))) {
            if (Win32.getWin32Version() >= Win32.VERSION(6, 0)) {
                boolean bl3 = bl2 = n == Extension.GetMenuDefaultItem((int)this.hMenu, (int)0, (int)1);
            }
            if (!bl2) {
                SWT.error((int)28);
            }
        }
    }

    void setText(int n, String string) {
        this.checkState();
        int n2 = Extension.GetProcessHeap();
        int n3 = 0;
        boolean bl = false;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        TCHAR tCHAR = new TCHAR(0, string, true);
        int n4 = tCHAR.length() * TCHAR.sizeof;
        n3 = Extension.HeapAlloc((int)n2, (int)8, (int)n4);
        OS.MoveMemory((int)n3, (TCHAR)tCHAR, (int)n4);
        if (Win32.getWin32Version() >= Win32.VERSION(4, 10)) {
            mENUITEMINFO.fMask = 64;
        } else {
            mENUITEMINFO.fMask = 16;
            mENUITEMINFO.fType = 0;
        }
        mENUITEMINFO.dwTypeData = n3;
        bl = OS.SetMenuItemInfo((int)this.hMenu, (int)n, (boolean)false, (MENUITEMINFO)mENUITEMINFO);
        if (n3 != 0) {
            OS.HeapFree((int)n2, (int)0, (int)n3);
        }
        if (!bl) {
            SWT.error((int)13);
        }
    }

    public void showMenu() {
        int n = Extension.GetMessagePos();
        this.showMenu(new Point((int)((short)(n & 0xFFFF)), (int)((short)(n >> 16))));
    }

    public void showMenu(Point point) {
        this.checkState();
        int n = 384;
        if (Extension.GetKeyState((int)1) >= 0) {
            n |= 2;
        }
        this.initSysMenuPopup(Extension.GetWindowLongA((int)this.shell.handle, (int)-16), Extension.GetClassLong(this.shell.handle, -26));
        this.visiable = true;
        int n2 = Extension2.TrackPopupMenu(this.hMenu, n, point.x < 0 ? 0 : point.x, point.y, 0, this.shell.handle, null);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SystemMenuManager.this.visiable = false;
            }
        });
        if (n2 != 0) {
            Extension.SendMessage((int)this.shell.handle, (int)274, (int)n2, (int)0);
        }
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.hook.unInstallHook();
            this.itemMap.clear();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isMenuVisiable() {
        return this.visiable;
    }
}

