/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.shell.Windows;
import org.sf.feeling.swt.win32.extension.widgets.CMenu;
import org.sf.feeling.swt.win32.extension.widgets.CMenuItem;
import org.sf.feeling.swt.win32.extension.widgets.MenuHolderManager;
import org.sf.feeling.swt.win32.extension.widgets.Shortcut;
import org.sf.feeling.swt.win32.extension.widgets.Window;
import org.sf.feeling.swt.win32.extension.widgets.listener.MenuAdapter;
import org.sf.feeling.swt.win32.internal.extension.util.LONG;
import org.sf.feeling.swt.win32.internal.extension.widgets.UIManager;

public class ShellWrapper
extends Window {
    public static final String DISABLE_IMAGE = "disableImage";
    private Layout oldLayout;
    private Menu shellMenu;
    private boolean removeMarign = true;
    private boolean refreshed = false;
    private HashMap fixedItemMap = new HashMap();

    public boolean isRemoveMarign() {
        return this.removeMarign;
    }

    public void setRemoveMarign(boolean bl) {
        this.removeMarign = bl;
    }

    public ShellWrapper(Shell shell) {
        this.shell = shell;
    }

    public ShellWrapper(Shell shell, String string) {
        this.setTheme(string);
        this.shell = shell;
    }

    public void installTheme() {
        if ((this.shell.getStyle() & 0x20) != 0) {
            if (!this.isThemeInstalled()) {
                this.createWidget((Composite)this.shell, 0);
                this.initWindow(this.shell.getStyle());
                this.theamOnSelf(this.isRemoveMarign());
            }
            UIManager.installTheme(this.getTheme(), this);
        }
    }

    public void installTheme(String string) {
        this.setTheme(string);
        if (this.shell == null) {
            return;
        }
        boolean bl = this.shell.getMaximized();
        boolean bl2 = this.shell.getVisible();
        if ((this.shell.getStyle() & 0x20) != 0) {
            if (!this.isThemeInstalled()) {
                this.shell.setVisible(false);
                this.createWidget((Composite)this.shell, 0);
                this.initWindow(this.shell.getStyle());
                this.theamOnSelf(this.isRemoveMarign());
                if (!bl) {
                    Rectangle rectangle = this.shell.getBounds();
                    this.shell.setBounds(rectangle.x, rectangle.y, rectangle.width + Windows.getWindowBorderWidth() * 2, rectangle.height + Windows.getWindowBorderWidth() * 2);
                }
            }
            UIManager.installTheme(this.getTheme(), this);
            this.shell.setVisible(bl2);
        }
    }

    protected Composite createContents(Composite composite, int n) {
        this.hookShellUI();
        Composite composite2 = new Composite((Composite)this.shell, 0);
        composite2.setBackgroundMode(1);
        composite2.setData((Object)"Container");
        return composite2;
    }

    protected Composite getBorderContainer() {
        Composite composite = null;
        ArrayList<Control> arrayList = new ArrayList<Control>();
        arrayList.addAll(Arrays.asList(this.shell.getChildren()));
        for (int i = 0; i < arrayList.size(); ++i) {
            Control control = (Control)arrayList.get(i);
            if (control.getData() == null || !control.getData().equals("Container")) continue;
            composite = (Composite)control;
            break;
        }
        return composite;
    }

    public void open() {
        if (!this.isThemeInstalled()) {
            this.installTheme();
        }
        this.shell.open();
    }

    private void theamOnSelf(boolean bl) {
        Object object;
        ArrayList<Control> arrayList = new ArrayList<Control>();
        arrayList.addAll(Arrays.asList(this.shell.getChildren()));
        Composite composite = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (Control)arrayList.get(i);
            if (object.getData() == null || !object.getData().equals("Container")) continue;
            composite = (Composite)object;
            break;
        }
        if (composite != null) {
            arrayList.remove(composite);
            this.oldLayout = this.shell.getLayout();
            this.getClientArea().setLayout(this.shell.getLayout());
            this.getClientArea().setBackgroundMode(this.shell.getBackgroundMode());
            this.getClientArea().setBackground(this.shell.getBackground());
            this.getClientArea().setBackgroundImage(this.shell.getBackgroundImage());
            this.getClientArea().setForeground(this.shell.getForeground());
            this.getClientArea().setFont(this.shell.getFont());
            try {
                Layout layout = this.getClientArea().getLayout();
                if (layout != null && this.hasMarginSetting(layout) && bl) {
                    object = layout.getClass().getDeclaredField("marginWidth");
                    ((Field)object).setAccessible(true);
                    ((Field)object).setInt(layout, 0);
                    object = layout.getClass().getDeclaredField("marginHeight");
                    ((Field)object).setAccessible(true);
                    ((Field)object).setInt(layout, 0);
                }
            }
            catch (Exception exception) {
                SWT.error((int)1, (Throwable)exception);
            }
            if (this.shell.getMenuBar() != null) {
                this.shellMenu = this.shell.getMenuBar();
                this.shell.setMenuBar(null);
                this.createMenuBar();
                MenuHolderManager.registryShortcut(this.getMenuBar());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ((Control)arrayList.get(i)).setParent(this.getClientArea());
            }
            this.shell.setLayout((Layout)new FillLayout());
            this.layout();
        }
    }

    private boolean hasMarginSetting(Layout layout) {
        Field[] fieldArray = layout.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!"marginWidth".equals(fieldArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    private CMenuItem createMenuItem(final MenuItem menuItem) {
        Shortcut shortcut;
        CMenuItem cMenuItem = new CMenuItem(menuItem.getStyle());
        String string = menuItem.getText();
        String[] stringArray = string.split("\t");
        cMenuItem.setText(stringArray[0]);
        cMenuItem.setImage(menuItem.getImage());
        if (!menuItem.isEnabled() && menuItem.getData(DISABLE_IMAGE) != null) {
            cMenuItem.setDisableImage(menuItem.getImage());
        }
        cMenuItem.setEnabled(menuItem.isEnabled());
        cMenuItem.setSelection(menuItem.getSelection());
        if (stringArray.length > 1) {
            shortcut = new Shortcut(stringArray[1]);
            cMenuItem.setShortcut(shortcut);
        }
        cMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!menuItem.isDisposed()) {
                    Event event = new Event();
                    event.data = selectionEvent.data;
                    event.detail = selectionEvent.detail;
                    event.widget = menuItem;
                    event.doit = selectionEvent.doit;
                    event.display = selectionEvent.display;
                    menuItem.notifyListeners(13, event);
                }
            }
        });
        if (menuItem.getMenu() != null) {
            shortcut = menuItem.getMenu();
            CMenu cMenu = this.createCMenu((Menu)shortcut);
            cMenuItem.setMenu(cMenu);
        }
        return cMenuItem;
    }

    private CMenu createCMenu(final Menu menu) {
        final CMenu cMenu = new CMenu();
        cMenu.addMenuListener(new MenuAdapter(){

            public void menuShown(Event event) {
                if (!menu.isDisposed()) {
                    menu.notifyListeners(22, event);
                    MenuHolderManager.deRegistryShortcut(ShellWrapper.this.getMenuBar());
                    cMenu.removeAll();
                    ShellWrapper.this.createMenu(menu, cMenu);
                    MenuHolderManager.registryShortcut(ShellWrapper.this.getMenuBar());
                }
            }

            public void menuHidden(Event event) {
                if (!menu.isDisposed()) {
                    menu.notifyListeners(23, event);
                }
            }
        });
        this.createMenu(menu, cMenu);
        return cMenu;
    }

    private void createMenu(final Menu menu, CMenu cMenu) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            CMenuItem cMenuItem = this.createMenuItem(menu.getItem(i));
            cMenu.addItem(cMenuItem);
            if (!menu.equals(this.shellMenu)) continue;
            menu.getItem(i).addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if (!menu.isDisposed()) {
                                ShellWrapper.this.refreshMenuBar();
                            }
                        }
                    });
                }
            });
        }
    }

    public void unWrapper() {
        boolean bl = this.shell.getMaximized();
        if (!this.isThemeInstalled()) {
            return;
        }
        if (this.oldLayout == null) {
            this.shell.setLayout(this.getClientArea().getLayout());
        }
        this.shell.setLayout(this.oldLayout);
        Control[] controlArray = this.getClientArea().getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].setParent((Composite)this.shell);
        }
        this.getBorderContainer().dispose();
        if (this.shellMenu != null) {
            this.shell.setMenuBar(this.shellMenu);
        }
        this.shell.layout();
        if (!bl) {
            Rectangle rectangle = this.shell.getBounds();
            this.shell.setBounds(rectangle.x, rectangle.y, rectangle.width - Windows.getWindowBorderWidth() * 2, rectangle.height - Windows.getWindowBorderWidth() * 2);
        }
        this.unHookShellUI();
        this.redrawShell();
    }

    public Menu getShellMenu() {
        return this.shellMenu;
    }

    public void refreshMenuBar() {
        if (!this.refreshed) {
            this.refreshed = true;
            new Thread(){

                public void run() {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (ShellWrapper.this.shellMenu != null && !ShellWrapper.this.shellMenu.isDisposed()) {
                                ShellWrapper.this.createMenuBar();
                            }
                        }
                    });
                    ShellWrapper.this.refreshed = false;
                }
            }.start();
        }
    }

    public void addFixedMenuItem(int n, CMenuItem cMenuItem) {
        this.fixedItemMap.put(new LONG(n), cMenuItem);
    }

    private void createMenuBar() {
        if (this.getMenuBar() == null || this.getMenuBar().getControl().isDisposed()) {
            return;
        }
        this.getMenuBar().getMenu().removeAll();
        if (this.shellMenu != null) {
            this.createMenu(this.shellMenu, this.getMenuBar().getMenu());
        }
        if (!this.fixedItemMap.isEmpty()) {
            Iterator iterator = this.fixedItemMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int n = ((LONG)entry.getKey()).value;
                if (n > -1 && n < this.getMenuBar().getMenu().getItemCount()) {
                    this.getMenuBar().getMenu().addItem(n, (CMenuItem)entry.getValue());
                    continue;
                }
                this.getMenuBar().getMenu().addItem((CMenuItem)entry.getValue());
            }
        }
        this.getMenuBar().refresh();
    }
}

