/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.util;

public class FlagSet {
    protected int flag = 0;

    public FlagSet() {
    }

    public FlagSet(int n) {
        this.flag = n;
    }

    public void and(int n) {
        this.flag &= n;
    }

    public void or(int n) {
        this.flag |= n;
    }

    public void add(int n) {
        this.or(n);
    }

    public void remove(int n) {
        this.flag &= ~n;
    }

    public boolean contains(int n) {
        return (this.flag & n) == n;
    }

    public void clear() {
        this.flag = 0;
    }

    public long getFlags() {
        return this.flag;
    }

    public void setupFlag(int n, boolean bl) {
        if (bl) {
            this.add(n);
        } else {
            this.remove(n);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FlagSet: [").append(Long.toBinaryString(this.getFlags())).append(']');
        return stringBuffer.toString();
    }

    public int getBits(int n, int n2) {
        if (0 <= n && n <= n2 && n2 <= 64) {
            long l = FlagSet.getMask(n, n2);
            long l2 = ((long)this.flag & l) >> n;
            return (int)l2;
        }
        throw new RuntimeException("Incorrect range of bits.");
    }

    public boolean getBit(int n) {
        return ((long)this.flag & (long)(1 << n)) != 0L;
    }

    public void setBit(int n, boolean bl) {
        this.flag = bl ? (this.flag |= 1 << n) : (this.flag &= ~(1 << n));
    }

    public void setBits(int n, int n2, int n3) {
        long l = FlagSet.getMask(n, n2);
        long l2 = n3 << n;
        this.flag = (int)((long)this.flag | l2 & l);
    }

    public static long getMask(int n, int n2) {
        int n3 = n2 - n + 1;
        long l = 1L;
        while (n3-- > 0) {
            l *= 2L;
        }
        return --l << n;
    }
}

