/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.sf.feeling.swt.win32.internal.extension.widgets.ISkinable;

public class BorderCanvas
extends Canvas {
    private int borderType;
    private ISkinable drawable;
    private Image swapImage;

    public BorderCanvas(Composite composite, int n) {
        super(composite, 0);
        this.borderType = n;
        this.setBackgroundMode(1);
        this.createLayoutData(n);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                BorderCanvas.this.updateSkin(event);
            }
        });
    }

    public int getType() {
        return this.borderType;
    }

    public ISkinable getDrawable() {
        return this.drawable;
    }

    public void setDrawable(ISkinable iSkinable) {
        GridData gridData = (GridData)this.getLayoutData();
        switch (this.getType()) {
            case 1: 
            case 6: {
                gridData.heightHint = iSkinable.getInitHeight();
                break;
            }
            case 3: 
            case 4: {
                gridData.widthHint = iSkinable.getInitWidth();
                break;
            }
            default: {
                gridData.widthHint = iSkinable.getInitWidth();
                gridData.heightHint = iSkinable.getInitHeight();
            }
        }
        this.setLayoutData(gridData);
        this.drawable = iSkinable;
    }

    public void setHeight(int n) {
        GridData gridData = (GridData)this.getLayoutData();
        switch (this.getType()) {
            case 1: 
            case 6: {
                gridData.heightHint = n;
                break;
            }
            default: {
                gridData.heightHint = n;
            }
        }
        this.setLayoutData(gridData);
    }

    public void setWidth(int n) {
        GridData gridData = (GridData)this.getLayoutData();
        switch (this.getType()) {
            case 3: 
            case 4: {
                gridData.widthHint = n;
                break;
            }
            default: {
                gridData.widthHint = n;
            }
        }
        this.setLayoutData(gridData);
    }

    private void createLayoutData(int n) {
        GridData gridData;
        switch (n) {
            case 1: 
            case 6: {
                gridData = new GridData(4, 4, true, false);
                break;
            }
            case 3: 
            case 4: {
                gridData = new GridData(4, 4, false, true);
                break;
            }
            default: {
                gridData = new GridData(4, 4, false, false);
            }
        }
        this.setLayoutData(gridData);
    }

    public void dispose() {
        super.dispose();
        if (this.swapImage != null) {
            this.swapImage.dispose();
            this.swapImage = null;
        }
    }

    public void updateSkin(Event event) {
        if (this.swapImage != null) {
            this.swapImage.dispose();
            this.swapImage = null;
        }
        if (this.drawable != null) {
            Color color = this.drawable.getForeground(event);
            if (color != null && !color.isDisposed()) {
                this.setForeground(color);
            }
            GridData gridData = (GridData)this.getLayoutData();
            Rectangle rectangle = this.getBounds();
            int n = 0;
            int n2 = 0;
            n = gridData.widthHint > 0 ? gridData.widthHint : rectangle.width;
            n2 = gridData.heightHint > 0 ? gridData.heightHint : rectangle.height;
            n = n > 0 ? n : this.drawable.getInitWidth();
            int n3 = n2 = n2 > 0 ? n2 : this.drawable.getInitHeight();
            if (n > 0 && n2 > 0) {
                this.swapImage = new Image((Device)this.getDisplay(), n, n2);
                GC gC = new GC((Drawable)this.swapImage);
                this.drawable.configue(event);
                this.drawable.paint(gC, 0, 0, n, n2);
                gC.dispose();
                this.setBackgroundImage(this.swapImage);
            }
        }
    }
}

