/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.dialogs.IDialogBlockedHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.runtime.IProgressMonitor;
import org.eclipse.jface.runtime.IStatus;
import org.eclipse.jface.runtime.Status;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class Dialog
extends Window {
    public static final String DLG_IMG_ERROR = "dialog_error_image";
    public static final String DLG_IMG_INFO = "dialog_info_imageg";
    public static final String DLG_IMG_QUESTION = "dialog_question_image";
    public static final String DLG_IMG_WARNING = "dialog_warning_image";
    public static final String DLG_IMG_MESSAGE_INFO = "dialog_messasge_info_image";
    public static final String DLG_IMG_MESSAGE_WARNING = "dialog_messasge_warning_image";
    public static final String DLG_IMG_MESSAGE_ERROR = "dialog_message_error_image";
    public static final String DLG_IMG_HELP = "dialog_help_image";
    public static final String ELLIPSIS = "...";
    private static final String DIALOG_ORIGIN_X = "DIALOG_X_ORIGIN";
    private static final String DIALOG_ORIGIN_Y = "DIALOG_Y_ORIGIN";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_FONT_DATA = "DIALOG_FONT_NAME";
    public static final int DIALOG_DEFAULT_BOUNDS = -1;
    public static final int DIALOG_PERSISTLOCATION = 1;
    public static final int DIALOG_PERSISTSIZE = 2;
    protected Control dialogArea;
    public Control buttonBar;
    private HashMap buttons = new HashMap();
    private FontMetrics fontMetrics;
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    private static final int VERTICAL_DIALOG_UNITS_PER_CHAR = 8;
    public static IDialogBlockedHandler blockedHandler = new IDialogBlockedHandler(){

        public void clearBlocked() {
        }

        public void showBlocked(IProgressMonitor iProgressMonitor, IStatus iStatus, String string) {
        }

        public void showBlocked(Shell shell, IProgressMonitor iProgressMonitor, IStatus iStatus, String string) {
        }
    };

    public static int convertHeightInCharsToPixels(FontMetrics fontMetrics, int n) {
        return fontMetrics.getHeight() * n;
    }

    public static int convertHorizontalDLUsToPixels(FontMetrics fontMetrics, int n) {
        return (fontMetrics.getAverageCharWidth() * n + 2) / 4;
    }

    public static int convertVerticalDLUsToPixels(FontMetrics fontMetrics, int n) {
        return (fontMetrics.getHeight() * n + 4) / 8;
    }

    public static int convertWidthInCharsToPixels(FontMetrics fontMetrics, int n) {
        return fontMetrics.getAverageCharWidth() * n;
    }

    public static String shortenText(String string, Control control) {
        if (string == null) {
            return null;
        }
        GC gC = new GC((Drawable)control);
        int n = gC.textExtent((String)string).x;
        int n2 = control.getBounds().width - 5;
        if (n < n2) {
            gC.dispose();
            return string;
        }
        int n3 = string.length();
        int n4 = Math.round(0.95f * (float)n3 * (1.0f - (float)n2 / (float)n));
        int n5 = n3 / 2;
        int n6 = n5 - n4 / 2;
        for (int i = n5 + n4 / 2 + 1; n6 >= 0 && i < n3; --n6, ++i) {
            String string2 = string.substring(0, n6);
            String string3 = string.substring(i, n3);
            String string4 = string2 + ELLIPSIS + string3;
            int n7 = gC.textExtent((String)string4).x;
            if (n7 >= n2) continue;
            gC.dispose();
            return string4;
        }
        gC.dispose();
        return string;
    }

    protected Dialog(Shell shell) {
        this(new SameShellProvider((Control)shell));
        if (shell == null && Policy.DEBUG_DIALOG_NO_PARENT) {
            Policy.getLog().log(new Status(1, "org.eclipse.jface", 1, this.getClass() + " created with no shell", new Exception()));
        }
    }

    protected Dialog(IShellProvider iShellProvider) {
        super(iShellProvider);
        if (this.isResizable()) {
            this.setShellStyle(0x10C70 | Dialog.getDefaultOrientation());
        } else {
            this.setShellStyle(0x10860 | Dialog.getDefaultOrientation());
        }
        this.setBlockOnOpen(true);
    }

    protected void buttonPressed(int n) {
        if (0 == n) {
            this.okPressed();
        } else if (1 == n) {
            this.cancelPressed();
        }
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    protected int convertHeightInCharsToPixels(int n) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels(this.fontMetrics, n);
    }

    protected int convertHorizontalDLUsToPixels(int n) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHorizontalDLUsToPixels(this.fontMetrics, n);
    }

    protected int convertVerticalDLUsToPixels(int n) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertVerticalDLUsToPixels(this.fontMetrics, n);
    }

    protected int convertWidthInCharsToPixels(int n) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels(this.fontMetrics, n);
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Shell shell;
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setText(string);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(n));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Dialog.this.buttonPressed((Integer)selectionEvent.widget.getData());
            }
        });
        if (bl && (shell = composite.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.buttons.put(new Integer(n), button);
        this.setButtonLayoutData(button);
        return button;
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 0;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(132);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        this.createButtonsForButtonBar(composite2);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void initializeBounds() {
        Button button;
        Shell shell = this.getShell();
        if (shell != null && shell.getDisplay().getDismissalAlignment() == 131072 && (button = shell.getDefaultButton()) != null && this.isContained(this.buttonBar, (Control)button)) {
            button.moveBelow(null);
            ((Composite)this.buttonBar).layout();
        }
        super.initializeBounds();
    }

    private boolean isContained(Control control, Control control2) {
        Composite composite;
        while ((composite = control2.getParent()) != null) {
            if (composite == control) {
                return true;
            }
            control2 = composite;
        }
        return false;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite2);
        this.initializeDialogUnits((Control)composite2);
        this.dialogArea = this.createDialogArea(composite2);
        this.buttonBar = this.createButtonBar(composite2);
        return composite2;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected Button getButton(int n) {
        return (Button)this.buttons.get(new Integer(n));
    }

    protected Control getButtonBar() {
        return this.buttonBar;
    }

    protected Button getCancelButton() {
        return this.getButton(1);
    }

    protected Control getDialogArea() {
        return this.dialogArea;
    }

    public static Image getImage(String string) {
        return JFaceResources.getImageRegistry().get(string);
    }

    protected Button getOKButton() {
        return this.getButton(0);
    }

    protected void initializeDialogUnits(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gC.getFontMetrics();
        gC.dispose();
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.close();
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(n, point.x);
        button.setLayoutData((Object)gridData);
    }

    protected void setButtonLayoutFormData(Button button) {
        FormData formData = new FormData();
        int n = this.convertHorizontalDLUsToPixels(61);
        Point point = button.computeSize(-1, -1, true);
        formData.width = Math.max(n, point.x);
        button.setLayoutData((Object)formData);
    }

    public boolean close() {
        boolean bl;
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.saveDialogBounds(this.getShell());
        }
        if (bl = super.close()) {
            this.buttons = new HashMap();
            this.buttonBar = null;
            this.dialogArea = null;
        }
        return bl;
    }

    public static void applyDialogFont(Control control) {
        if (control == null || Dialog.dialogFontIsDefault()) {
            return;
        }
        Font font = JFaceResources.getDialogFont();
        Dialog.applyDialogFont(control, font);
    }

    private static void applyDialogFont(Control control, Font font) {
        if (Dialog.hasDefaultFont(control)) {
            control.setFont(font);
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                Dialog.applyDialogFont(controlArray[i], font);
            }
        }
    }

    private static boolean hasDefaultFont(Control control) {
        FontData[] fontDataArray;
        FontData[] fontDataArray2 = control.getFont().getFontData();
        if (fontDataArray2.length == (fontDataArray = Dialog.getDefaultFont(control).getFontData()).length) {
            for (int i = 0; i < fontDataArray2.length; ++i) {
                if (fontDataArray2[i].equals((Object)fontDataArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Font getDefaultFont(Control control) {
        String string = "DEFAULT_FONT_" + control.getClass().getName();
        if (JFaceResources.getFontRegistry().hasValueFor(string)) {
            return JFaceResources.getFontRegistry().get(string);
        }
        Font font = control.getFont();
        control.setFont(null);
        Font font2 = control.getFont();
        control.setFont(font);
        JFaceResources.getFontRegistry().put(string, font2.getFontData());
        return font2;
    }

    protected static boolean dialogFontIsDefault() {
        Object[] objectArray = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.dialogfont");
        Object[] objectArray2 = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.defaultfont");
        return Arrays.equals(objectArray, objectArray2);
    }

    public void create() {
        super.create();
        Dialog.applyDialogFont(this.buttonBar);
    }

    public static IDialogBlockedHandler getBlockedHandler() {
        return blockedHandler;
    }

    public static void setBlockedHandler(IDialogBlockedHandler iDialogBlockedHandler) {
        blockedHandler = iDialogBlockedHandler;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected int getDialogBoundsStrategy() {
        return 3;
    }

    private void saveDialogBounds(Shell shell) {
        IDialogSettings iDialogSettings = this.getDialogBoundsSettings();
        if (iDialogSettings != null) {
            int n;
            Point point = shell.getLocation();
            Point point2 = shell.getSize();
            Shell shell2 = this.getParentShell();
            if (shell2 != null) {
                Point point3 = shell2.getLocation();
                point.x -= point3.x;
                point.y -= point3.y;
            }
            if (((n = this.getDialogBoundsStrategy()) & 1) != 0) {
                iDialogSettings.put(DIALOG_ORIGIN_X, point.x);
                iDialogSettings.put(DIALOG_ORIGIN_Y, point.y);
            }
            if ((n & 2) != 0) {
                iDialogSettings.put(DIALOG_WIDTH, point2.x);
                iDialogSettings.put(DIALOG_HEIGHT, point2.y);
                FontData[] fontDataArray = JFaceResources.getDialogFont().getFontData();
                if (fontDataArray.length > 0) {
                    iDialogSettings.put(DIALOG_FONT_DATA, fontDataArray[0].toString());
                }
            }
        }
    }

    protected Point getInitialSize() {
        IDialogSettings iDialogSettings;
        Point point = super.getInitialSize();
        if ((this.getDialogBoundsStrategy() & 2) != 0 && (iDialogSettings = this.getDialogBoundsSettings()) != null) {
            FontData[] fontDataArray;
            boolean bl = true;
            String string = iDialogSettings.get(DIALOG_FONT_DATA);
            if (string != null && string.length() > 0 && (fontDataArray = JFaceResources.getDialogFont().getFontData()).length > 0) {
                String string2 = fontDataArray[0].toString();
                bl = string2.equalsIgnoreCase(string);
            }
            if (bl) {
                try {
                    int n;
                    int n2 = iDialogSettings.getInt(DIALOG_WIDTH);
                    if (n2 != -1) {
                        point.x = n2;
                    }
                    if ((n = iDialogSettings.getInt(DIALOG_HEIGHT)) != -1) {
                        point.y = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return point;
    }

    protected Point getInitialLocation(Point point) {
        IDialogSettings iDialogSettings;
        Point point2 = super.getInitialLocation(point);
        if ((this.getDialogBoundsStrategy() & 1) != 0 && (iDialogSettings = this.getDialogBoundsSettings()) != null) {
            try {
                int n = iDialogSettings.getInt(DIALOG_ORIGIN_X);
                int n2 = iDialogSettings.getInt(DIALOG_ORIGIN_Y);
                point2 = new Point(n, n2);
                Shell shell = this.getParentShell();
                if (shell != null) {
                    Point point3 = shell.getLocation();
                    point2.x += point3.x;
                    point2.y += point3.y;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return point2;
    }

    protected boolean isResizable() {
        return false;
    }
}

