/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class IconAndMessageDialog
extends Dialog {
    protected String message;
    protected Label messageLabel;
    protected Label imageLabel;

    public IconAndMessageDialog(Shell shell) {
        super(shell);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.addAccessibleListeners(this.imageLabel, image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            this.messageLabel = new Label(composite, this.getMessageLabelStyle());
            this.messageLabel.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageLabel);
        }
        return composite;
    }

    private String getAccessibleMessageFor(Image image) {
        if (image.equals((Object)this.getErrorImage())) {
            return JFaceResources.getString("error");
        }
        if (image.equals((Object)this.getWarningImage())) {
            return JFaceResources.getString("warning");
        }
        if (image.equals((Object)this.getInfoImage())) {
            return JFaceResources.getString("info");
        }
        if (image.equals((Object)this.getQuestionImage())) {
            return JFaceResources.getString("question");
        }
        return null;
    }

    private void addAccessibleListeners(Label label, final Image image) {
        label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string = IconAndMessageDialog.this.getAccessibleMessageFor(image);
                if (string == null) {
                    return;
                }
                accessibleEvent.result = string;
            }
        });
    }

    protected int getMessageLabelStyle() {
        return 64;
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(0).equalWidth(true).applyTo(composite2);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(2, 1).applyTo((Control)composite2);
        composite2.setFont(composite.getFont());
        this.createButtonsForButtonBar(composite2);
        return composite2;
    }

    protected abstract Image getImage();

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Point point = LayoutConstants.getSpacing();
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).spacing(point.x * 2, point.y).numColumns(this.getColumnCount()).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.createDialogAndButtonArea(composite);
        return composite;
    }

    int getColumnCount() {
        return 2;
    }

    protected void createDialogAndButtonArea(Composite composite) {
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        IconAndMessageDialog.applyDialogFont((Control)composite);
    }

    public Image getErrorImage() {
        return this.getSWTImage(1);
    }

    public Image getWarningImage() {
        return this.getSWTImage(8);
    }

    public Image getInfoImage() {
        return this.getSWTImage(2);
    }

    public Image getQuestionImage() {
        return this.getSWTImage(4);
    }

    private Image getSWTImage(final int n) {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = this.getParentShell();
        }
        final Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        final Image[] imageArray = new Image[1];
        display.syncExec(new Runnable(){

            public void run() {
                imageArray[0] = display.getSystemImage(n);
            }
        });
        return imageArray[0];
    }
}

