/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.layout;

import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.layout.LayoutGenerator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class GridLayoutFactory {
    private GridLayout l;

    private GridLayoutFactory(GridLayout gridLayout) {
        this.l = gridLayout;
    }

    public static GridLayoutFactory createFrom(GridLayout gridLayout) {
        return new GridLayoutFactory(GridLayoutFactory.copyLayout(gridLayout));
    }

    public GridLayoutFactory copy() {
        return new GridLayoutFactory(this.create());
    }

    public static GridLayoutFactory swtDefaults() {
        return new GridLayoutFactory(new GridLayout());
    }

    public static GridLayoutFactory fillDefaults() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        Point point = LayoutConstants.getSpacing();
        gridLayout.horizontalSpacing = point.x;
        gridLayout.verticalSpacing = point.y;
        return new GridLayoutFactory(gridLayout);
    }

    public GridLayoutFactory equalWidth(boolean bl) {
        this.l.makeColumnsEqualWidth = bl;
        return this;
    }

    public GridLayoutFactory spacing(int n, int n2) {
        this.l.horizontalSpacing = n;
        this.l.verticalSpacing = n2;
        return this;
    }

    public GridLayoutFactory spacing(Point point) {
        this.l.horizontalSpacing = point.x;
        this.l.verticalSpacing = point.y;
        return this;
    }

    public GridLayoutFactory margins(Point point) {
        this.l.marginWidth = point.x;
        this.l.marginHeight = point.y;
        return this;
    }

    public GridLayoutFactory margins(int n, int n2) {
        this.l.marginWidth = n;
        this.l.marginHeight = n2;
        return this;
    }

    public GridLayoutFactory extendedMargins(int n, int n2, int n3, int n4) {
        this.l.marginLeft = n;
        this.l.marginRight = n2;
        this.l.marginTop = n3;
        this.l.marginBottom = n4;
        return this;
    }

    public GridLayoutFactory extendedMargins(Rectangle rectangle) {
        this.l.marginLeft = -rectangle.x;
        this.l.marginTop = -rectangle.y;
        this.l.marginBottom = rectangle.y + rectangle.height;
        this.l.marginRight = rectangle.x + rectangle.width;
        return this;
    }

    public GridLayoutFactory numColumns(int n) {
        this.l.numColumns = n;
        return this;
    }

    public GridLayout create() {
        return GridLayoutFactory.copyLayout(this.l);
    }

    public void applyTo(Composite composite) {
        composite.setLayout((Layout)GridLayoutFactory.copyLayout(this.l));
    }

    public static GridLayout copyLayout(GridLayout gridLayout) {
        GridLayout gridLayout2 = new GridLayout(gridLayout.numColumns, gridLayout.makeColumnsEqualWidth);
        gridLayout2.horizontalSpacing = gridLayout.horizontalSpacing;
        gridLayout2.marginBottom = gridLayout.marginBottom;
        gridLayout2.marginHeight = gridLayout.marginHeight;
        gridLayout2.marginLeft = gridLayout.marginLeft;
        gridLayout2.marginRight = gridLayout.marginRight;
        gridLayout2.marginTop = gridLayout.marginTop;
        gridLayout2.marginWidth = gridLayout.marginWidth;
        gridLayout2.verticalSpacing = gridLayout.verticalSpacing;
        return gridLayout2;
    }

    public void generateLayout(Composite composite) {
        this.applyTo(composite);
        LayoutGenerator.generateLayout(composite);
    }
}

