/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontRegistry
extends ResourceRegistry {
    private Map stringToFontRecord = new HashMap(7);
    private Map stringToFontData = new HashMap(7);
    private List staleFonts = new ArrayList();
    protected Runnable displayRunnable = new Runnable(){

        public void run() {
            FontRegistry.this.clearCaches();
        }
    };

    public FontRegistry() {
        this(Display.getCurrent(), true);
    }

    public FontRegistry(String string, ClassLoader classLoader) throws MissingResourceException {
        Display display = Display.getCurrent();
        Assert.isNotNull(display);
        this.readResourceBundle(string);
        this.hookDisplayDispose(display);
    }

    public FontRegistry(String string) throws MissingResourceException {
        this(string, null);
    }

    private void readResourceBundle(String string) {
        block7: {
            String string2 = System.getProperty("os.name").trim();
            String string3 = SWT.getPlatform();
            string2 = StringConverter.removeWhiteSpaces(string2).toLowerCase();
            string3 = StringConverter.removeWhiteSpaces(string3).toLowerCase();
            String string4 = string;
            String string5 = string;
            ResourceBundle resourceBundle = null;
            if (string2 != null) {
                string4 = string + "_" + string2;
                if (string3 != null) {
                    string5 = string4 + "_" + string3;
                }
            }
            try {
                resourceBundle = ResourceBundle.getBundle(string5);
                this.readResourceBundle(resourceBundle, string5);
            }
            catch (MissingResourceException missingResourceException) {
                try {
                    resourceBundle = ResourceBundle.getBundle(string4);
                    this.readResourceBundle(resourceBundle, string5);
                }
                catch (MissingResourceException missingResourceException2) {
                    if (string != string4) {
                        resourceBundle = ResourceBundle.getBundle(string);
                        this.readResourceBundle(resourceBundle, string5);
                        break block7;
                    }
                    throw missingResourceException2;
                }
            }
        }
    }

    public FontRegistry(Display display) {
        this(display, true);
    }

    public FontRegistry(Display display, boolean bl) {
        Assert.isNotNull(display);
        if (bl) {
            this.hookDisplayDispose(display);
        }
    }

    public FontData bestData(FontData[] fontDataArray, Display display) {
        FontData fontData;
        for (int i = 0; i < fontDataArray.length && (fontData = fontDataArray[i]) != null; ++i) {
            FontData[] fontDataArray2 = display.getFontList(fontData.getName(), false);
            if (this.isFixedFont(fontDataArray2, fontData)) {
                return fontData;
            }
            FontData[] fontDataArray3 = display.getFontList(fontData.getName(), true);
            if (fontDataArray3.length <= 0) continue;
            return fontData;
        }
        if (fontDataArray.length > 0) {
            return fontDataArray[0];
        }
        return null;
    }

    public FontData[] bestDataArray(FontData[] fontDataArray, Display display) {
        FontData fontData = this.bestData(fontDataArray, display);
        if (fontData == null) {
            return null;
        }
        FontData[] fontDataArray2 = new FontData[]{fontData};
        return fontDataArray2;
    }

    public FontData[] filterData(FontData[] fontDataArray, Display display) {
        ArrayList<FontData> arrayList = new ArrayList<FontData>(fontDataArray.length);
        for (int i = 0; i < fontDataArray.length; ++i) {
            FontData[] fontDataArray2;
            FontData fontData = fontDataArray[i];
            if (fontData == null) continue;
            FontData[] fontDataArray3 = display.getFontList(fontData.getName(), false);
            if (this.isFixedFont(fontDataArray3, fontData)) {
                arrayList.add(fontData);
            }
            if ((fontDataArray2 = display.getFontList(fontData.getName(), true)).length <= 0) continue;
            arrayList.add(fontData);
        }
        if (arrayList.isEmpty() && fontDataArray.length > 0) {
            arrayList.add(fontDataArray[0]);
        } else if (fontDataArray.length == 0) {
            return null;
        }
        return arrayList.toArray(new FontData[arrayList.size()]);
    }

    private FontRecord createFont(String string, FontData[] fontDataArray) {
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        FontData[] fontDataArray2 = this.filterData(fontDataArray, display);
        if (fontDataArray2.length == 0) {
            return null;
        }
        this.put(string, fontDataArray2, false);
        Font font = new Font((Device)display, fontDataArray2);
        return new FontRecord(font, fontDataArray2);
    }

    Font calculateDefaultFont() {
        Display display = Display.getCurrent();
        if (display == null) {
            Shell shell = new Shell();
            Font font = new Font(null, shell.getFont().getFontData());
            shell.dispose();
            return font;
        }
        return new Font((Device)display, display.getSystemFont().getFontData());
    }

    public Font defaultFont() {
        return this.defaultFontRecord().getBaseFont();
    }

    public FontDescriptor getDescriptor(String string) {
        Assert.isNotNull(string);
        return FontDescriptor.createFrom(this.getFontData(string));
    }

    private FontRecord defaultFontRecord() {
        FontRecord fontRecord = (FontRecord)this.stringToFontRecord.get("org.eclipse.jface.defaultfont");
        if (fontRecord == null) {
            Font font = this.calculateDefaultFont();
            fontRecord = this.createFont("org.eclipse.jface.defaultfont", font.getFontData());
            font.dispose();
            this.stringToFontRecord.put("org.eclipse.jface.defaultfont", fontRecord);
        }
        return fontRecord;
    }

    private FontData[] defaultFontData() {
        return this.defaultFontRecord().baseData;
    }

    public FontData[] getFontData(String string) {
        Assert.isNotNull(string);
        Object v = this.stringToFontData.get(string);
        if (v == null) {
            return this.defaultFontData();
        }
        return (FontData[])v;
    }

    public Font get(String string) {
        return this.getFontRecord(string).getBaseFont();
    }

    public Font getBold(String string) {
        return this.getFontRecord(string).getBoldFont();
    }

    public Font getItalic(String string) {
        return this.getFontRecord(string).getItalicFont();
    }

    private FontRecord getFontRecord(String string) {
        Assert.isNotNull(string);
        Object v = this.stringToFontRecord.get(string);
        if (v != null) {
            return (FontRecord)v;
        }
        v = this.stringToFontData.get(string);
        FontRecord fontRecord = v == null ? this.defaultFontRecord() : this.createFont(string, (FontData[])v);
        if (fontRecord == null) {
            fontRecord = this.defaultFontRecord();
        }
        this.stringToFontRecord.put(string, fontRecord);
        return fontRecord;
    }

    public Set getKeySet() {
        return Collections.unmodifiableSet(this.stringToFontData.keySet());
    }

    public boolean hasValueFor(String string) {
        return this.stringToFontData.containsKey(string);
    }

    protected void clearCaches() {
        Iterator iterator = this.stringToFontRecord.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            ((FontRecord)v).dispose();
        }
        this.disposeFonts(this.staleFonts.iterator());
        this.stringToFontRecord.clear();
        this.staleFonts.clear();
    }

    private void disposeFonts(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ((Font)e).dispose();
        }
    }

    private void hookDisplayDispose(Display display) {
        display.disposeExec(this.displayRunnable);
    }

    private boolean isFixedFont(FontData[] fontDataArray, FontData fontData) {
        int n = fontData.getHeight();
        String string = fontData.getName();
        for (int i = 0; i < fontDataArray.length; ++i) {
            FontData fontData2 = fontDataArray[i];
            if (fontData2.getHeight() != n || !fontData2.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private FontData makeFontData(String string) throws MissingResourceException {
        try {
            return StringConverter.asFontData(string.trim());
        }
        catch (DataFormatException dataFormatException) {
            throw new MissingResourceException("Wrong font data format. Value is: \"" + string + "\"", this.getClass().getName(), string);
        }
    }

    public void put(String string, FontData[] fontDataArray) {
        this.put(string, fontDataArray, true);
    }

    private void put(String string, FontData[] fontDataArray, boolean bl) {
        Assert.isNotNull(string);
        Assert.isNotNull(fontDataArray);
        Object[] objectArray = (FontData[])this.stringToFontData.get(string);
        if (Arrays.equals(objectArray, fontDataArray)) {
            return;
        }
        FontRecord fontRecord = (FontRecord)this.stringToFontRecord.remove(string);
        this.stringToFontData.put(string, fontDataArray);
        if (bl) {
            this.fireMappingChanged(string, objectArray, fontDataArray);
        }
        if (fontRecord != null) {
            fontRecord.addAllocatedFontsToStale(this.defaultFontRecord().getBaseFont());
        }
    }

    private void readResourceBundle(ResourceBundle resourceBundle, String string) throws MissingResourceException {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            int n = string2.lastIndexOf(46);
            if (n == -1) {
                this.stringToFontData.put(string2, new FontData[]{this.makeFontData(resourceBundle.getString(string2))});
                continue;
            }
            String string3 = string2.substring(0, n);
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string2.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new MissingResourceException("Wrong key format ", string, string2);
            }
            FontData[] fontDataArray = (FontData[])this.stringToFontData.get(string3);
            if (fontDataArray == null) {
                fontDataArray = new FontData[8];
                this.stringToFontData.put(string3, fontDataArray);
            }
            if (n2 > fontDataArray.length) {
                FontData[] fontDataArray2 = new FontData[n2 + 8];
                System.arraycopy(fontDataArray, 0, fontDataArray2, 0, fontDataArray.length);
                fontDataArray = fontDataArray2;
                this.stringToFontData.put(string3, fontDataArray);
            }
            fontDataArray[n2] = this.makeFontData(resourceBundle.getString(string2));
        }
    }

    public FontDescriptor defaultFontDescriptor() {
        return FontDescriptor.createFrom(this.defaultFontData());
    }

    private class FontRecord {
        Font baseFont;
        Font boldFont;
        Font italicFont;
        FontData[] baseData;

        FontRecord(Font font, FontData[] fontDataArray) {
            this.baseFont = font;
            this.baseData = fontDataArray;
        }

        void dispose() {
            this.baseFont.dispose();
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (this.italicFont != null) {
                this.italicFont.dispose();
            }
        }

        public Font getBaseFont() {
            return this.baseFont;
        }

        public Font getBoldFont() {
            if (this.boldFont != null) {
                return this.boldFont;
            }
            FontData[] fontDataArray = this.getModifiedFontData(1);
            this.boldFont = new Font((Device)Display.getCurrent(), fontDataArray);
            return this.boldFont;
        }

        private FontData[] getModifiedFontData(int n) {
            FontData[] fontDataArray = new FontData[this.baseData.length];
            for (int i = 0; i < fontDataArray.length; ++i) {
                FontData fontData = this.baseData[i];
                fontDataArray[i] = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle() | n);
            }
            return fontDataArray;
        }

        public Font getItalicFont() {
            if (this.italicFont != null) {
                return this.italicFont;
            }
            FontData[] fontDataArray = this.getModifiedFontData(2);
            this.italicFont = new Font((Device)Display.getCurrent(), fontDataArray);
            return this.italicFont;
        }

        void addAllocatedFontsToStale(Font font) {
            if (font != this.baseFont && this.baseFont != null) {
                FontRegistry.this.staleFonts.add(this.baseFont);
            }
            if (font != this.boldFont && this.boldFont != null) {
                FontRegistry.this.staleFonts.add(this.boldFont);
            }
            if (font != this.italicFont && this.italicFont != null) {
                FontRegistry.this.staleFonts.add(this.italicFont);
            }
        }
    }
}

