/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

public class ListenerList {
    private static final Object[] EmptyArray = new Object[0];
    public static final int EQUALITY = 0;
    public static final int IDENTITY = 1;
    private final boolean identity;
    private volatile Object[] listeners = EmptyArray;

    public ListenerList() {
        this(0);
    }

    public ListenerList(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.identity = n == 1;
    }

    public synchronized void add(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = this.listeners.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = this.listeners[i];
            if (!(this.identity ? object == object2 : object.equals(object2))) continue;
            return;
        }
        Object[] objectArray = new Object[n + 1];
        System.arraycopy(this.listeners, 0, objectArray, 0, n);
        objectArray[n] = object;
        this.listeners = objectArray;
    }

    public Object[] getListeners() {
        return this.listeners;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void remove(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = this.listeners.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = this.listeners[i];
            if (!(this.identity ? object == object2 : object.equals(object2))) continue;
            if (n == 1) {
                this.listeners = EmptyArray;
            } else {
                Object[] objectArray = new Object[n - 1];
                System.arraycopy(this.listeners, 0, objectArray, 0, i);
                System.arraycopy(this.listeners, i + 1, objectArray, i, n - i - 1);
                this.listeners = objectArray;
            }
            return;
        }
    }

    public int size() {
        return this.listeners.length;
    }

    public synchronized void clear() {
        this.listeners = EmptyArray;
    }
}

